/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.confluent.telemetry.events;

import io.confluent.shaded.io.confluent.telemetry.events.exporter.ExporterConfig;
import io.confluent.telemetry.ExporterUtils;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

public class EventEmitterConfig
extends AbstractConfig {
    private final EnumMap<EventType, Map<String, Map<String, Object>>> typedExporterConfigs = new EnumMap(EventType.class);

    public EventEmitterConfig(Map<String, ?> configs) {
        super(new ConfigDef(), configs);
        Map<String, Map<String, Object>> exporterConfigs = this.createNamedExporterConfigMap();
        for (EventType eventType : EventType.values()) {
            this.typedExporterConfigs.put(eventType, this.createEnabledExporterConfigs(exporterConfigs, eventType));
        }
    }

    private Map<String, Map<String, Object>> createNamedExporterConfigMap() {
        Map configsWithoutExporterPrefix = this.originalsWithPrefix("confluent.telemetry.exporter.");
        HashMap<String, Map<String, Object>> exporterConfigs = new HashMap<String, Map<String, Object>>();
        ExporterUtils.parseExporterConfigsByName(exporterConfigs, configsWithoutExporterPrefix);
        return exporterConfigs;
    }

    public Map<String, Map<String, Object>> getEnabledExporterConfigs(EventType eventType) {
        return this.typedExporterConfigs.get((Object)eventType);
    }

    private Map<String, Map<String, Object>> createEnabledExporterConfigs(Map<String, Map<String, Object>> exporterConfigs, EventType eventType) {
        HashMap<String, Map<String, Object>> exporterConfigsOfEventType = new HashMap<String, Map<String, Object>>();
        for (String exporterName : exporterConfigs.keySet()) {
            if (!this.isEventsExporterEnabled(exporterConfigs.get(exporterName))) continue;
            Map<String, Object> map = exporterConfigs.get(exporterName);
            HashMap<String, Object> updatedMap = new HashMap<String, Object>();
            updatedMap.putAll(this.parseTypeSpecificConfigs(map, eventType));
            updatedMap.putAll(this.parseCommonConfigs(map));
            if (eventType == EventType.events && this.isEventExporter(exporterConfigs.get(exporterName))) {
                exporterConfigsOfEventType.put(exporterName, updatedMap);
                continue;
            }
            if (eventType != EventType.metrics) continue;
            exporterConfigsOfEventType.put(exporterName, updatedMap);
        }
        return exporterConfigsOfEventType;
    }

    private Map<String, Object> parseTypeSpecificConfigs(Map<String, Object> map, EventType eventType) {
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        String eventTypePrefix = eventType.name() + ".";
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String newKey;
            if (!entry.getKey().startsWith(eventTypePrefix) || ExporterConfig.EXPORTER_COMMON_CONFIGS.contains(newKey = entry.getKey().substring(eventTypePrefix.length()))) continue;
            resMap.put(newKey, entry.getValue());
        }
        if (eventType == EventType.metrics) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                if (entry.getKey().startsWith(eventTypePrefix) || ExporterConfig.EXPORTER_COMMON_CONFIGS.contains(entry.getKey())) continue;
                if (resMap.containsKey(entry.getKey())) {
                    throw new ConfigException(entry.getKey() + " is defined twice, one with \"metrics.\" prefix, one without \"metrics.\" prefix, only one should be defined");
                }
                resMap.put(entry.getKey(), entry.getValue());
            }
        }
        return resMap;
    }

    private Map<String, Object> parseCommonConfigs(Map<String, Object> map) {
        HashMap<String, Object> commonConfigs = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (ExporterConfig.EXPORTER_COMMON_CONFIGS.contains(entry.getKey())) {
                commonConfigs.put(entry.getKey(), entry.getValue());
            }
            for (String prefix : ExporterConfig.EXPORTER_COMMON_CONFIG_PREFIXES) {
                if (!entry.getKey().startsWith(prefix)) continue;
                commonConfigs.put(entry.getKey(), entry.getValue());
            }
        }
        return commonConfigs;
    }

    public Map<String, Map<String, Object>> getNonInternalExporterConfigs(EventType dataType) {
        Map<String, Map<String, Object>> exporterConfigsOfDataType = this.getEnabledExporterConfigs(dataType);
        exporterConfigsOfDataType.entrySet().stream().filter(entry -> !this.isInternalExporter((String)entry.getKey())).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Map)e.getValue()));
        return exporterConfigsOfDataType;
    }

    public boolean isKafkaExporter(Map<String, Object> exporterConfig) {
        ExporterConfig.ExporterType exporterType = ExporterConfig.parseType(exporterConfig.get("type"));
        return exporterType == ExporterConfig.ExporterType.kafka;
    }

    public boolean isInternalExporter(String exporterName) {
        return exporterName.startsWith("_");
    }

    public boolean isEventExporter(Map<String, Object> exporterConfig) {
        if (exporterConfig == null) {
            return false;
        }
        for (String prop : exporterConfig.keySet()) {
            if (!prop.startsWith(EventType.events.name() + ".")) continue;
            return true;
        }
        return false;
    }

    public boolean isEventsExporterEnabled(Map<String, Object> exporterConfig) {
        if (exporterConfig == null) {
            return false;
        }
        Boolean isEnabled = (Boolean)ConfigDef.parseType((String)"enabled", (Object)exporterConfig.get("enabled"), (ConfigDef.Type)ConfigDef.Type.BOOLEAN);
        if (isEnabled == null) {
            isEnabled = true;
        }
        if (!isEnabled.booleanValue()) {
            return false;
        }
        Boolean eventEnabled = (Boolean)ConfigDef.parseType((String)"events.enabled", (Object)exporterConfig.get("events.enabled"), (ConfigDef.Type)ConfigDef.Type.BOOLEAN);
        if (eventEnabled == null) {
            eventEnabled = true;
        }
        return eventEnabled;
    }

    public static enum EventType {
        events,
        metrics;

    }
}

