/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.confluent.telemetry.events.exporter;

import io.confluent.shaded.com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

public class ExporterConfig
extends AbstractConfig {
    public static final String ENABLED_CONFIG = "enabled";
    public static final String ENABLED_CONFIG_DOC = "Boolean value. True exporter should be enabled, false otherwise.";
    public static final boolean ENABLED_CONFIG_DEFAULT = true;
    public static final String TYPE_CONFIG = "type";
    public static final String TYPE_CONFIG_DOC = "The type of the exporter. Value must be on of " + Arrays.asList(ExporterType.values());
    public static final String METRICS_ENABLED_CONFIG = "metrics.enabled";
    public static final String METRICS_ENABLED_CONFIG_DOC = "Boolean value. True if telemetry metrics should be reported.";
    public static final boolean METRICS_ENABLED_CONFIG_DEFAULT = true;
    public static final String EVENTS_ENABLED_CONFIG = "events.enabled";
    public static final String EVENTS_ENABLED_CONFIG_DOC = "Boolean value. True if telemetry events should be reported.";
    public static final boolean EVENTS_ENABLED_CONFIG_DEFAULT = true;
    public static final String PREFIX_EXPORTER = "confluent.telemetry.exporter.";
    public static final String PREFIX_EVENTS = "events.";
    public static final Set<String> EXPORTER_COMMON_CONFIGS = ImmutableSet.of("type", "enabled");
    public static final Set<String> EXPORTER_COMMON_CONFIG_PREFIXES = ImmutableSet.of("producer.");
    public static final Set<String> RECONFIGURABLES = ImmutableSet.of("enabled");

    private static ConfigDef defineExporterConfigs(ConfigDef def) {
        return new ConfigDef(def).define(ENABLED_CONFIG, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, ENABLED_CONFIG_DOC).define(TYPE_CONFIG, ConfigDef.Type.STRING, ConfigDef.NO_DEFAULT_VALUE, (ConfigDef.Validator)ConfigDef.LambdaValidator.with((name, value) -> ExporterConfig.parseType(value), () -> Arrays.asList(ExporterType.values()).toString()), ConfigDef.Importance.LOW, TYPE_CONFIG_DOC).define(METRICS_ENABLED_CONFIG, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, METRICS_ENABLED_CONFIG_DOC).define(EVENTS_ENABLED_CONFIG, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, EVENTS_ENABLED_CONFIG_DOC);
    }

    public static ExporterType parseType(Object value) {
        if (value == null || value.toString().isEmpty()) {
            throw new ConfigException("'type' is a required config.");
        }
        try {
            return ExporterType.valueOf(value.toString());
        }
        catch (IllegalArgumentException e) {
            throw new ConfigException("'type' must be one of: " + Arrays.asList(ExporterType.values()) + " however we found '" + value.toString() + "'");
        }
    }

    public ExporterConfig(Map<String, ?> originals) {
        super(ExporterConfig.defineExporterConfigs(new ConfigDef()), originals);
    }

    public ExporterConfig(ConfigDef definition, Map<?, ?> originals) {
        this(definition, originals, true);
    }

    public ExporterConfig(ConfigDef definition, Map<?, ?> originals, boolean doLog) {
        super(ExporterConfig.defineExporterConfigs(definition), originals, doLog);
    }

    public static enum ExporterType {
        http,
        kafka,
        test;

    }
}

