/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.confluent.telemetry.events.exporter.kafka;

import io.confluent.shaded.io.cloudevents.CloudEvent;
import io.confluent.shaded.io.cloudevents.core.format.EventFormat;
import io.confluent.shaded.io.cloudevents.core.message.MessageWriter;
import io.confluent.shaded.io.cloudevents.core.provider.EventFormatProvider;
import io.confluent.shaded.io.cloudevents.kafka.KafkaMessageFactory;
import io.confluent.shaded.io.cloudevents.rw.CloudEventWriter;
import io.confluent.shaded.io.confluent.telemetry.events.EventUtils;
import io.confluent.shaded.io.confluent.telemetry.events.exporter.kafka.KafkaExporter;
import io.confluent.telemetry.api.events.Event;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventKafkaExporter
extends KafkaExporter<Event> {
    private static final Logger log = LoggerFactory.getLogger(EventKafkaExporter.class);
    private final EventFormat structuredEventFormat = EventFormatProvider.getInstance().resolveFormat("application/cloudevents+json");

    public EventKafkaExporter() {
        this(KafkaProducer::new);
    }

    EventKafkaExporter(Function<Properties, Producer<String, byte[]>> producerFactory) {
        super(producerFactory);
    }

    @Override
    public void configure(Map<String, ?> configs) {
        super.configure(configs);
        this.responseDeserializer = event -> {
            String topic = this.topicName;
            if (event.extensionNames().contains("route")) {
                topic = event.extension("route");
            }
            CloudEvent data = EventUtils.toCloudEvent(event);
            MessageWriter<CloudEventWriter<ProducerRecord<String, byte[]>>, ProducerRecord<String, byte[]>> messageWriter = KafkaMessageFactory.createWriter(topic, event.extension("partitionkey"));
            switch (this.config.getEncoding()) {
                case STRUCTURED: {
                    return messageWriter.writeStructured(data, this.structuredEventFormat);
                }
                case BINARY: {
                    return messageWriter.writeBinary(data);
                }
            }
            throw new RuntimeException("Unknown encoding " + (Object)((Object)this.config.getEncoding()));
        };
    }
}

