/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.confluent.telemetry.events.exporter.kafka.async;

import io.confluent.shaded.com.google.common.annotations.VisibleForTesting;
import io.confluent.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.confluent.shaded.io.confluent.telemetry.events.exporter.Exporter;
import io.confluent.shaded.io.confluent.telemetry.events.exporter.kafka.async.TopicSupplier;
import java.io.Closeable;
import java.time.Clock;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.config.ConfigException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncKafkaExporter<T>
implements Exporter<T> {
    private static final Logger log = LoggerFactory.getLogger(AsyncKafkaExporter.class);
    private final EmitterThread<T> emitterThread;
    private final BlockingDeque<Tuple<T>> buffer;
    private final ExecutorService executorService;
    private final Producer<String, byte[]> producer;
    private volatile boolean isClosed = false;

    @VisibleForTesting
    protected AsyncKafkaExporter(int bufferSize, TopicSupplier<T> topicSupplier, Producer<String, byte[]> producer, Function<T, ProducerRecord<String, byte[]>> dataSerializer) {
        if (bufferSize < 1) {
            throw new IllegalArgumentException("Buffer size can not be less than 1");
        }
        this.buffer = new LinkedBlockingDeque<Tuple<T>>(bufferSize);
        this.executorService = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("async-kafka-exporter-%d").build());
        this.producer = producer;
        this.emitterThread = new EmitterThread<T>(this.producer, topicSupplier, this.buffer, dataSerializer);
        this.executorService.submit(this.emitterThread);
    }

    protected AsyncKafkaExporter(Properties producerProperties, int bufferSize, TopicSupplier<T> topicSupplier, Function<T, ProducerRecord<String, byte[]>> dataSerializer) {
        this(bufferSize, topicSupplier, (Producer<String, byte[]>)new KafkaProducer(producerProperties), dataSerializer);
    }

    public static <T> Builder<T> newBuilder() {
        return new Builder();
    }

    public Set<String> reconfigurableConfigs() {
        return null;
    }

    public void validateReconfiguration(Map<String, ?> configs) throws ConfigException {
    }

    public void reconfigure(Map<String, ?> configs) {
    }

    public void configure(Map<String, ?> configs) {
    }

    @Override
    public CompletableFuture<Boolean> emit(T t2) {
        if (this.isClosed) {
            return CompletableFuture.completedFuture(false);
        }
        Tuple<T> tuple = new Tuple<T>(t2, new CompletableFuture<Boolean>());
        if (!this.buffer.offer(tuple)) {
            return CompletableFuture.completedFuture(false);
        }
        return tuple.future;
    }

    @VisibleForTesting
    public BlockingDeque<Tuple<T>> buffer() {
        return this.buffer;
    }

    @Override
    public void close() {
        this.buffer.offer(new Tuple<Object>(null, CompletableFuture.completedFuture(true)));
        this.isClosed = true;
        this.emitterThread.close();
        this.executorService.shutdown();
    }

    public Object producer() {
        return this.producer;
    }

    public static class Builder<T> {
        protected Properties producerProperties;
        protected int bufferSize = 500;
        protected TopicSupplier<T> topicSupplier;
        protected Producer<String, byte[]> kafkaProducer;
        protected Function<T, ProducerRecord<String, byte[]>> dataSerializer;

        protected Builder() {
        }

        public Builder<T> withProducerProperties(Properties producerProperties) {
            this.producerProperties = producerProperties;
            return this;
        }

        public Builder<T> withBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        public Builder<T> withTopicSupplier(TopicSupplier<T> topicSupplier) {
            this.topicSupplier = topicSupplier;
            return this;
        }

        public Builder<T> withDataSerializer(Function<T, ProducerRecord<String, byte[]>> dataSerializer) {
            this.dataSerializer = dataSerializer;
            return this;
        }

        public AsyncKafkaExporter<T> build() {
            Objects.requireNonNull(this.producerProperties);
            return new AsyncKafkaExporter<T>(this.producerProperties, this.bufferSize, this.topicSupplier, this.dataSerializer);
        }
    }

    private static class EmitterThread<T>
    implements Runnable,
    Closeable {
        private static final int ERROR_LOG_INTERVAL_MS = 5000;
        protected final AtomicLong droppedEventCount = new AtomicLong();
        protected final AtomicReference<Exception> droppedEventException = new AtomicReference();
        private final Producer<String, byte[]> producer;
        private final TopicSupplier<T> topicSupplier;
        private final BlockingDeque<Tuple<T>> deque;
        private final Function<T, ProducerRecord<String, byte[]>> dataSerializer;
        protected long lastLoggedTimestamp = 0L;
        protected long lastLoggedCount = 0L;
        private volatile boolean isClosed = false;

        public EmitterThread(Producer<String, byte[]> producer, TopicSupplier<T> topicSupplier, BlockingDeque<Tuple<T>> deque, Function<T, ProducerRecord<String, byte[]>> dataSerializer) {
            this.producer = producer;
            this.dataSerializer = dataSerializer;
            this.topicSupplier = topicSupplier;
            this.deque = deque;
        }

        @Override
        public void run() {
            Tuple<T> next;
            Tuple<T> tuple = null;
            try {
                while (!this.isClosed) {
                    tuple = this.deque.take();
                    if (tuple.data == null && tuple.future.isDone()) break;
                    this.produce(tuple);
                }
            }
            catch (Throwable e) {
                Tuple<T> next2;
                block8: {
                    try {
                        log.error("Exception while getting record from queue, Events would not be emitted anymore.", e);
                        if (tuple == null) break block8;
                        tuple.future.completeExceptionally(e);
                    }
                    catch (Throwable throwable) {
                        Tuple<T> next3;
                        while ((next3 = this.deque.poll()) != null) {
                            next3.future.complete(false);
                        }
                        throw throwable;
                    }
                }
                while ((next2 = this.deque.poll()) != null) {
                    next2.future.complete(false);
                }
            }
            while ((next = this.deque.poll()) != null) {
                next.future.complete(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void produce(Tuple<T> tuple) {
            try {
                Optional<String> topic = this.topicSupplier.topic(tuple.data);
                if (!topic.isPresent()) {
                    this.droppedEventCount.incrementAndGet();
                    this.maybeLogException();
                    tuple.future.complete(false);
                    return;
                }
                Producer<String, byte[]> producer = this.producer;
                synchronized (producer) {
                    if (!Thread.currentThread().isInterrupted() && !this.isClosed) {
                        if (log.isTraceEnabled()) {
                            log.trace("Generated telemetry message : {}", tuple.data);
                        }
                        this.producer.send(this.dataSerializer.apply(tuple.data), (metadata, exception) -> {
                            if (exception != null) {
                                this.droppedEventCount.incrementAndGet();
                                this.droppedEventException.compareAndSet(null, exception);
                                tuple.future.completeExceptionally(exception);
                            } else {
                                tuple.future.complete(true);
                            }
                        });
                    } else {
                        tuple.future.complete(false);
                    }
                    this.maybeLogException();
                }
            }
            catch (Throwable e) {
                tuple.future.completeExceptionally(e);
            }
        }

        private void maybeLogException() {
            long now;
            long droppedCount = this.droppedEventCount.get();
            long droppedDelta = droppedCount - this.lastLoggedCount;
            if (droppedDelta > 0L && this.lastLoggedTimestamp + 5000L < (now = Clock.systemUTC().millis())) {
                log.warn("Failed to produce {} telemetry messages {}", (Object)droppedDelta, this.droppedEventException.getAndSet(null));
                this.lastLoggedTimestamp = now;
                this.lastLoggedCount = droppedCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            if (this.producer != null) {
                Producer<String, byte[]> producer = this.producer;
                synchronized (producer) {
                    this.isClosed = true;
                    this.producer.close(Duration.ofSeconds(15L));
                }
            }
        }
    }

    private static class Tuple<T> {
        final T data;
        final CompletableFuture<Boolean> future;

        Tuple(T data, CompletableFuture<Boolean> future) {
            this.data = data;
            this.future = future;
        }
    }
}

