/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.operators.flowable;

import io.confluent.shaded.io.reactivex.Flowable;
import io.confluent.shaded.io.reactivex.FlowableSubscriber;
import io.confluent.shaded.io.reactivex.disposables.Disposable;
import io.confluent.shaded.io.reactivex.exceptions.Exceptions;
import io.confluent.shaded.io.reactivex.internal.functions.ObjectHelper;
import io.confluent.shaded.io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.confluent.shaded.io.reactivex.internal.queue.MpscLinkedQueue;
import io.confluent.shaded.io.reactivex.internal.subscribers.QueueDrainSubscriber;
import io.confluent.shaded.io.reactivex.internal.subscriptions.EmptySubscription;
import io.confluent.shaded.io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.confluent.shaded.io.reactivex.internal.util.QueueDrainHelper;
import io.confluent.shaded.io.reactivex.subscribers.DisposableSubscriber;
import io.confluent.shaded.io.reactivex.subscribers.SerializedSubscriber;
import io.confluent.shaded.org.reactivestreams.Publisher;
import io.confluent.shaded.org.reactivestreams.Subscriber;
import io.confluent.shaded.org.reactivestreams.Subscription;
import java.util.Collection;
import java.util.concurrent.Callable;

public final class FlowableBufferExactBoundary<T, U extends Collection<? super T>, B>
extends AbstractFlowableWithUpstream<T, U> {
    final Publisher<B> boundary;
    final Callable<U> bufferSupplier;

    public FlowableBufferExactBoundary(Flowable<T> source, Publisher<B> boundary, Callable<U> bufferSupplier) {
        super(source);
        this.boundary = boundary;
        this.bufferSupplier = bufferSupplier;
    }

    @Override
    protected void subscribeActual(Subscriber<? super U> s2) {
        this.source.subscribe(new BufferExactBoundarySubscriber(new SerializedSubscriber<U>(s2), this.bufferSupplier, this.boundary));
    }

    static final class BufferBoundarySubscriber<T, U extends Collection<? super T>, B>
    extends DisposableSubscriber<B> {
        final BufferExactBoundarySubscriber<T, U, B> parent;

        BufferBoundarySubscriber(BufferExactBoundarySubscriber<T, U, B> parent) {
            this.parent = parent;
        }

        @Override
        public void onNext(B t2) {
            this.parent.next();
        }

        @Override
        public void onError(Throwable t2) {
            this.parent.onError(t2);
        }

        @Override
        public void onComplete() {
            this.parent.onComplete();
        }
    }

    static final class BufferExactBoundarySubscriber<T, U extends Collection<? super T>, B>
    extends QueueDrainSubscriber<T, U, U>
    implements FlowableSubscriber<T>,
    Subscription,
    Disposable {
        final Callable<U> bufferSupplier;
        final Publisher<B> boundary;
        Subscription upstream;
        Disposable other;
        U buffer;

        BufferExactBoundarySubscriber(Subscriber<? super U> actual, Callable<U> bufferSupplier, Publisher<B> boundary) {
            super(actual, new MpscLinkedQueue());
            this.bufferSupplier = bufferSupplier;
            this.boundary = boundary;
        }

        @Override
        public void onSubscribe(Subscription s2) {
            BufferBoundarySubscriber bs;
            Collection b;
            if (!SubscriptionHelper.validate(this.upstream, s2)) {
                return;
            }
            this.upstream = s2;
            try {
                b = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The buffer supplied is null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.cancelled = true;
                s2.cancel();
                EmptySubscription.error(e, this.downstream);
                return;
            }
            this.buffer = b;
            this.other = bs = new BufferBoundarySubscriber(this);
            this.downstream.onSubscribe(this);
            if (!this.cancelled) {
                s2.request(Long.MAX_VALUE);
                this.boundary.subscribe(bs);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t2) {
            BufferExactBoundarySubscriber bufferExactBoundarySubscriber = this;
            synchronized (bufferExactBoundarySubscriber) {
                U b = this.buffer;
                if (b == null) {
                    return;
                }
                b.add(t2);
            }
        }

        @Override
        public void onError(Throwable t2) {
            this.cancel();
            this.downstream.onError(t2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onComplete() {
            U b;
            BufferExactBoundarySubscriber bufferExactBoundarySubscriber = this;
            synchronized (bufferExactBoundarySubscriber) {
                b = this.buffer;
                if (b == null) {
                    return;
                }
                this.buffer = null;
            }
            this.queue.offer(b);
            this.done = true;
            if (this.enter()) {
                QueueDrainHelper.drainMaxLoop(this.queue, this.downstream, false, this, this);
            }
        }

        @Override
        public void request(long n) {
            this.requested(n);
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.other.dispose();
                this.upstream.cancel();
                if (this.enter()) {
                    this.queue.clear();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void next() {
            U b;
            Collection next;
            try {
                next = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The buffer supplied is null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.cancel();
                this.downstream.onError(e);
                return;
            }
            BufferExactBoundarySubscriber bufferExactBoundarySubscriber = this;
            synchronized (bufferExactBoundarySubscriber) {
                b = this.buffer;
                if (b == null) {
                    return;
                }
                this.buffer = next;
            }
            this.fastPathEmitMax(b, false, this);
        }

        @Override
        public void dispose() {
            this.cancel();
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        @Override
        public boolean accept(Subscriber<? super U> a, U v) {
            this.downstream.onNext(v);
            return true;
        }
    }
}

