/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.operators.flowable;

import io.confluent.shaded.io.reactivex.Flowable;
import io.confluent.shaded.io.reactivex.exceptions.Exceptions;
import io.confluent.shaded.io.reactivex.internal.functions.ObjectHelper;
import io.confluent.shaded.io.reactivex.internal.subscriptions.EmptySubscription;
import io.confluent.shaded.org.reactivestreams.Publisher;
import io.confluent.shaded.org.reactivestreams.Subscriber;
import java.util.concurrent.Callable;

public final class FlowableDefer<T>
extends Flowable<T> {
    final Callable<? extends Publisher<? extends T>> supplier;

    public FlowableDefer(Callable<? extends Publisher<? extends T>> supplier) {
        this.supplier = supplier;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> s2) {
        Publisher<? super T> pub;
        try {
            pub = ObjectHelper.requireNonNull(this.supplier.call(), "The publisher supplied is null");
        }
        catch (Throwable t2) {
            Exceptions.throwIfFatal(t2);
            EmptySubscription.error(t2, s2);
            return;
        }
        pub.subscribe(s2);
    }
}

