/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.operators.flowable;

import io.confluent.shaded.io.reactivex.Flowable;
import io.confluent.shaded.io.reactivex.FlowableSubscriber;
import io.confluent.shaded.io.reactivex.annotations.Nullable;
import io.confluent.shaded.io.reactivex.exceptions.Exceptions;
import io.confluent.shaded.io.reactivex.functions.Action;
import io.confluent.shaded.io.reactivex.internal.fuseable.ConditionalSubscriber;
import io.confluent.shaded.io.reactivex.internal.fuseable.QueueSubscription;
import io.confluent.shaded.io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.confluent.shaded.io.reactivex.internal.subscriptions.BasicIntQueueSubscription;
import io.confluent.shaded.io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.confluent.shaded.io.reactivex.plugins.RxJavaPlugins;
import io.confluent.shaded.org.reactivestreams.Subscriber;
import io.confluent.shaded.org.reactivestreams.Subscription;

public final class FlowableDoFinally<T>
extends AbstractFlowableWithUpstream<T, T> {
    final Action onFinally;

    public FlowableDoFinally(Flowable<T> source, Action onFinally) {
        super(source);
        this.onFinally = onFinally;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s2) {
        if (s2 instanceof ConditionalSubscriber) {
            this.source.subscribe(new DoFinallyConditionalSubscriber((ConditionalSubscriber)s2, this.onFinally));
        } else {
            this.source.subscribe(new DoFinallySubscriber<T>(s2, this.onFinally));
        }
    }

    static final class DoFinallyConditionalSubscriber<T>
    extends BasicIntQueueSubscription<T>
    implements ConditionalSubscriber<T> {
        private static final long serialVersionUID = 4109457741734051389L;
        final ConditionalSubscriber<? super T> downstream;
        final Action onFinally;
        Subscription upstream;
        QueueSubscription<T> qs;
        boolean syncFused;

        DoFinallyConditionalSubscriber(ConditionalSubscriber<? super T> actual, Action onFinally) {
            this.downstream = actual;
            this.onFinally = onFinally;
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                if (s2 instanceof QueueSubscription) {
                    this.qs = (QueueSubscription)s2;
                }
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t2) {
            this.downstream.onNext(t2);
        }

        @Override
        public boolean tryOnNext(T t2) {
            return this.downstream.tryOnNext(t2);
        }

        @Override
        public void onError(Throwable t2) {
            this.downstream.onError(t2);
            this.runFinally();
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
            this.runFinally();
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
            this.runFinally();
        }

        @Override
        public void request(long n) {
            this.upstream.request(n);
        }

        @Override
        public int requestFusion(int mode) {
            QueueSubscription<T> qs = this.qs;
            if (qs != null && (mode & 4) == 0) {
                int m4 = qs.requestFusion(mode);
                if (m4 != 0) {
                    this.syncFused = m4 == 1;
                }
                return m4;
            }
            return 0;
        }

        @Override
        public void clear() {
            this.qs.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.qs.isEmpty();
        }

        @Override
        @Nullable
        public T poll() throws Exception {
            Object v = this.qs.poll();
            if (v == null && this.syncFused) {
                this.runFinally();
            }
            return v;
        }

        void runFinally() {
            if (this.compareAndSet(0, 1)) {
                try {
                    this.onFinally.run();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    RxJavaPlugins.onError(ex);
                }
            }
        }
    }

    static final class DoFinallySubscriber<T>
    extends BasicIntQueueSubscription<T>
    implements FlowableSubscriber<T> {
        private static final long serialVersionUID = 4109457741734051389L;
        final Subscriber<? super T> downstream;
        final Action onFinally;
        Subscription upstream;
        QueueSubscription<T> qs;
        boolean syncFused;

        DoFinallySubscriber(Subscriber<? super T> actual, Action onFinally) {
            this.downstream = actual;
            this.onFinally = onFinally;
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                if (s2 instanceof QueueSubscription) {
                    this.qs = (QueueSubscription)s2;
                }
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t2) {
            this.downstream.onNext(t2);
        }

        @Override
        public void onError(Throwable t2) {
            this.downstream.onError(t2);
            this.runFinally();
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
            this.runFinally();
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
            this.runFinally();
        }

        @Override
        public void request(long n) {
            this.upstream.request(n);
        }

        @Override
        public int requestFusion(int mode) {
            QueueSubscription<T> qs = this.qs;
            if (qs != null && (mode & 4) == 0) {
                int m4 = qs.requestFusion(mode);
                if (m4 != 0) {
                    this.syncFused = m4 == 1;
                }
                return m4;
            }
            return 0;
        }

        @Override
        public void clear() {
            this.qs.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.qs.isEmpty();
        }

        @Override
        @Nullable
        public T poll() throws Exception {
            Object v = this.qs.poll();
            if (v == null && this.syncFused) {
                this.runFinally();
            }
            return v;
        }

        void runFinally() {
            if (this.compareAndSet(0, 1)) {
                try {
                    this.onFinally.run();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    RxJavaPlugins.onError(ex);
                }
            }
        }
    }
}

