/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.operators.flowable;

import io.confluent.shaded.io.reactivex.Flowable;
import io.confluent.shaded.io.reactivex.annotations.Nullable;
import io.confluent.shaded.io.reactivex.internal.functions.ObjectHelper;
import io.confluent.shaded.io.reactivex.internal.fuseable.ConditionalSubscriber;
import io.confluent.shaded.io.reactivex.internal.subscriptions.BasicQueueSubscription;
import io.confluent.shaded.io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.confluent.shaded.io.reactivex.internal.util.BackpressureHelper;
import io.confluent.shaded.org.reactivestreams.Subscriber;

public final class FlowableFromArray<T>
extends Flowable<T> {
    final T[] array;

    public FlowableFromArray(T[] array) {
        this.array = array;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> s2) {
        if (s2 instanceof ConditionalSubscriber) {
            s2.onSubscribe(new ArrayConditionalSubscription<T>((ConditionalSubscriber)s2, this.array));
        } else {
            s2.onSubscribe(new ArraySubscription<T>(s2, this.array));
        }
    }

    static final class ArrayConditionalSubscription<T>
    extends BaseArraySubscription<T> {
        private static final long serialVersionUID = 2587302975077663557L;
        final ConditionalSubscriber<? super T> downstream;

        ArrayConditionalSubscription(ConditionalSubscriber<? super T> actual, T[] array) {
            super(array);
            this.downstream = actual;
        }

        @Override
        void fastPath() {
            Object[] arr = this.array;
            int f = arr.length;
            ConditionalSubscriber<Object> a = this.downstream;
            for (int i = this.index; i != f; ++i) {
                if (this.cancelled) {
                    return;
                }
                Object t2 = arr[i];
                if (t2 == null) {
                    a.onError(new NullPointerException("The element at index " + i + " is null"));
                    return;
                }
                a.tryOnNext(t2);
            }
            if (this.cancelled) {
                return;
            }
            a.onComplete();
        }

        @Override
        void slowPath(long r) {
            long e = 0L;
            Object[] arr = this.array;
            int f = arr.length;
            int i = this.index;
            ConditionalSubscriber<Object> a = this.downstream;
            while (true) {
                if (e != r && i != f) {
                    if (this.cancelled) {
                        return;
                    }
                    Object t2 = arr[i];
                    if (t2 == null) {
                        a.onError(new NullPointerException("The element at index " + i + " is null"));
                        return;
                    }
                    if (a.tryOnNext(t2)) {
                        ++e;
                    }
                    ++i;
                    continue;
                }
                if (i == f) {
                    if (!this.cancelled) {
                        a.onComplete();
                    }
                    return;
                }
                r = this.get();
                if (e != r) continue;
                this.index = i;
                r = this.addAndGet(-e);
                if (r == 0L) {
                    return;
                }
                e = 0L;
            }
        }
    }

    static final class ArraySubscription<T>
    extends BaseArraySubscription<T> {
        private static final long serialVersionUID = 2587302975077663557L;
        final Subscriber<? super T> downstream;

        ArraySubscription(Subscriber<? super T> actual, T[] array) {
            super(array);
            this.downstream = actual;
        }

        @Override
        void fastPath() {
            Object[] arr = this.array;
            int f = arr.length;
            Subscriber<Object> a = this.downstream;
            for (int i = this.index; i != f; ++i) {
                if (this.cancelled) {
                    return;
                }
                Object t2 = arr[i];
                if (t2 == null) {
                    a.onError(new NullPointerException("The element at index " + i + " is null"));
                    return;
                }
                a.onNext(t2);
            }
            if (this.cancelled) {
                return;
            }
            a.onComplete();
        }

        @Override
        void slowPath(long r) {
            long e = 0L;
            Object[] arr = this.array;
            int f = arr.length;
            int i = this.index;
            Subscriber<Object> a = this.downstream;
            while (true) {
                if (e != r && i != f) {
                    if (this.cancelled) {
                        return;
                    }
                    Object t2 = arr[i];
                    if (t2 == null) {
                        a.onError(new NullPointerException("The element at index " + i + " is null"));
                        return;
                    }
                    a.onNext(t2);
                    ++e;
                    ++i;
                    continue;
                }
                if (i == f) {
                    if (!this.cancelled) {
                        a.onComplete();
                    }
                    return;
                }
                r = this.get();
                if (e != r) continue;
                this.index = i;
                r = this.addAndGet(-e);
                if (r == 0L) {
                    return;
                }
                e = 0L;
            }
        }
    }

    static abstract class BaseArraySubscription<T>
    extends BasicQueueSubscription<T> {
        private static final long serialVersionUID = -2252972430506210021L;
        final T[] array;
        int index;
        volatile boolean cancelled;

        BaseArraySubscription(T[] array) {
            this.array = array;
        }

        @Override
        public final int requestFusion(int mode) {
            return mode & 1;
        }

        @Override
        @Nullable
        public final T poll() {
            int i = this.index;
            T[] arr = this.array;
            if (i == arr.length) {
                return null;
            }
            this.index = i + 1;
            return ObjectHelper.requireNonNull(arr[i], "array element is null");
        }

        @Override
        public final boolean isEmpty() {
            return this.index == this.array.length;
        }

        @Override
        public final void clear() {
            this.index = this.array.length;
        }

        @Override
        public final void request(long n) {
            if (SubscriptionHelper.validate(n) && BackpressureHelper.add(this, n) == 0L) {
                if (n == Long.MAX_VALUE) {
                    this.fastPath();
                } else {
                    this.slowPath(n);
                }
            }
        }

        @Override
        public final void cancel() {
            this.cancelled = true;
        }

        abstract void fastPath();

        abstract void slowPath(long var1);
    }
}

