/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.operators.flowable;

import io.confluent.shaded.io.reactivex.Flowable;
import io.confluent.shaded.io.reactivex.annotations.Nullable;
import io.confluent.shaded.io.reactivex.functions.Function;
import io.confluent.shaded.io.reactivex.internal.functions.ObjectHelper;
import io.confluent.shaded.io.reactivex.internal.fuseable.ConditionalSubscriber;
import io.confluent.shaded.io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.confluent.shaded.io.reactivex.internal.subscribers.BasicFuseableConditionalSubscriber;
import io.confluent.shaded.io.reactivex.internal.subscribers.BasicFuseableSubscriber;
import io.confluent.shaded.org.reactivestreams.Subscriber;

public final class FlowableMap<T, U>
extends AbstractFlowableWithUpstream<T, U> {
    final Function<? super T, ? extends U> mapper;

    public FlowableMap(Flowable<T> source, Function<? super T, ? extends U> mapper) {
        super(source);
        this.mapper = mapper;
    }

    @Override
    protected void subscribeActual(Subscriber<? super U> s2) {
        if (s2 instanceof ConditionalSubscriber) {
            this.source.subscribe(new MapConditionalSubscriber<T, U>((ConditionalSubscriber)s2, this.mapper));
        } else {
            this.source.subscribe(new MapSubscriber<T, U>(s2, this.mapper));
        }
    }

    static final class MapConditionalSubscriber<T, U>
    extends BasicFuseableConditionalSubscriber<T, U> {
        final Function<? super T, ? extends U> mapper;

        MapConditionalSubscriber(ConditionalSubscriber<? super U> actual, Function<? super T, ? extends U> function) {
            super(actual);
            this.mapper = function;
        }

        @Override
        public void onNext(T t2) {
            U v;
            if (this.done) {
                return;
            }
            if (this.sourceMode != 0) {
                this.downstream.onNext(null);
                return;
            }
            try {
                v = ObjectHelper.requireNonNull(this.mapper.apply(t2), "The mapper function returned a null value.");
            }
            catch (Throwable ex) {
                this.fail(ex);
                return;
            }
            this.downstream.onNext(v);
        }

        @Override
        public boolean tryOnNext(T t2) {
            U v;
            if (this.done) {
                return false;
            }
            try {
                v = ObjectHelper.requireNonNull(this.mapper.apply(t2), "The mapper function returned a null value.");
            }
            catch (Throwable ex) {
                this.fail(ex);
                return true;
            }
            return this.downstream.tryOnNext(v);
        }

        @Override
        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        @Override
        @Nullable
        public U poll() throws Exception {
            Object t2 = this.qs.poll();
            return t2 != null ? (U)ObjectHelper.requireNonNull(this.mapper.apply(t2), "The mapper function returned a null value.") : null;
        }
    }

    static final class MapSubscriber<T, U>
    extends BasicFuseableSubscriber<T, U> {
        final Function<? super T, ? extends U> mapper;

        MapSubscriber(Subscriber<? super U> actual, Function<? super T, ? extends U> mapper) {
            super(actual);
            this.mapper = mapper;
        }

        @Override
        public void onNext(T t2) {
            U v;
            if (this.done) {
                return;
            }
            if (this.sourceMode != 0) {
                this.downstream.onNext(null);
                return;
            }
            try {
                v = ObjectHelper.requireNonNull(this.mapper.apply(t2), "The mapper function returned a null value.");
            }
            catch (Throwable ex) {
                this.fail(ex);
                return;
            }
            this.downstream.onNext(v);
        }

        @Override
        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        @Override
        @Nullable
        public U poll() throws Exception {
            Object t2 = this.qs.poll();
            return t2 != null ? (U)ObjectHelper.requireNonNull(this.mapper.apply(t2), "The mapper function returned a null value.") : null;
        }
    }
}

