/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.operators.flowable;

import io.confluent.shaded.io.reactivex.Flowable;
import io.confluent.shaded.io.reactivex.exceptions.CompositeException;
import io.confluent.shaded.io.reactivex.exceptions.Exceptions;
import io.confluent.shaded.io.reactivex.functions.Function;
import io.confluent.shaded.io.reactivex.internal.functions.ObjectHelper;
import io.confluent.shaded.io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.confluent.shaded.io.reactivex.internal.subscribers.SinglePostCompleteSubscriber;
import io.confluent.shaded.org.reactivestreams.Subscriber;

public final class FlowableOnErrorReturn<T>
extends AbstractFlowableWithUpstream<T, T> {
    final Function<? super Throwable, ? extends T> valueSupplier;

    public FlowableOnErrorReturn(Flowable<T> source, Function<? super Throwable, ? extends T> valueSupplier) {
        super(source);
        this.valueSupplier = valueSupplier;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s2) {
        this.source.subscribe(new OnErrorReturnSubscriber<T>(s2, this.valueSupplier));
    }

    static final class OnErrorReturnSubscriber<T>
    extends SinglePostCompleteSubscriber<T, T> {
        private static final long serialVersionUID = -3740826063558713822L;
        final Function<? super Throwable, ? extends T> valueSupplier;

        OnErrorReturnSubscriber(Subscriber<? super T> actual, Function<? super Throwable, ? extends T> valueSupplier) {
            super(actual);
            this.valueSupplier = valueSupplier;
        }

        @Override
        public void onNext(T t2) {
            ++this.produced;
            this.downstream.onNext(t2);
        }

        @Override
        public void onError(Throwable t2) {
            T v;
            try {
                v = ObjectHelper.requireNonNull(this.valueSupplier.apply(t2), "The valueSupplier returned a null value");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.downstream.onError(new CompositeException(t2, ex));
                return;
            }
            this.complete(v);
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }
    }
}

