/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.operators.flowable;

import io.confluent.shaded.io.reactivex.Flowable;
import io.confluent.shaded.io.reactivex.FlowableSubscriber;
import io.confluent.shaded.io.reactivex.Scheduler;
import io.confluent.shaded.io.reactivex.disposables.Disposable;
import io.confluent.shaded.io.reactivex.flowables.ConnectableFlowable;
import io.confluent.shaded.io.reactivex.functions.Consumer;
import io.confluent.shaded.io.reactivex.internal.disposables.DisposableHelper;
import io.confluent.shaded.io.reactivex.internal.disposables.ResettableConnectable;
import io.confluent.shaded.io.reactivex.internal.disposables.SequentialDisposable;
import io.confluent.shaded.io.reactivex.internal.operators.flowable.FlowablePublishClassic;
import io.confluent.shaded.io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.confluent.shaded.io.reactivex.plugins.RxJavaPlugins;
import io.confluent.shaded.org.reactivestreams.Subscriber;
import io.confluent.shaded.org.reactivestreams.Subscription;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class FlowableRefCount<T>
extends Flowable<T> {
    final ConnectableFlowable<T> source;
    final int n;
    final long timeout;
    final TimeUnit unit;
    final Scheduler scheduler;
    RefConnection connection;

    public FlowableRefCount(ConnectableFlowable<T> source) {
        this(source, 1, 0L, TimeUnit.NANOSECONDS, null);
    }

    public FlowableRefCount(ConnectableFlowable<T> source, int n, long timeout, TimeUnit unit, Scheduler scheduler) {
        this.source = source;
        this.n = n;
        this.timeout = timeout;
        this.unit = unit;
        this.scheduler = scheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void subscribeActual(Subscriber<? super T> s2) {
        RefConnection conn;
        boolean connect = false;
        FlowableRefCount flowableRefCount = this;
        synchronized (flowableRefCount) {
            long c;
            conn = this.connection;
            if (conn == null) {
                this.connection = conn = new RefConnection(this);
            }
            if ((c = conn.subscriberCount) == 0L && conn.timer != null) {
                conn.timer.dispose();
            }
            conn.subscriberCount = c + 1L;
            if (!conn.connected && c + 1L == (long)this.n) {
                connect = true;
                conn.connected = true;
            }
        }
        this.source.subscribe((FlowableSubscriber<? super T>)new RefCountSubscriber<T>(s2, this, conn));
        if (connect) {
            this.source.connect(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel(RefConnection rc) {
        SequentialDisposable sd;
        FlowableRefCount flowableRefCount = this;
        synchronized (flowableRefCount) {
            long c;
            if (this.connection == null || this.connection != rc) {
                return;
            }
            rc.subscriberCount = c = rc.subscriberCount - 1L;
            if (c != 0L || !rc.connected) {
                return;
            }
            if (this.timeout == 0L) {
                this.timeout(rc);
                return;
            }
            sd = new SequentialDisposable();
            rc.timer = sd;
        }
        sd.replace(this.scheduler.scheduleDirect(rc, this.timeout, this.unit));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminated(RefConnection rc) {
        FlowableRefCount flowableRefCount = this;
        synchronized (flowableRefCount) {
            if (this.source instanceof FlowablePublishClassic) {
                if (this.connection != null && this.connection == rc) {
                    this.connection = null;
                    this.clearTimer(rc);
                }
                if (--rc.subscriberCount == 0L) {
                    this.reset(rc);
                }
            } else if (this.connection != null && this.connection == rc) {
                this.clearTimer(rc);
                if (--rc.subscriberCount == 0L) {
                    this.connection = null;
                    this.reset(rc);
                }
            }
        }
    }

    void clearTimer(RefConnection rc) {
        if (rc.timer != null) {
            rc.timer.dispose();
            rc.timer = null;
        }
    }

    void reset(RefConnection rc) {
        if (this.source instanceof Disposable) {
            ((Disposable)((Object)this.source)).dispose();
        } else if (this.source instanceof ResettableConnectable) {
            ((ResettableConnectable)((Object)this.source)).resetIf((Disposable)rc.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void timeout(RefConnection rc) {
        FlowableRefCount flowableRefCount = this;
        synchronized (flowableRefCount) {
            if (rc.subscriberCount == 0L && rc == this.connection) {
                this.connection = null;
                Disposable connectionObject = (Disposable)rc.get();
                DisposableHelper.dispose(rc);
                if (this.source instanceof Disposable) {
                    ((Disposable)((Object)this.source)).dispose();
                } else if (this.source instanceof ResettableConnectable) {
                    if (connectionObject == null) {
                        rc.disconnectedEarly = true;
                    } else {
                        ((ResettableConnectable)((Object)this.source)).resetIf(connectionObject);
                    }
                }
            }
        }
    }

    static final class RefCountSubscriber<T>
    extends AtomicBoolean
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = -7419642935409022375L;
        final Subscriber<? super T> downstream;
        final FlowableRefCount<T> parent;
        final RefConnection connection;
        Subscription upstream;

        RefCountSubscriber(Subscriber<? super T> actual, FlowableRefCount<T> parent, RefConnection connection) {
            this.downstream = actual;
            this.parent = parent;
            this.connection = connection;
        }

        @Override
        public void onNext(T t2) {
            this.downstream.onNext(t2);
        }

        @Override
        public void onError(Throwable t2) {
            if (this.compareAndSet(false, true)) {
                this.parent.terminated(this.connection);
                this.downstream.onError(t2);
            } else {
                RxJavaPlugins.onError(t2);
            }
        }

        @Override
        public void onComplete() {
            if (this.compareAndSet(false, true)) {
                this.parent.terminated(this.connection);
                this.downstream.onComplete();
            }
        }

        @Override
        public void request(long n) {
            this.upstream.request(n);
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
            if (this.compareAndSet(false, true)) {
                this.parent.cancel(this.connection);
            }
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
            }
        }
    }

    static final class RefConnection
    extends AtomicReference<Disposable>
    implements Runnable,
    Consumer<Disposable> {
        private static final long serialVersionUID = -4552101107598366241L;
        final FlowableRefCount<?> parent;
        Disposable timer;
        long subscriberCount;
        boolean connected;
        boolean disconnectedEarly;

        RefConnection(FlowableRefCount<?> parent) {
            this.parent = parent;
        }

        @Override
        public void run() {
            this.parent.timeout(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(Disposable t2) throws Exception {
            DisposableHelper.replace(this, t2);
            FlowableRefCount<?> flowableRefCount = this.parent;
            synchronized (flowableRefCount) {
                if (this.disconnectedEarly) {
                    ((ResettableConnectable)((Object)this.parent.source)).resetIf(t2);
                }
            }
        }
    }
}

