/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.operators.flowable;

import io.confluent.shaded.io.reactivex.Flowable;
import io.confluent.shaded.io.reactivex.FlowableSubscriber;
import io.confluent.shaded.io.reactivex.exceptions.CompositeException;
import io.confluent.shaded.io.reactivex.exceptions.Exceptions;
import io.confluent.shaded.io.reactivex.functions.Predicate;
import io.confluent.shaded.io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.confluent.shaded.io.reactivex.internal.subscriptions.SubscriptionArbiter;
import io.confluent.shaded.org.reactivestreams.Publisher;
import io.confluent.shaded.org.reactivestreams.Subscriber;
import io.confluent.shaded.org.reactivestreams.Subscription;
import java.util.concurrent.atomic.AtomicInteger;

public final class FlowableRetryPredicate<T>
extends AbstractFlowableWithUpstream<T, T> {
    final Predicate<? super Throwable> predicate;
    final long count;

    public FlowableRetryPredicate(Flowable<T> source, long count, Predicate<? super Throwable> predicate) {
        super(source);
        this.predicate = predicate;
        this.count = count;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> s2) {
        SubscriptionArbiter sa = new SubscriptionArbiter(false);
        s2.onSubscribe(sa);
        RetrySubscriber<T> rs = new RetrySubscriber<T>(s2, this.count, this.predicate, sa, this.source);
        rs.subscribeNext();
    }

    static final class RetrySubscriber<T>
    extends AtomicInteger
    implements FlowableSubscriber<T> {
        private static final long serialVersionUID = -7098360935104053232L;
        final Subscriber<? super T> downstream;
        final SubscriptionArbiter sa;
        final Publisher<? extends T> source;
        final Predicate<? super Throwable> predicate;
        long remaining;
        long produced;

        RetrySubscriber(Subscriber<? super T> actual, long count, Predicate<? super Throwable> predicate, SubscriptionArbiter sa, Publisher<? extends T> source) {
            this.downstream = actual;
            this.sa = sa;
            this.source = source;
            this.predicate = predicate;
            this.remaining = count;
        }

        @Override
        public void onSubscribe(Subscription s2) {
            this.sa.setSubscription(s2);
        }

        @Override
        public void onNext(T t2) {
            ++this.produced;
            this.downstream.onNext(t2);
        }

        @Override
        public void onError(Throwable t2) {
            long r = this.remaining;
            if (r != Long.MAX_VALUE) {
                this.remaining = r - 1L;
            }
            if (r == 0L) {
                this.downstream.onError(t2);
            } else {
                boolean b;
                try {
                    b = this.predicate.test(t2);
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal(e);
                    this.downstream.onError(new CompositeException(t2, e));
                    return;
                }
                if (!b) {
                    this.downstream.onError(t2);
                    return;
                }
                this.subscribeNext();
            }
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }

        void subscribeNext() {
            block3: {
                if (this.getAndIncrement() != 0) break block3;
                int missed = 1;
                do {
                    if (this.sa.isCancelled()) {
                        return;
                    }
                    long p = this.produced;
                    if (p != 0L) {
                        this.produced = 0L;
                        this.sa.produced(p);
                    }
                    this.source.subscribe(this);
                } while ((missed = this.addAndGet(-missed)) != 0);
            }
        }
    }
}

