/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.operators.flowable;

import io.confluent.shaded.io.reactivex.Flowable;
import io.confluent.shaded.io.reactivex.exceptions.Exceptions;
import io.confluent.shaded.io.reactivex.functions.Function;
import io.confluent.shaded.io.reactivex.internal.functions.ObjectHelper;
import io.confluent.shaded.io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.confluent.shaded.io.reactivex.internal.operators.flowable.FlowableRepeatWhen;
import io.confluent.shaded.io.reactivex.internal.subscriptions.EmptySubscription;
import io.confluent.shaded.io.reactivex.processors.FlowableProcessor;
import io.confluent.shaded.io.reactivex.processors.UnicastProcessor;
import io.confluent.shaded.io.reactivex.subscribers.SerializedSubscriber;
import io.confluent.shaded.org.reactivestreams.Publisher;
import io.confluent.shaded.org.reactivestreams.Subscriber;
import io.confluent.shaded.org.reactivestreams.Subscription;

public final class FlowableRetryWhen<T>
extends AbstractFlowableWithUpstream<T, T> {
    final Function<? super Flowable<Throwable>, ? extends Publisher<?>> handler;

    public FlowableRetryWhen(Flowable<T> source, Function<? super Flowable<Throwable>, ? extends Publisher<?>> handler) {
        super(source);
        this.handler = handler;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> s2) {
        Publisher<?> when;
        SerializedSubscriber<? super T> z = new SerializedSubscriber<T>(s2);
        FlowableProcessor<Throwable> processor = UnicastProcessor.create(8).toSerialized();
        try {
            when = ObjectHelper.requireNonNull(this.handler.apply(processor), "handler returned a null Publisher");
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            EmptySubscription.error(ex, s2);
            return;
        }
        FlowableRepeatWhen.WhenReceiver receiver = new FlowableRepeatWhen.WhenReceiver(this.source);
        RetryWhenSubscriber subscriber = new RetryWhenSubscriber(z, processor, (Subscription)receiver);
        receiver.subscriber = subscriber;
        s2.onSubscribe(subscriber);
        when.subscribe(receiver);
        receiver.onNext((Object)0);
    }

    static final class RetryWhenSubscriber<T>
    extends FlowableRepeatWhen.WhenSourceSubscriber<T, Throwable> {
        private static final long serialVersionUID = -2680129890138081029L;

        RetryWhenSubscriber(Subscriber<? super T> actual, FlowableProcessor<Throwable> processor, Subscription receiver) {
            super(actual, processor, receiver);
        }

        @Override
        public void onError(Throwable t2) {
            this.again(t2);
        }

        @Override
        public void onComplete() {
            this.receiver.cancel();
            this.downstream.onComplete();
        }
    }
}

