/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.operators.flowable;

import io.confluent.shaded.io.reactivex.Flowable;
import io.confluent.shaded.io.reactivex.exceptions.Exceptions;
import io.confluent.shaded.io.reactivex.functions.Function;
import io.confluent.shaded.io.reactivex.internal.functions.ObjectHelper;
import io.confluent.shaded.io.reactivex.internal.subscriptions.EmptySubscription;
import io.confluent.shaded.io.reactivex.internal.subscriptions.ScalarSubscription;
import io.confluent.shaded.io.reactivex.plugins.RxJavaPlugins;
import io.confluent.shaded.org.reactivestreams.Publisher;
import io.confluent.shaded.org.reactivestreams.Subscriber;
import java.util.concurrent.Callable;

public final class FlowableScalarXMap {
    private FlowableScalarXMap() {
        throw new IllegalStateException("No instances!");
    }

    public static <T, R> boolean tryScalarXMapSubscribe(Publisher<T> source, Subscriber<? super R> subscriber, Function<? super T, ? extends Publisher<? extends R>> mapper) {
        if (source instanceof Callable) {
            Publisher<R> r;
            Object t2;
            try {
                t2 = ((Callable)((Object)source)).call();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                EmptySubscription.error(ex, subscriber);
                return true;
            }
            if (t2 == null) {
                EmptySubscription.complete(subscriber);
                return true;
            }
            try {
                r = ObjectHelper.requireNonNull(mapper.apply(t2), "The mapper returned a null Publisher");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                EmptySubscription.error(ex, subscriber);
                return true;
            }
            if (r instanceof Callable) {
                Object u;
                try {
                    u = ((Callable)((Object)r)).call();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    EmptySubscription.error(ex, subscriber);
                    return true;
                }
                if (u == null) {
                    EmptySubscription.complete(subscriber);
                    return true;
                }
                subscriber.onSubscribe(new ScalarSubscription<R>(subscriber, u));
            } else {
                r.subscribe(subscriber);
            }
            return true;
        }
        return false;
    }

    public static <T, U> Flowable<U> scalarXMap(T value, Function<? super T, ? extends Publisher<? extends U>> mapper) {
        return RxJavaPlugins.onAssembly(new ScalarXMapFlowable(value, mapper));
    }

    static final class ScalarXMapFlowable<T, R>
    extends Flowable<R> {
        final T value;
        final Function<? super T, ? extends Publisher<? extends R>> mapper;

        ScalarXMapFlowable(T value, Function<? super T, ? extends Publisher<? extends R>> mapper) {
            this.value = value;
            this.mapper = mapper;
        }

        @Override
        public void subscribeActual(Subscriber<? super R> s2) {
            Publisher<R> other;
            try {
                other = ObjectHelper.requireNonNull(this.mapper.apply(this.value), "The mapper returned a null Publisher");
            }
            catch (Throwable e) {
                EmptySubscription.error(e, s2);
                return;
            }
            if (other instanceof Callable) {
                Object u;
                try {
                    u = ((Callable)((Object)other)).call();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    EmptySubscription.error(ex, s2);
                    return;
                }
                if (u == null) {
                    EmptySubscription.complete(s2);
                    return;
                }
                s2.onSubscribe(new ScalarSubscription<R>(s2, u));
            } else {
                other.subscribe(s2);
            }
        }
    }
}

