/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.operators.flowable;

import io.confluent.shaded.io.reactivex.Flowable;
import io.confluent.shaded.io.reactivex.FlowableSubscriber;
import io.confluent.shaded.io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.confluent.shaded.io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.confluent.shaded.org.reactivestreams.Subscriber;
import io.confluent.shaded.org.reactivestreams.Subscription;
import java.util.ArrayDeque;

public final class FlowableSkipLast<T>
extends AbstractFlowableWithUpstream<T, T> {
    final int skip;

    public FlowableSkipLast(Flowable<T> source, int skip) {
        super(source);
        this.skip = skip;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s2) {
        this.source.subscribe(new SkipLastSubscriber<T>(s2, this.skip));
    }

    static final class SkipLastSubscriber<T>
    extends ArrayDeque<T>
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = -3807491841935125653L;
        final Subscriber<? super T> downstream;
        final int skip;
        Subscription upstream;

        SkipLastSubscriber(Subscriber<? super T> actual, int skip) {
            super(skip);
            this.downstream = actual;
            this.skip = skip;
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t2) {
            if (this.skip == this.size()) {
                this.downstream.onNext(this.poll());
            } else {
                this.upstream.request(1L);
            }
            this.offer(t2);
        }

        @Override
        public void onError(Throwable t2) {
            this.downstream.onError(t2);
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }

        @Override
        public void request(long n) {
            this.upstream.request(n);
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
        }
    }
}

