/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.operators.flowable;

import io.confluent.shaded.io.reactivex.Flowable;
import io.confluent.shaded.io.reactivex.FlowableSubscriber;
import io.confluent.shaded.io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.confluent.shaded.io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.confluent.shaded.io.reactivex.internal.util.AtomicThrowable;
import io.confluent.shaded.io.reactivex.internal.util.HalfSerializer;
import io.confluent.shaded.org.reactivestreams.Publisher;
import io.confluent.shaded.org.reactivestreams.Subscriber;
import io.confluent.shaded.org.reactivestreams.Subscription;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class FlowableTakeUntil<T, U>
extends AbstractFlowableWithUpstream<T, T> {
    final Publisher<? extends U> other;

    public FlowableTakeUntil(Flowable<T> source, Publisher<? extends U> other) {
        super(source);
        this.other = other;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> child) {
        TakeUntilMainSubscriber<? super T> parent = new TakeUntilMainSubscriber<T>(child);
        child.onSubscribe(parent);
        this.other.subscribe(parent.other);
        this.source.subscribe(parent);
    }

    static final class TakeUntilMainSubscriber<T>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = -4945480365982832967L;
        final Subscriber<? super T> downstream;
        final AtomicLong requested;
        final AtomicReference<Subscription> upstream;
        final AtomicThrowable error;
        final OtherSubscriber other;

        TakeUntilMainSubscriber(Subscriber<? super T> downstream) {
            this.downstream = downstream;
            this.requested = new AtomicLong();
            this.upstream = new AtomicReference();
            this.other = new OtherSubscriber();
            this.error = new AtomicThrowable();
        }

        @Override
        public void onSubscribe(Subscription s2) {
            SubscriptionHelper.deferredSetOnce(this.upstream, this.requested, s2);
        }

        @Override
        public void onNext(T t2) {
            HalfSerializer.onNext(this.downstream, t2, (AtomicInteger)this, this.error);
        }

        @Override
        public void onError(Throwable t2) {
            SubscriptionHelper.cancel(this.other);
            HalfSerializer.onError(this.downstream, t2, (AtomicInteger)this, this.error);
        }

        @Override
        public void onComplete() {
            SubscriptionHelper.cancel(this.other);
            HalfSerializer.onComplete(this.downstream, (AtomicInteger)this, this.error);
        }

        @Override
        public void request(long n) {
            SubscriptionHelper.deferredRequest(this.upstream, this.requested, n);
        }

        @Override
        public void cancel() {
            SubscriptionHelper.cancel(this.upstream);
            SubscriptionHelper.cancel(this.other);
        }

        final class OtherSubscriber
        extends AtomicReference<Subscription>
        implements FlowableSubscriber<Object> {
            private static final long serialVersionUID = -3592821756711087922L;

            OtherSubscriber() {
            }

            @Override
            public void onSubscribe(Subscription s2) {
                SubscriptionHelper.setOnce(this, s2, Long.MAX_VALUE);
            }

            @Override
            public void onNext(Object t2) {
                SubscriptionHelper.cancel(this);
                this.onComplete();
            }

            @Override
            public void onError(Throwable t2) {
                SubscriptionHelper.cancel(TakeUntilMainSubscriber.this.upstream);
                HalfSerializer.onError(TakeUntilMainSubscriber.this.downstream, t2, (AtomicInteger)TakeUntilMainSubscriber.this, TakeUntilMainSubscriber.this.error);
            }

            @Override
            public void onComplete() {
                SubscriptionHelper.cancel(TakeUntilMainSubscriber.this.upstream);
                HalfSerializer.onComplete(TakeUntilMainSubscriber.this.downstream, (AtomicInteger)TakeUntilMainSubscriber.this, TakeUntilMainSubscriber.this.error);
            }
        }
    }
}

