/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.operators.flowable;

import io.confluent.shaded.io.reactivex.Flowable;
import io.confluent.shaded.io.reactivex.FlowableSubscriber;
import io.confluent.shaded.io.reactivex.exceptions.CompositeException;
import io.confluent.shaded.io.reactivex.exceptions.Exceptions;
import io.confluent.shaded.io.reactivex.functions.Consumer;
import io.confluent.shaded.io.reactivex.functions.Function;
import io.confluent.shaded.io.reactivex.internal.functions.ObjectHelper;
import io.confluent.shaded.io.reactivex.internal.subscriptions.EmptySubscription;
import io.confluent.shaded.io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.confluent.shaded.io.reactivex.plugins.RxJavaPlugins;
import io.confluent.shaded.org.reactivestreams.Publisher;
import io.confluent.shaded.org.reactivestreams.Subscriber;
import io.confluent.shaded.org.reactivestreams.Subscription;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;

public final class FlowableUsing<T, D>
extends Flowable<T> {
    final Callable<? extends D> resourceSupplier;
    final Function<? super D, ? extends Publisher<? extends T>> sourceSupplier;
    final Consumer<? super D> disposer;
    final boolean eager;

    public FlowableUsing(Callable<? extends D> resourceSupplier, Function<? super D, ? extends Publisher<? extends T>> sourceSupplier, Consumer<? super D> disposer, boolean eager) {
        this.resourceSupplier = resourceSupplier;
        this.sourceSupplier = sourceSupplier;
        this.disposer = disposer;
        this.eager = eager;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> s2) {
        Publisher<T> source;
        D resource;
        try {
            resource = this.resourceSupplier.call();
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            EmptySubscription.error(e, s2);
            return;
        }
        try {
            source = ObjectHelper.requireNonNull(this.sourceSupplier.apply(resource), "The sourceSupplier returned a null Publisher");
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            try {
                this.disposer.accept(resource);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                EmptySubscription.error(new CompositeException(e, ex), s2);
                return;
            }
            EmptySubscription.error(e, s2);
            return;
        }
        UsingSubscriber<? super T, ? super D> us = new UsingSubscriber<T, D>(s2, resource, this.disposer, this.eager);
        source.subscribe(us);
    }

    static final class UsingSubscriber<T, D>
    extends AtomicBoolean
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = 5904473792286235046L;
        final Subscriber<? super T> downstream;
        final D resource;
        final Consumer<? super D> disposer;
        final boolean eager;
        Subscription upstream;

        UsingSubscriber(Subscriber<? super T> actual, D resource, Consumer<? super D> disposer, boolean eager) {
            this.downstream = actual;
            this.resource = resource;
            this.disposer = disposer;
            this.eager = eager;
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t2) {
            this.downstream.onNext(t2);
        }

        @Override
        public void onError(Throwable t2) {
            if (this.eager) {
                Throwable innerError = null;
                if (this.compareAndSet(false, true)) {
                    try {
                        this.disposer.accept(this.resource);
                    }
                    catch (Throwable e) {
                        Exceptions.throwIfFatal(e);
                        innerError = e;
                    }
                }
                this.upstream.cancel();
                if (innerError != null) {
                    this.downstream.onError(new CompositeException(t2, innerError));
                } else {
                    this.downstream.onError(t2);
                }
            } else {
                this.downstream.onError(t2);
                this.upstream.cancel();
                this.disposeAfter();
            }
        }

        @Override
        public void onComplete() {
            if (this.eager) {
                if (this.compareAndSet(false, true)) {
                    try {
                        this.disposer.accept(this.resource);
                    }
                    catch (Throwable e) {
                        Exceptions.throwIfFatal(e);
                        this.downstream.onError(e);
                        return;
                    }
                }
                this.upstream.cancel();
                this.downstream.onComplete();
            } else {
                this.downstream.onComplete();
                this.upstream.cancel();
                this.disposeAfter();
            }
        }

        @Override
        public void request(long n) {
            this.upstream.request(n);
        }

        @Override
        public void cancel() {
            this.disposeAfter();
            this.upstream.cancel();
        }

        void disposeAfter() {
            if (this.compareAndSet(false, true)) {
                try {
                    this.disposer.accept(this.resource);
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal(e);
                    RxJavaPlugins.onError(e);
                }
            }
        }
    }
}

