/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.operators.flowable;

import io.confluent.shaded.io.reactivex.Flowable;
import io.confluent.shaded.io.reactivex.FlowableSubscriber;
import io.confluent.shaded.io.reactivex.exceptions.Exceptions;
import io.confluent.shaded.io.reactivex.functions.BiFunction;
import io.confluent.shaded.io.reactivex.internal.functions.ObjectHelper;
import io.confluent.shaded.io.reactivex.internal.fuseable.ConditionalSubscriber;
import io.confluent.shaded.io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.confluent.shaded.io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.confluent.shaded.io.reactivex.subscribers.SerializedSubscriber;
import io.confluent.shaded.org.reactivestreams.Publisher;
import io.confluent.shaded.org.reactivestreams.Subscriber;
import io.confluent.shaded.org.reactivestreams.Subscription;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class FlowableWithLatestFrom<T, U, R>
extends AbstractFlowableWithUpstream<T, R> {
    final BiFunction<? super T, ? super U, ? extends R> combiner;
    final Publisher<? extends U> other;

    public FlowableWithLatestFrom(Flowable<T> source, BiFunction<? super T, ? super U, ? extends R> combiner, Publisher<? extends U> other) {
        super(source);
        this.combiner = combiner;
        this.other = other;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s2) {
        SerializedSubscriber<R> serial = new SerializedSubscriber<R>(s2);
        WithLatestFromSubscriber<? super T, ? super U, ? extends R> wlf = new WithLatestFromSubscriber<T, U, R>(serial, this.combiner);
        serial.onSubscribe(wlf);
        this.other.subscribe(new FlowableWithLatestSubscriber(wlf));
        this.source.subscribe(wlf);
    }

    final class FlowableWithLatestSubscriber
    implements FlowableSubscriber<U> {
        private final WithLatestFromSubscriber<T, U, R> wlf;

        FlowableWithLatestSubscriber(WithLatestFromSubscriber<T, U, R> wlf) {
            this.wlf = wlf;
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (this.wlf.setOther(s2)) {
                s2.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(U t2) {
            this.wlf.lazySet(t2);
        }

        @Override
        public void onError(Throwable t2) {
            this.wlf.otherError(t2);
        }

        @Override
        public void onComplete() {
        }
    }

    static final class WithLatestFromSubscriber<T, U, R>
    extends AtomicReference<U>
    implements ConditionalSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = -312246233408980075L;
        final Subscriber<? super R> downstream;
        final BiFunction<? super T, ? super U, ? extends R> combiner;
        final AtomicReference<Subscription> upstream = new AtomicReference();
        final AtomicLong requested = new AtomicLong();
        final AtomicReference<Subscription> other = new AtomicReference();

        WithLatestFromSubscriber(Subscriber<? super R> actual, BiFunction<? super T, ? super U, ? extends R> combiner) {
            this.downstream = actual;
            this.combiner = combiner;
        }

        @Override
        public void onSubscribe(Subscription s2) {
            SubscriptionHelper.deferredSetOnce(this.upstream, this.requested, s2);
        }

        @Override
        public void onNext(T t2) {
            if (!this.tryOnNext(t2)) {
                this.upstream.get().request(1L);
            }
        }

        @Override
        public boolean tryOnNext(T t2) {
            Object u = this.get();
            if (u != null) {
                R r;
                try {
                    r = ObjectHelper.requireNonNull(this.combiner.apply(t2, u), "The combiner returned a null value");
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal(e);
                    this.cancel();
                    this.downstream.onError(e);
                    return false;
                }
                this.downstream.onNext(r);
                return true;
            }
            return false;
        }

        @Override
        public void onError(Throwable t2) {
            SubscriptionHelper.cancel(this.other);
            this.downstream.onError(t2);
        }

        @Override
        public void onComplete() {
            SubscriptionHelper.cancel(this.other);
            this.downstream.onComplete();
        }

        @Override
        public void request(long n) {
            SubscriptionHelper.deferredRequest(this.upstream, this.requested, n);
        }

        @Override
        public void cancel() {
            SubscriptionHelper.cancel(this.upstream);
            SubscriptionHelper.cancel(this.other);
        }

        public boolean setOther(Subscription o) {
            return SubscriptionHelper.setOnce(this.other, o);
        }

        public void otherError(Throwable e) {
            SubscriptionHelper.cancel(this.upstream);
            this.downstream.onError(e);
        }
    }
}

