/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.operators.maybe;

import io.confluent.shaded.io.reactivex.MaybeObserver;
import io.confluent.shaded.io.reactivex.MaybeSource;
import io.confluent.shaded.io.reactivex.disposables.Disposable;
import io.confluent.shaded.io.reactivex.exceptions.Exceptions;
import io.confluent.shaded.io.reactivex.functions.BiFunction;
import io.confluent.shaded.io.reactivex.functions.Function;
import io.confluent.shaded.io.reactivex.internal.disposables.DisposableHelper;
import io.confluent.shaded.io.reactivex.internal.functions.ObjectHelper;
import io.confluent.shaded.io.reactivex.internal.operators.maybe.AbstractMaybeWithUpstream;
import java.util.concurrent.atomic.AtomicReference;

public final class MaybeFlatMapBiSelector<T, U, R>
extends AbstractMaybeWithUpstream<T, R> {
    final Function<? super T, ? extends MaybeSource<? extends U>> mapper;
    final BiFunction<? super T, ? super U, ? extends R> resultSelector;

    public MaybeFlatMapBiSelector(MaybeSource<T> source, Function<? super T, ? extends MaybeSource<? extends U>> mapper, BiFunction<? super T, ? super U, ? extends R> resultSelector) {
        super(source);
        this.mapper = mapper;
        this.resultSelector = resultSelector;
    }

    @Override
    protected void subscribeActual(MaybeObserver<? super R> observer) {
        this.source.subscribe(new FlatMapBiMainObserver<T, U, R>(observer, this.mapper, this.resultSelector));
    }

    static final class FlatMapBiMainObserver<T, U, R>
    implements MaybeObserver<T>,
    Disposable {
        final Function<? super T, ? extends MaybeSource<? extends U>> mapper;
        final InnerObserver<T, U, R> inner;

        FlatMapBiMainObserver(MaybeObserver<? super R> actual, Function<? super T, ? extends MaybeSource<? extends U>> mapper, BiFunction<? super T, ? super U, ? extends R> resultSelector) {
            this.inner = new InnerObserver<T, U, R>(actual, resultSelector);
            this.mapper = mapper;
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this.inner);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)this.inner.get());
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.setOnce(this.inner, d)) {
                this.inner.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(T value) {
            MaybeSource<U> next;
            try {
                next = ObjectHelper.requireNonNull(this.mapper.apply(value), "The mapper returned a null MaybeSource");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.inner.downstream.onError(ex);
                return;
            }
            if (DisposableHelper.replace(this.inner, null)) {
                this.inner.value = value;
                next.subscribe(this.inner);
            }
        }

        @Override
        public void onError(Throwable e) {
            this.inner.downstream.onError(e);
        }

        @Override
        public void onComplete() {
            this.inner.downstream.onComplete();
        }

        static final class InnerObserver<T, U, R>
        extends AtomicReference<Disposable>
        implements MaybeObserver<U> {
            private static final long serialVersionUID = -2897979525538174559L;
            final MaybeObserver<? super R> downstream;
            final BiFunction<? super T, ? super U, ? extends R> resultSelector;
            T value;

            InnerObserver(MaybeObserver<? super R> actual, BiFunction<? super T, ? super U, ? extends R> resultSelector) {
                this.downstream = actual;
                this.resultSelector = resultSelector;
            }

            @Override
            public void onSubscribe(Disposable d) {
                DisposableHelper.setOnce(this, d);
            }

            @Override
            public void onSuccess(U value) {
                R r;
                T t2 = this.value;
                this.value = null;
                try {
                    r = ObjectHelper.requireNonNull(this.resultSelector.apply(t2, value), "The resultSelector returned a null value");
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.downstream.onError(ex);
                    return;
                }
                this.downstream.onSuccess(r);
            }

            @Override
            public void onError(Throwable e) {
                this.downstream.onError(e);
            }

            @Override
            public void onComplete() {
                this.downstream.onComplete();
            }
        }
    }
}

