/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.operators.mixed;

import io.confluent.shaded.io.reactivex.Flowable;
import io.confluent.shaded.io.reactivex.FlowableSubscriber;
import io.confluent.shaded.io.reactivex.MaybeObserver;
import io.confluent.shaded.io.reactivex.MaybeSource;
import io.confluent.shaded.io.reactivex.disposables.Disposable;
import io.confluent.shaded.io.reactivex.exceptions.Exceptions;
import io.confluent.shaded.io.reactivex.exceptions.MissingBackpressureException;
import io.confluent.shaded.io.reactivex.functions.Function;
import io.confluent.shaded.io.reactivex.internal.disposables.DisposableHelper;
import io.confluent.shaded.io.reactivex.internal.functions.ObjectHelper;
import io.confluent.shaded.io.reactivex.internal.fuseable.SimplePlainQueue;
import io.confluent.shaded.io.reactivex.internal.queue.SpscArrayQueue;
import io.confluent.shaded.io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.confluent.shaded.io.reactivex.internal.util.AtomicThrowable;
import io.confluent.shaded.io.reactivex.internal.util.BackpressureHelper;
import io.confluent.shaded.io.reactivex.internal.util.ErrorMode;
import io.confluent.shaded.io.reactivex.plugins.RxJavaPlugins;
import io.confluent.shaded.org.reactivestreams.Subscriber;
import io.confluent.shaded.org.reactivestreams.Subscription;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class FlowableConcatMapMaybe<T, R>
extends Flowable<R> {
    final Flowable<T> source;
    final Function<? super T, ? extends MaybeSource<? extends R>> mapper;
    final ErrorMode errorMode;
    final int prefetch;

    public FlowableConcatMapMaybe(Flowable<T> source, Function<? super T, ? extends MaybeSource<? extends R>> mapper, ErrorMode errorMode, int prefetch) {
        this.source = source;
        this.mapper = mapper;
        this.errorMode = errorMode;
        this.prefetch = prefetch;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s2) {
        this.source.subscribe(new ConcatMapMaybeSubscriber<T, R>(s2, this.mapper, this.prefetch, this.errorMode));
    }

    static final class ConcatMapMaybeSubscriber<T, R>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = -9140123220065488293L;
        final Subscriber<? super R> downstream;
        final Function<? super T, ? extends MaybeSource<? extends R>> mapper;
        final int prefetch;
        final AtomicLong requested;
        final AtomicThrowable errors;
        final ConcatMapMaybeObserver<R> inner;
        final SimplePlainQueue<T> queue;
        final ErrorMode errorMode;
        Subscription upstream;
        volatile boolean done;
        volatile boolean cancelled;
        long emitted;
        int consumed;
        R item;
        volatile int state;
        static final int STATE_INACTIVE = 0;
        static final int STATE_ACTIVE = 1;
        static final int STATE_RESULT_VALUE = 2;

        ConcatMapMaybeSubscriber(Subscriber<? super R> downstream, Function<? super T, ? extends MaybeSource<? extends R>> mapper, int prefetch, ErrorMode errorMode) {
            this.downstream = downstream;
            this.mapper = mapper;
            this.prefetch = prefetch;
            this.errorMode = errorMode;
            this.requested = new AtomicLong();
            this.errors = new AtomicThrowable();
            this.inner = new ConcatMapMaybeObserver(this);
            this.queue = new SpscArrayQueue<T>(prefetch);
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
                s2.request(this.prefetch);
            }
        }

        @Override
        public void onNext(T t2) {
            if (!this.queue.offer(t2)) {
                this.upstream.cancel();
                this.onError(new MissingBackpressureException("queue full?!"));
                return;
            }
            this.drain();
        }

        @Override
        public void onError(Throwable t2) {
            if (this.errors.addThrowable(t2)) {
                if (this.errorMode == ErrorMode.IMMEDIATE) {
                    this.inner.dispose();
                }
                this.done = true;
                this.drain();
            } else {
                RxJavaPlugins.onError(t2);
            }
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        public void request(long n) {
            BackpressureHelper.add(this.requested, n);
            this.drain();
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.upstream.cancel();
            this.inner.dispose();
            if (this.getAndIncrement() == 0) {
                this.queue.clear();
                this.item = null;
            }
        }

        void innerSuccess(R item) {
            this.item = item;
            this.state = 2;
            this.drain();
        }

        void innerComplete() {
            this.state = 0;
            this.drain();
        }

        void innerError(Throwable ex) {
            if (this.errors.addThrowable(ex)) {
                if (this.errorMode != ErrorMode.END) {
                    this.upstream.cancel();
                }
                this.state = 0;
                this.drain();
            } else {
                RxJavaPlugins.onError(ex);
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Subscriber<R> downstream = this.downstream;
            ErrorMode errorMode = this.errorMode;
            SimplePlainQueue<T> queue = this.queue;
            AtomicThrowable errors = this.errors;
            AtomicLong requested = this.requested;
            int limit = this.prefetch - (this.prefetch >> 1);
            while (true) {
                if (this.cancelled) {
                    queue.clear();
                    this.item = null;
                } else {
                    long e;
                    int s2 = this.state;
                    if (errors.get() != null && (errorMode == ErrorMode.IMMEDIATE || errorMode == ErrorMode.BOUNDARY && s2 == 0)) {
                        queue.clear();
                        this.item = null;
                        Throwable ex = errors.terminate();
                        downstream.onError(ex);
                        return;
                    }
                    if (s2 == 0) {
                        boolean empty;
                        boolean d = this.done;
                        T v = queue.poll();
                        boolean bl = empty = v == null;
                        if (d && empty) {
                            Throwable ex = errors.terminate();
                            if (ex == null) {
                                downstream.onComplete();
                            } else {
                                downstream.onError(ex);
                            }
                            return;
                        }
                        if (!empty) {
                            MaybeSource<R> ms;
                            int c = this.consumed + 1;
                            if (c == limit) {
                                this.consumed = 0;
                                this.upstream.request(limit);
                            } else {
                                this.consumed = c;
                            }
                            try {
                                ms = ObjectHelper.requireNonNull(this.mapper.apply(v), "The mapper returned a null MaybeSource");
                            }
                            catch (Throwable ex) {
                                Exceptions.throwIfFatal(ex);
                                this.upstream.cancel();
                                queue.clear();
                                errors.addThrowable(ex);
                                ex = errors.terminate();
                                downstream.onError(ex);
                                return;
                            }
                            this.state = 1;
                            ms.subscribe(this.inner);
                        }
                    } else if (s2 == 2 && (e = this.emitted) != requested.get()) {
                        R w = this.item;
                        this.item = null;
                        downstream.onNext(w);
                        this.emitted = e + 1L;
                        this.state = 0;
                        continue;
                    }
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        static final class ConcatMapMaybeObserver<R>
        extends AtomicReference<Disposable>
        implements MaybeObserver<R> {
            private static final long serialVersionUID = -3051469169682093892L;
            final ConcatMapMaybeSubscriber<?, R> parent;

            ConcatMapMaybeObserver(ConcatMapMaybeSubscriber<?, R> parent) {
                this.parent = parent;
            }

            @Override
            public void onSubscribe(Disposable d) {
                DisposableHelper.replace(this, d);
            }

            @Override
            public void onSuccess(R t2) {
                this.parent.innerSuccess(t2);
            }

            @Override
            public void onError(Throwable e) {
                this.parent.innerError(e);
            }

            @Override
            public void onComplete() {
                this.parent.innerComplete();
            }

            void dispose() {
                DisposableHelper.dispose(this);
            }
        }
    }
}

