/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.operators.mixed;

import io.confluent.shaded.io.reactivex.CompletableObserver;
import io.confluent.shaded.io.reactivex.MaybeObserver;
import io.confluent.shaded.io.reactivex.Notification;
import io.confluent.shaded.io.reactivex.SingleObserver;
import io.confluent.shaded.io.reactivex.annotations.Experimental;
import io.confluent.shaded.io.reactivex.disposables.Disposable;
import io.confluent.shaded.io.reactivex.internal.disposables.DisposableHelper;

@Experimental
public final class MaterializeSingleObserver<T>
implements SingleObserver<T>,
MaybeObserver<T>,
CompletableObserver,
Disposable {
    final SingleObserver<? super Notification<T>> downstream;
    Disposable upstream;

    public MaterializeSingleObserver(SingleObserver<? super Notification<T>> downstream) {
        this.downstream = downstream;
    }

    @Override
    public void onSubscribe(Disposable d) {
        if (DisposableHelper.validate(this.upstream, d)) {
            this.upstream = d;
            this.downstream.onSubscribe(this);
        }
    }

    @Override
    public void onComplete() {
        this.downstream.onSuccess(Notification.createOnComplete());
    }

    @Override
    public void onSuccess(T t2) {
        this.downstream.onSuccess(Notification.createOnNext(t2));
    }

    @Override
    public void onError(Throwable e) {
        this.downstream.onSuccess(Notification.createOnError(e));
    }

    @Override
    public boolean isDisposed() {
        return this.upstream.isDisposed();
    }

    @Override
    public void dispose() {
        this.upstream.dispose();
    }
}

