/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.operators.observable;

import io.confluent.shaded.io.reactivex.ObservableSource;
import io.confluent.shaded.io.reactivex.Observer;
import io.confluent.shaded.io.reactivex.disposables.Disposable;
import io.confluent.shaded.io.reactivex.exceptions.Exceptions;
import io.confluent.shaded.io.reactivex.internal.disposables.DisposableHelper;
import io.confluent.shaded.io.reactivex.internal.disposables.EmptyDisposable;
import io.confluent.shaded.io.reactivex.internal.functions.ObjectHelper;
import io.confluent.shaded.io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ObservableBuffer<T, U extends Collection<? super T>>
extends AbstractObservableWithUpstream<T, U> {
    final int count;
    final int skip;
    final Callable<U> bufferSupplier;

    public ObservableBuffer(ObservableSource<T> source, int count, int skip, Callable<U> bufferSupplier) {
        super(source);
        this.count = count;
        this.skip = skip;
        this.bufferSupplier = bufferSupplier;
    }

    @Override
    protected void subscribeActual(Observer<? super U> t2) {
        if (this.skip == this.count) {
            BufferExactObserver bes = new BufferExactObserver(t2, this.count, this.bufferSupplier);
            if (bes.createBuffer()) {
                this.source.subscribe(bes);
            }
        } else {
            this.source.subscribe(new BufferSkipObserver(t2, this.count, this.skip, this.bufferSupplier));
        }
    }

    static final class BufferSkipObserver<T, U extends Collection<? super T>>
    extends AtomicBoolean
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = -8223395059921494546L;
        final Observer<? super U> downstream;
        final int count;
        final int skip;
        final Callable<U> bufferSupplier;
        Disposable upstream;
        final ArrayDeque<U> buffers;
        long index;

        BufferSkipObserver(Observer<? super U> actual, int count, int skip, Callable<U> bufferSupplier) {
            this.downstream = actual;
            this.count = count;
            this.skip = skip;
            this.bufferSupplier = bufferSupplier;
            this.buffers = new ArrayDeque();
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        @Override
        public void onNext(T t2) {
            if (this.index++ % (long)this.skip == 0L) {
                Collection b;
                try {
                    b = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The bufferSupplier returned a null collection. Null values are generally not allowed in 2.x operators and sources.");
                }
                catch (Throwable e) {
                    this.buffers.clear();
                    this.upstream.dispose();
                    this.downstream.onError(e);
                    return;
                }
                this.buffers.offer(b);
            }
            Iterator<U> it = this.buffers.iterator();
            while (it.hasNext()) {
                Collection b = (Collection)it.next();
                b.add(t2);
                if (this.count > b.size()) continue;
                it.remove();
                this.downstream.onNext(b);
            }
        }

        @Override
        public void onError(Throwable t2) {
            this.buffers.clear();
            this.downstream.onError(t2);
        }

        @Override
        public void onComplete() {
            while (!this.buffers.isEmpty()) {
                this.downstream.onNext(this.buffers.poll());
            }
            this.downstream.onComplete();
        }
    }

    static final class BufferExactObserver<T, U extends Collection<? super T>>
    implements Observer<T>,
    Disposable {
        final Observer<? super U> downstream;
        final int count;
        final Callable<U> bufferSupplier;
        U buffer;
        int size;
        Disposable upstream;

        BufferExactObserver(Observer<? super U> actual, int count, Callable<U> bufferSupplier) {
            this.downstream = actual;
            this.count = count;
            this.bufferSupplier = bufferSupplier;
        }

        boolean createBuffer() {
            Collection b;
            try {
                b = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "Empty buffer supplied");
            }
            catch (Throwable t2) {
                Exceptions.throwIfFatal(t2);
                this.buffer = null;
                if (this.upstream == null) {
                    EmptyDisposable.error(t2, this.downstream);
                } else {
                    this.upstream.dispose();
                    this.downstream.onError(t2);
                }
                return false;
            }
            this.buffer = b;
            return true;
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        @Override
        public void onNext(T t2) {
            U b = this.buffer;
            if (b != null) {
                b.add(t2);
                if (++this.size >= this.count) {
                    this.downstream.onNext(b);
                    this.size = 0;
                    this.createBuffer();
                }
            }
        }

        @Override
        public void onError(Throwable t2) {
            this.buffer = null;
            this.downstream.onError(t2);
        }

        @Override
        public void onComplete() {
            U b = this.buffer;
            if (b != null) {
                this.buffer = null;
                if (!b.isEmpty()) {
                    this.downstream.onNext(b);
                }
                this.downstream.onComplete();
            }
        }
    }
}

