/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.operators.observable;

import io.confluent.shaded.io.reactivex.Observable;
import io.confluent.shaded.io.reactivex.ObservableSource;
import io.confluent.shaded.io.reactivex.Observer;
import io.confluent.shaded.io.reactivex.disposables.CompositeDisposable;
import io.confluent.shaded.io.reactivex.disposables.Disposable;
import io.confluent.shaded.io.reactivex.exceptions.Exceptions;
import io.confluent.shaded.io.reactivex.functions.Function;
import io.confluent.shaded.io.reactivex.internal.disposables.DisposableHelper;
import io.confluent.shaded.io.reactivex.internal.functions.ObjectHelper;
import io.confluent.shaded.io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.confluent.shaded.io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.confluent.shaded.io.reactivex.internal.util.AtomicThrowable;
import io.confluent.shaded.io.reactivex.plugins.RxJavaPlugins;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableBufferBoundary<T, U extends Collection<? super T>, Open, Close>
extends AbstractObservableWithUpstream<T, U> {
    final Callable<U> bufferSupplier;
    final ObservableSource<? extends Open> bufferOpen;
    final Function<? super Open, ? extends ObservableSource<? extends Close>> bufferClose;

    public ObservableBufferBoundary(ObservableSource<T> source, ObservableSource<? extends Open> bufferOpen, Function<? super Open, ? extends ObservableSource<? extends Close>> bufferClose, Callable<U> bufferSupplier) {
        super(source);
        this.bufferOpen = bufferOpen;
        this.bufferClose = bufferClose;
        this.bufferSupplier = bufferSupplier;
    }

    @Override
    protected void subscribeActual(Observer<? super U> t2) {
        BufferBoundaryObserver parent = new BufferBoundaryObserver(t2, this.bufferOpen, this.bufferClose, this.bufferSupplier);
        t2.onSubscribe(parent);
        this.source.subscribe(parent);
    }

    static final class BufferCloseObserver<T, C extends Collection<? super T>>
    extends AtomicReference<Disposable>
    implements Observer<Object>,
    Disposable {
        private static final long serialVersionUID = -8498650778633225126L;
        final BufferBoundaryObserver<T, C, ?, ?> parent;
        final long index;

        BufferCloseObserver(BufferBoundaryObserver<T, C, ?, ?> parent, long index) {
            this.parent = parent;
            this.index = index;
        }

        @Override
        public void onSubscribe(Disposable d) {
            DisposableHelper.setOnce(this, d);
        }

        @Override
        public void onNext(Object t2) {
            Disposable upstream = (Disposable)this.get();
            if (upstream != DisposableHelper.DISPOSED) {
                this.lazySet(DisposableHelper.DISPOSED);
                upstream.dispose();
                this.parent.close(this, this.index);
            }
        }

        @Override
        public void onError(Throwable t2) {
            if (this.get() != DisposableHelper.DISPOSED) {
                this.lazySet(DisposableHelper.DISPOSED);
                this.parent.boundaryError(this, t2);
            } else {
                RxJavaPlugins.onError(t2);
            }
        }

        @Override
        public void onComplete() {
            if (this.get() != DisposableHelper.DISPOSED) {
                this.lazySet(DisposableHelper.DISPOSED);
                this.parent.close(this, this.index);
            }
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public boolean isDisposed() {
            return this.get() == DisposableHelper.DISPOSED;
        }
    }

    static final class BufferBoundaryObserver<T, C extends Collection<? super T>, Open, Close>
    extends AtomicInteger
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = -8466418554264089604L;
        final Observer<? super C> downstream;
        final Callable<C> bufferSupplier;
        final ObservableSource<? extends Open> bufferOpen;
        final Function<? super Open, ? extends ObservableSource<? extends Close>> bufferClose;
        final CompositeDisposable observers;
        final AtomicReference<Disposable> upstream;
        final AtomicThrowable errors;
        volatile boolean done;
        final SpscLinkedArrayQueue<C> queue;
        volatile boolean cancelled;
        long index;
        Map<Long, C> buffers;

        BufferBoundaryObserver(Observer<? super C> actual, ObservableSource<? extends Open> bufferOpen, Function<? super Open, ? extends ObservableSource<? extends Close>> bufferClose, Callable<C> bufferSupplier) {
            this.downstream = actual;
            this.bufferSupplier = bufferSupplier;
            this.bufferOpen = bufferOpen;
            this.bufferClose = bufferClose;
            this.queue = new SpscLinkedArrayQueue(Observable.bufferSize());
            this.observers = new CompositeDisposable();
            this.upstream = new AtomicReference();
            this.buffers = new LinkedHashMap<Long, C>();
            this.errors = new AtomicThrowable();
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.setOnce(this.upstream, d)) {
                BufferOpenObserver open = new BufferOpenObserver(this);
                this.observers.add(open);
                this.bufferOpen.subscribe(open);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t2) {
            BufferBoundaryObserver bufferBoundaryObserver = this;
            synchronized (bufferBoundaryObserver) {
                Map<Long, C> bufs = this.buffers;
                if (bufs == null) {
                    return;
                }
                for (Collection b : bufs.values()) {
                    b.add(t2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable t2) {
            if (this.errors.addThrowable(t2)) {
                this.observers.dispose();
                BufferBoundaryObserver bufferBoundaryObserver = this;
                synchronized (bufferBoundaryObserver) {
                    this.buffers = null;
                }
                this.done = true;
                this.drain();
            } else {
                RxJavaPlugins.onError(t2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onComplete() {
            this.observers.dispose();
            BufferBoundaryObserver bufferBoundaryObserver = this;
            synchronized (bufferBoundaryObserver) {
                Map<Long, C> bufs = this.buffers;
                if (bufs == null) {
                    return;
                }
                for (Collection b : bufs.values()) {
                    this.queue.offer(b);
                }
                this.buffers = null;
            }
            this.done = true;
            this.drain();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispose() {
            if (DisposableHelper.dispose(this.upstream)) {
                this.cancelled = true;
                this.observers.dispose();
                BufferBoundaryObserver bufferBoundaryObserver = this;
                synchronized (bufferBoundaryObserver) {
                    this.buffers = null;
                }
                if (this.getAndIncrement() != 0) {
                    this.queue.clear();
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed(this.upstream.get());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void open(Open token) {
            ObservableSource<Close> p;
            Collection buf;
            try {
                buf = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The bufferSupplier returned a null Collection");
                p = ObjectHelper.requireNonNull(this.bufferClose.apply(token), "The bufferClose returned a null ObservableSource");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                DisposableHelper.dispose(this.upstream);
                this.onError(ex);
                return;
            }
            long idx = this.index;
            this.index = idx + 1L;
            BufferBoundaryObserver bufferBoundaryObserver = this;
            synchronized (bufferBoundaryObserver) {
                Map<Long, C> bufs = this.buffers;
                if (bufs == null) {
                    return;
                }
                bufs.put(idx, buf);
            }
            BufferCloseObserver bc = new BufferCloseObserver(this, idx);
            this.observers.add(bc);
            p.subscribe(bc);
        }

        void openComplete(BufferOpenObserver<Open> os) {
            this.observers.delete(os);
            if (this.observers.size() == 0) {
                DisposableHelper.dispose(this.upstream);
                this.done = true;
                this.drain();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close(BufferCloseObserver<T, C> closer, long idx) {
            this.observers.delete(closer);
            boolean makeDone = false;
            if (this.observers.size() == 0) {
                makeDone = true;
                DisposableHelper.dispose(this.upstream);
            }
            BufferBoundaryObserver bufferBoundaryObserver = this;
            synchronized (bufferBoundaryObserver) {
                Map<Long, C> bufs = this.buffers;
                if (bufs == null) {
                    return;
                }
                this.queue.offer(this.buffers.remove(idx));
            }
            if (makeDone) {
                this.done = true;
            }
            this.drain();
        }

        void boundaryError(Disposable observer, Throwable ex) {
            DisposableHelper.dispose(this.upstream);
            this.observers.delete(observer);
            this.onError(ex);
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Observer<C> a = this.downstream;
            SpscLinkedArrayQueue<C> q = this.queue;
            while (true) {
                boolean empty;
                if (this.cancelled) {
                    q.clear();
                    return;
                }
                boolean d = this.done;
                if (d && this.errors.get() != null) {
                    q.clear();
                    Throwable ex = this.errors.terminate();
                    a.onError(ex);
                    return;
                }
                Collection v = (Collection)q.poll();
                boolean bl = empty = v == null;
                if (d && empty) {
                    a.onComplete();
                    return;
                }
                if (!empty) {
                    a.onNext(v);
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        static final class BufferOpenObserver<Open>
        extends AtomicReference<Disposable>
        implements Observer<Open>,
        Disposable {
            private static final long serialVersionUID = -8498650778633225126L;
            final BufferBoundaryObserver<?, ?, Open, ?> parent;

            BufferOpenObserver(BufferBoundaryObserver<?, ?, Open, ?> parent) {
                this.parent = parent;
            }

            @Override
            public void onSubscribe(Disposable d) {
                DisposableHelper.setOnce(this, d);
            }

            @Override
            public void onNext(Open t2) {
                this.parent.open(t2);
            }

            @Override
            public void onError(Throwable t2) {
                this.lazySet(DisposableHelper.DISPOSED);
                this.parent.boundaryError(this, t2);
            }

            @Override
            public void onComplete() {
                this.lazySet(DisposableHelper.DISPOSED);
                this.parent.openComplete(this);
            }

            @Override
            public void dispose() {
                DisposableHelper.dispose(this);
            }

            @Override
            public boolean isDisposed() {
                return this.get() == DisposableHelper.DISPOSED;
            }
        }
    }
}

