/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.operators.observable;

import io.confluent.shaded.io.reactivex.Notification;
import io.confluent.shaded.io.reactivex.ObservableSource;
import io.confluent.shaded.io.reactivex.Observer;
import io.confluent.shaded.io.reactivex.disposables.Disposable;
import io.confluent.shaded.io.reactivex.internal.disposables.DisposableHelper;
import io.confluent.shaded.io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;

public final class ObservableMaterialize<T>
extends AbstractObservableWithUpstream<T, Notification<T>> {
    public ObservableMaterialize(ObservableSource<T> source) {
        super(source);
    }

    @Override
    public void subscribeActual(Observer<? super Notification<T>> t2) {
        this.source.subscribe(new MaterializeObserver(t2));
    }

    static final class MaterializeObserver<T>
    implements Observer<T>,
    Disposable {
        final Observer<? super Notification<T>> downstream;
        Disposable upstream;

        MaterializeObserver(Observer<? super Notification<T>> downstream) {
            this.downstream = downstream;
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        @Override
        public void onNext(T t2) {
            this.downstream.onNext(Notification.createOnNext(t2));
        }

        @Override
        public void onError(Throwable t2) {
            Notification v = Notification.createOnError(t2);
            this.downstream.onNext(v);
            this.downstream.onComplete();
        }

        @Override
        public void onComplete() {
            Notification v = Notification.createOnComplete();
            this.downstream.onNext(v);
            this.downstream.onComplete();
        }
    }
}

