/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.operators.observable;

import io.confluent.shaded.io.reactivex.ObservableSource;
import io.confluent.shaded.io.reactivex.Observer;
import io.confluent.shaded.io.reactivex.Scheduler;
import io.confluent.shaded.io.reactivex.disposables.Disposable;
import io.confluent.shaded.io.reactivex.internal.disposables.DisposableHelper;
import io.confluent.shaded.io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.confluent.shaded.io.reactivex.observers.SerializedObserver;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableSampleTimed<T>
extends AbstractObservableWithUpstream<T, T> {
    final long period;
    final TimeUnit unit;
    final Scheduler scheduler;
    final boolean emitLast;

    public ObservableSampleTimed(ObservableSource<T> source, long period, TimeUnit unit, Scheduler scheduler, boolean emitLast) {
        super(source);
        this.period = period;
        this.unit = unit;
        this.scheduler = scheduler;
        this.emitLast = emitLast;
    }

    @Override
    public void subscribeActual(Observer<? super T> t2) {
        SerializedObserver<? super T> serial = new SerializedObserver<T>(t2);
        if (this.emitLast) {
            this.source.subscribe(new SampleTimedEmitLast<T>(serial, this.period, this.unit, this.scheduler));
        } else {
            this.source.subscribe(new SampleTimedNoLast<T>(serial, this.period, this.unit, this.scheduler));
        }
    }

    static final class SampleTimedEmitLast<T>
    extends SampleTimedObserver<T> {
        private static final long serialVersionUID = -7139995637533111443L;
        final AtomicInteger wip = new AtomicInteger(1);

        SampleTimedEmitLast(Observer<? super T> actual, long period, TimeUnit unit, Scheduler scheduler) {
            super(actual, period, unit, scheduler);
        }

        @Override
        void complete() {
            this.emit();
            if (this.wip.decrementAndGet() == 0) {
                this.downstream.onComplete();
            }
        }

        @Override
        public void run() {
            if (this.wip.incrementAndGet() == 2) {
                this.emit();
                if (this.wip.decrementAndGet() == 0) {
                    this.downstream.onComplete();
                }
            }
        }
    }

    static final class SampleTimedNoLast<T>
    extends SampleTimedObserver<T> {
        private static final long serialVersionUID = -7139995637533111443L;

        SampleTimedNoLast(Observer<? super T> actual, long period, TimeUnit unit, Scheduler scheduler) {
            super(actual, period, unit, scheduler);
        }

        @Override
        void complete() {
            this.downstream.onComplete();
        }

        @Override
        public void run() {
            this.emit();
        }
    }

    static abstract class SampleTimedObserver<T>
    extends AtomicReference<T>
    implements Observer<T>,
    Disposable,
    Runnable {
        private static final long serialVersionUID = -3517602651313910099L;
        final Observer<? super T> downstream;
        final long period;
        final TimeUnit unit;
        final Scheduler scheduler;
        final AtomicReference<Disposable> timer = new AtomicReference();
        Disposable upstream;

        SampleTimedObserver(Observer<? super T> actual, long period, TimeUnit unit, Scheduler scheduler) {
            this.downstream = actual;
            this.period = period;
            this.unit = unit;
            this.scheduler = scheduler;
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
                Disposable task = this.scheduler.schedulePeriodicallyDirect(this, this.period, this.period, this.unit);
                DisposableHelper.replace(this.timer, task);
            }
        }

        @Override
        public void onNext(T t2) {
            this.lazySet(t2);
        }

        @Override
        public void onError(Throwable t2) {
            this.cancelTimer();
            this.downstream.onError(t2);
        }

        @Override
        public void onComplete() {
            this.cancelTimer();
            this.complete();
        }

        void cancelTimer() {
            DisposableHelper.dispose(this.timer);
        }

        @Override
        public void dispose() {
            this.cancelTimer();
            this.upstream.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        void emit() {
            Object value = this.getAndSet(null);
            if (value != null) {
                this.downstream.onNext(value);
            }
        }

        abstract void complete();
    }
}

