/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.schedulers;

import io.confluent.shaded.io.reactivex.Scheduler;
import io.confluent.shaded.io.reactivex.annotations.NonNull;
import io.confluent.shaded.io.reactivex.disposables.CompositeDisposable;
import io.confluent.shaded.io.reactivex.disposables.Disposable;
import io.confluent.shaded.io.reactivex.internal.disposables.DisposableContainer;
import io.confluent.shaded.io.reactivex.internal.disposables.DisposableHelper;
import io.confluent.shaded.io.reactivex.internal.disposables.EmptyDisposable;
import io.confluent.shaded.io.reactivex.internal.disposables.SequentialDisposable;
import io.confluent.shaded.io.reactivex.internal.functions.Functions;
import io.confluent.shaded.io.reactivex.internal.queue.MpscLinkedQueue;
import io.confluent.shaded.io.reactivex.internal.schedulers.DisposeOnCancel;
import io.confluent.shaded.io.reactivex.internal.schedulers.ScheduledDirectPeriodicTask;
import io.confluent.shaded.io.reactivex.internal.schedulers.ScheduledDirectTask;
import io.confluent.shaded.io.reactivex.internal.schedulers.ScheduledRunnable;
import io.confluent.shaded.io.reactivex.plugins.RxJavaPlugins;
import io.confluent.shaded.io.reactivex.schedulers.SchedulerRunnableIntrospection;
import io.confluent.shaded.io.reactivex.schedulers.Schedulers;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ExecutorScheduler
extends Scheduler {
    final boolean interruptibleWorker;
    @NonNull
    final Executor executor;
    static final Scheduler HELPER = Schedulers.single();

    public ExecutorScheduler(@NonNull Executor executor, boolean interruptibleWorker) {
        this.executor = executor;
        this.interruptibleWorker = interruptibleWorker;
    }

    @Override
    @NonNull
    public Scheduler.Worker createWorker() {
        return new ExecutorWorker(this.executor, this.interruptibleWorker);
    }

    @Override
    @NonNull
    public Disposable scheduleDirect(@NonNull Runnable run) {
        Runnable decoratedRun = RxJavaPlugins.onSchedule(run);
        try {
            if (this.executor instanceof ExecutorService) {
                ScheduledDirectTask task = new ScheduledDirectTask(decoratedRun);
                Future<Void> f = ((ExecutorService)this.executor).submit(task);
                task.setFuture(f);
                return task;
            }
            if (this.interruptibleWorker) {
                ExecutorWorker.InterruptibleRunnable interruptibleTask = new ExecutorWorker.InterruptibleRunnable(decoratedRun, null);
                this.executor.execute(interruptibleTask);
                return interruptibleTask;
            }
            ExecutorWorker.BooleanRunnable br = new ExecutorWorker.BooleanRunnable(decoratedRun);
            this.executor.execute(br);
            return br;
        }
        catch (RejectedExecutionException ex) {
            RxJavaPlugins.onError(ex);
            return EmptyDisposable.INSTANCE;
        }
    }

    @Override
    @NonNull
    public Disposable scheduleDirect(@NonNull Runnable run, long delay, TimeUnit unit) {
        Runnable decoratedRun = RxJavaPlugins.onSchedule(run);
        if (this.executor instanceof ScheduledExecutorService) {
            try {
                ScheduledDirectTask task = new ScheduledDirectTask(decoratedRun);
                ScheduledFuture<Void> f = ((ScheduledExecutorService)this.executor).schedule(task, delay, unit);
                task.setFuture(f);
                return task;
            }
            catch (RejectedExecutionException ex) {
                RxJavaPlugins.onError(ex);
                return EmptyDisposable.INSTANCE;
            }
        }
        DelayedRunnable dr = new DelayedRunnable(decoratedRun);
        Disposable delayed = HELPER.scheduleDirect(new DelayedDispose(dr), delay, unit);
        dr.timed.replace(delayed);
        return dr;
    }

    @Override
    @NonNull
    public Disposable schedulePeriodicallyDirect(@NonNull Runnable run, long initialDelay, long period, TimeUnit unit) {
        if (this.executor instanceof ScheduledExecutorService) {
            Runnable decoratedRun = RxJavaPlugins.onSchedule(run);
            try {
                ScheduledDirectPeriodicTask task = new ScheduledDirectPeriodicTask(decoratedRun);
                ScheduledFuture<?> f = ((ScheduledExecutorService)this.executor).scheduleAtFixedRate(task, initialDelay, period, unit);
                task.setFuture(f);
                return task;
            }
            catch (RejectedExecutionException ex) {
                RxJavaPlugins.onError(ex);
                return EmptyDisposable.INSTANCE;
            }
        }
        return super.schedulePeriodicallyDirect(run, initialDelay, period, unit);
    }

    final class DelayedDispose
    implements Runnable {
        private final DelayedRunnable dr;

        DelayedDispose(DelayedRunnable dr) {
            this.dr = dr;
        }

        @Override
        public void run() {
            this.dr.direct.replace(ExecutorScheduler.this.scheduleDirect(this.dr));
        }
    }

    static final class DelayedRunnable
    extends AtomicReference<Runnable>
    implements Runnable,
    Disposable,
    SchedulerRunnableIntrospection {
        private static final long serialVersionUID = -4101336210206799084L;
        final SequentialDisposable timed = new SequentialDisposable();
        final SequentialDisposable direct = new SequentialDisposable();

        DelayedRunnable(Runnable run) {
            super(run);
        }

        @Override
        public void run() {
            Runnable r = (Runnable)this.get();
            if (r != null) {
                try {
                    r.run();
                }
                finally {
                    this.lazySet(null);
                    this.timed.lazySet(DisposableHelper.DISPOSED);
                    this.direct.lazySet(DisposableHelper.DISPOSED);
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.get() == null;
        }

        @Override
        public void dispose() {
            if (this.getAndSet(null) != null) {
                this.timed.dispose();
                this.direct.dispose();
            }
        }

        @Override
        public Runnable getWrappedRunnable() {
            Runnable r = (Runnable)this.get();
            return r != null ? r : Functions.EMPTY_RUNNABLE;
        }
    }

    public static final class ExecutorWorker
    extends Scheduler.Worker
    implements Runnable {
        final boolean interruptibleWorker;
        final Executor executor;
        final MpscLinkedQueue<Runnable> queue;
        volatile boolean disposed;
        final AtomicInteger wip = new AtomicInteger();
        final CompositeDisposable tasks = new CompositeDisposable();

        public ExecutorWorker(Executor executor, boolean interruptibleWorker) {
            this.executor = executor;
            this.queue = new MpscLinkedQueue();
            this.interruptibleWorker = interruptibleWorker;
        }

        @Override
        @NonNull
        public Disposable schedule(@NonNull Runnable run) {
            Disposable disposable;
            Disposable task;
            if (this.disposed) {
                return EmptyDisposable.INSTANCE;
            }
            Runnable decoratedRun = RxJavaPlugins.onSchedule(run);
            if (this.interruptibleWorker) {
                InterruptibleRunnable interruptibleTask = new InterruptibleRunnable(decoratedRun, this.tasks);
                this.tasks.add(interruptibleTask);
                task = interruptibleTask;
                disposable = interruptibleTask;
            } else {
                BooleanRunnable runnableTask;
                task = runnableTask = new BooleanRunnable(decoratedRun);
                disposable = runnableTask;
            }
            this.queue.offer((Runnable)((Object)task));
            if (this.wip.getAndIncrement() == 0) {
                try {
                    this.executor.execute(this);
                }
                catch (RejectedExecutionException ex) {
                    this.disposed = true;
                    this.queue.clear();
                    RxJavaPlugins.onError(ex);
                    return EmptyDisposable.INSTANCE;
                }
            }
            return disposable;
        }

        @Override
        @NonNull
        public Disposable schedule(@NonNull Runnable run, long delay, @NonNull TimeUnit unit) {
            if (delay <= 0L) {
                return this.schedule(run);
            }
            if (this.disposed) {
                return EmptyDisposable.INSTANCE;
            }
            SequentialDisposable first = new SequentialDisposable();
            SequentialDisposable mar = new SequentialDisposable(first);
            Runnable decoratedRun = RxJavaPlugins.onSchedule(run);
            ScheduledRunnable sr = new ScheduledRunnable(new SequentialDispose(mar, decoratedRun), this.tasks);
            this.tasks.add(sr);
            if (this.executor instanceof ScheduledExecutorService) {
                try {
                    ScheduledFuture<Object> f = ((ScheduledExecutorService)this.executor).schedule(sr, delay, unit);
                    sr.setFuture(f);
                }
                catch (RejectedExecutionException ex) {
                    this.disposed = true;
                    RxJavaPlugins.onError(ex);
                    return EmptyDisposable.INSTANCE;
                }
            } else {
                Disposable d = HELPER.scheduleDirect(sr, delay, unit);
                sr.setFuture(new DisposeOnCancel(d));
            }
            first.replace(sr);
            return mar;
        }

        @Override
        public void dispose() {
            if (!this.disposed) {
                this.disposed = true;
                this.tasks.dispose();
                if (this.wip.getAndIncrement() == 0) {
                    this.queue.clear();
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.disposed;
        }

        @Override
        public void run() {
            int missed = 1;
            MpscLinkedQueue<Runnable> q = this.queue;
            do {
                Runnable run;
                if (this.disposed) {
                    q.clear();
                    return;
                }
                while ((run = q.poll()) != null) {
                    run.run();
                    if (!this.disposed) continue;
                    q.clear();
                    return;
                }
                if (!this.disposed) continue;
                q.clear();
                return;
            } while ((missed = this.wip.addAndGet(-missed)) != 0);
        }

        static final class InterruptibleRunnable
        extends AtomicInteger
        implements Runnable,
        Disposable {
            private static final long serialVersionUID = -3603436687413320876L;
            final Runnable run;
            final DisposableContainer tasks;
            volatile Thread thread;
            static final int READY = 0;
            static final int RUNNING = 1;
            static final int FINISHED = 2;
            static final int INTERRUPTING = 3;
            static final int INTERRUPTED = 4;

            InterruptibleRunnable(Runnable run, DisposableContainer tasks) {
                this.run = run;
                this.tasks = tasks;
            }

            @Override
            public void run() {
                if (this.get() == 0) {
                    this.thread = Thread.currentThread();
                    if (this.compareAndSet(0, 1)) {
                        try {
                            this.run.run();
                        }
                        finally {
                            this.thread = null;
                            if (this.compareAndSet(1, 2)) {
                                this.cleanup();
                            } else {
                                while (this.get() == 3) {
                                    Thread.yield();
                                }
                                Thread.interrupted();
                            }
                        }
                    } else {
                        this.thread = null;
                    }
                }
            }

            @Override
            public void dispose() {
                int state;
                while ((state = this.get()) < 2) {
                    if (state == 0) {
                        if (!this.compareAndSet(0, 4)) continue;
                        this.cleanup();
                        break;
                    }
                    if (!this.compareAndSet(1, 3)) continue;
                    Thread t2 = this.thread;
                    if (t2 != null) {
                        t2.interrupt();
                        this.thread = null;
                    }
                    this.set(4);
                    this.cleanup();
                    break;
                }
            }

            void cleanup() {
                if (this.tasks != null) {
                    this.tasks.delete(this);
                }
            }

            @Override
            public boolean isDisposed() {
                return this.get() >= 2;
            }
        }

        final class SequentialDispose
        implements Runnable {
            private final SequentialDisposable mar;
            private final Runnable decoratedRun;

            SequentialDispose(SequentialDisposable mar, Runnable decoratedRun) {
                this.mar = mar;
                this.decoratedRun = decoratedRun;
            }

            @Override
            public void run() {
                this.mar.replace(ExecutorWorker.this.schedule(this.decoratedRun));
            }
        }

        static final class BooleanRunnable
        extends AtomicBoolean
        implements Runnable,
        Disposable {
            private static final long serialVersionUID = -2421395018820541164L;
            final Runnable actual;

            BooleanRunnable(Runnable actual) {
                this.actual = actual;
            }

            @Override
            public void run() {
                if (this.get()) {
                    return;
                }
                try {
                    this.actual.run();
                }
                finally {
                    this.lazySet(true);
                }
            }

            @Override
            public void dispose() {
                this.lazySet(true);
            }

            @Override
            public boolean isDisposed() {
                return this.get();
            }
        }
    }
}

