/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.subscribers;

import io.confluent.shaded.io.reactivex.exceptions.Exceptions;
import io.confluent.shaded.io.reactivex.internal.fuseable.ConditionalSubscriber;
import io.confluent.shaded.io.reactivex.internal.fuseable.QueueSubscription;
import io.confluent.shaded.io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.confluent.shaded.io.reactivex.plugins.RxJavaPlugins;
import io.confluent.shaded.org.reactivestreams.Subscription;

public abstract class BasicFuseableConditionalSubscriber<T, R>
implements ConditionalSubscriber<T>,
QueueSubscription<R> {
    protected final ConditionalSubscriber<? super R> downstream;
    protected Subscription upstream;
    protected QueueSubscription<T> qs;
    protected boolean done;
    protected int sourceMode;

    public BasicFuseableConditionalSubscriber(ConditionalSubscriber<? super R> downstream) {
        this.downstream = downstream;
    }

    @Override
    public final void onSubscribe(Subscription s2) {
        if (SubscriptionHelper.validate(this.upstream, s2)) {
            this.upstream = s2;
            if (s2 instanceof QueueSubscription) {
                this.qs = (QueueSubscription)s2;
            }
            if (this.beforeDownstream()) {
                this.downstream.onSubscribe(this);
                this.afterDownstream();
            }
        }
    }

    protected boolean beforeDownstream() {
        return true;
    }

    protected void afterDownstream() {
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.done = true;
        this.downstream.onError(t2);
    }

    protected final void fail(Throwable t2) {
        Exceptions.throwIfFatal(t2);
        this.upstream.cancel();
        this.onError(t2);
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        this.downstream.onComplete();
    }

    protected final int transitiveBoundaryFusion(int mode) {
        QueueSubscription<T> qs = this.qs;
        if (qs != null && (mode & 4) == 0) {
            int m4 = qs.requestFusion(mode);
            if (m4 != 0) {
                this.sourceMode = m4;
            }
            return m4;
        }
        return 0;
    }

    @Override
    public void request(long n) {
        this.upstream.request(n);
    }

    @Override
    public void cancel() {
        this.upstream.cancel();
    }

    @Override
    public boolean isEmpty() {
        return this.qs.isEmpty();
    }

    @Override
    public void clear() {
        this.qs.clear();
    }

    @Override
    public final boolean offer(R e) {
        throw new UnsupportedOperationException("Should not be called!");
    }

    @Override
    public final boolean offer(R v1, R v2) {
        throw new UnsupportedOperationException("Should not be called!");
    }
}

