/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.subscribers;

import io.confluent.shaded.io.reactivex.FlowableSubscriber;
import io.confluent.shaded.io.reactivex.disposables.Disposable;
import io.confluent.shaded.io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.confluent.shaded.io.reactivex.internal.util.EndConsumerHelper;
import io.confluent.shaded.org.reactivestreams.Subscription;
import java.util.concurrent.atomic.AtomicReference;

public abstract class DisposableSubscriber<T>
implements FlowableSubscriber<T>,
Disposable {
    final AtomicReference<Subscription> upstream = new AtomicReference();

    @Override
    public final void onSubscribe(Subscription s2) {
        if (EndConsumerHelper.setOnce(this.upstream, s2, this.getClass())) {
            this.onStart();
        }
    }

    protected void onStart() {
        this.upstream.get().request(Long.MAX_VALUE);
    }

    protected final void request(long n) {
        this.upstream.get().request(n);
    }

    protected final void cancel() {
        this.dispose();
    }

    @Override
    public final boolean isDisposed() {
        return this.upstream.get() == SubscriptionHelper.CANCELLED;
    }

    @Override
    public final void dispose() {
        SubscriptionHelper.cancel(this.upstream);
    }
}

