/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.org.asynchttpclient.netty.future;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;

public class StackTraceInspector {
    private static boolean exceptionInMethod(Throwable t2, String className, String methodName) {
        try {
            for (StackTraceElement element : t2.getStackTrace()) {
                if (!element.getClassName().equals(className) || !element.getMethodName().equals(methodName)) continue;
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static boolean recoverOnConnectCloseException(Throwable t2) {
        return StackTraceInspector.exceptionInMethod(t2, "sun.nio.ch.SocketChannelImpl", "checkConnect") || t2.getCause() != null && StackTraceInspector.recoverOnConnectCloseException(t2.getCause());
    }

    public static boolean recoverOnNettyDisconnectException(Throwable t2) {
        return t2 instanceof ClosedChannelException || StackTraceInspector.exceptionInMethod(t2, "io.confluent.shaded.io.netty.handler.ssl.SslHandler", "disconnect") || t2.getCause() != null && StackTraceInspector.recoverOnConnectCloseException(t2.getCause());
    }

    public static boolean recoverOnReadOrWriteException(Throwable t2) {
        if (t2 instanceof IOException && "Connection reset by peer".equalsIgnoreCase(t2.getMessage())) {
            return true;
        }
        try {
            for (StackTraceElement element : t2.getStackTrace()) {
                String className = element.getClassName();
                String methodName = element.getMethodName();
                if (!className.equals("sun.nio.ch.SocketDispatcher") || !methodName.equals("read") && !methodName.equals("write")) continue;
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return t2.getCause() != null && StackTraceInspector.recoverOnReadOrWriteException(t2.getCause());
    }
}

