/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry;

import io.confluent.shaded.com.google.common.collect.ImmutableMap;
import io.confluent.telemetry.metrics.Keyed;
import java.util.Map;
import java.util.Objects;

public class MetricKey
implements Keyed {
    private final String name;
    private final Map<String, String> labels;

    public MetricKey(String name, Map<String, String> labels) {
        this.name = Objects.requireNonNull(name, "name");
        this.labels = ImmutableMap.copyOf(labels);
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricKey that = (MetricKey)o;
        return this.name.equals(that.name) && this.labels.equals(that.labels);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.labels);
    }

    public String toString() {
        return "MetricKey{name='" + this.name + '\'' + ", labels=" + this.labels + '}';
    }

    @Override
    public MetricKey key() {
        return this;
    }

    public Builder toBuilder() {
        return MetricKey.newBuilder().setName(this.name).putLabels(this.labels);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private final ImmutableMap.Builder<String, String> labelsBuilder = ImmutableMap.builder();

        private Builder() {
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder putLabel(String key, String value) {
            this.labelsBuilder.put(key, value);
            return this;
        }

        public Builder putLabels(Map<String, String> labels) {
            this.labelsBuilder.putAll(labels);
            return this;
        }

        public MetricKey build() {
            return new MetricKey(this.name, this.labelsBuilder.build());
        }
    }
}

