/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

public class RegexConfigDefValidator
implements ConfigDef.Validator {
    private String description;

    public RegexConfigDefValidator(String description) {
        this.description = description;
    }

    public void ensureValid(String name, Object value) {
        String regexString = value.toString();
        try {
            Pattern.compile(regexString);
        }
        catch (PatternSyntaxException e) {
            throw new ConfigException(this.description + name + " is not a valid regular expression");
        }
    }
}

