/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.emitter;

import io.confluent.shaded.com.google.common.base.Suppliers;
import io.confluent.shaded.io.opentelemetry.proto.metrics.v1.Metric;
import io.confluent.shaded.io.opentelemetry.proto.metrics.v1.MetricsData;
import io.confluent.telemetry.MetricKey;
import io.confluent.telemetry.metrics.Keyed;
import java.util.function.Function;
import java.util.function.Supplier;

public class ExportableMetric
implements Keyed {
    private final Metric metric;
    private final MetricKey key;
    private final Supplier<MetricsData> metricsDataSupplier;

    ExportableMetric(Metric metric, MetricKey key, Function<Metric, MetricsData> metricsDataCreator) {
        this.metric = metric;
        this.key = key;
        this.metricsDataSupplier = Suppliers.memoize(() -> (MetricsData)metricsDataCreator.apply(metric));
    }

    public Metric getMetric() {
        return this.metric;
    }

    public MetricsData getMetricsData() {
        return this.metricsDataSupplier.get();
    }

    @Override
    public MetricKey key() {
        return this.key;
    }
}

