/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.emitter;

import io.confluent.shaded.com.google.common.base.Preconditions;
import io.confluent.shaded.io.opentelemetry.proto.metrics.v1.Metric;
import io.confluent.telemetry.Context;
import io.confluent.telemetry.PredicateUtils;
import io.confluent.telemetry.emitter.Emitter;
import io.confluent.telemetry.emitter.ExportableMetric;
import io.confluent.telemetry.exporter.Exporter;
import io.confluent.telemetry.metrics.Keyed;
import io.confluent.telemetry.metrics.SinglePointMetric;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Meter;

public class TelemetryEmitter
implements Emitter {
    private static final String METRICS_GROUP = "TelemetryEmitter";
    private final Context context;
    private final Supplier<Collection<Exporter>> exportersSupplier;
    private volatile Predicate<? super Keyed> metricsPredicate = PredicateUtils.ALWAYS_FALSE;
    private final Sensor exportedMetricsSensor;

    public TelemetryEmitter(Context context, Supplier<Collection<Exporter>> exportersSupplier, Metrics metrics) {
        this.context = context;
        this.exportersSupplier = exportersSupplier;
        this.exportedMetricsSensor = metrics.sensor("exported-records");
        this.exportedMetricsSensor.add((CompoundStat)new Meter(metrics.metricName(this.exportedMetricsSensor.name() + "-rate", METRICS_GROUP), metrics.metricName(this.exportedMetricsSensor.name() + "-total", METRICS_GROUP)));
    }

    @Override
    public boolean shouldEmitMetric(Keyed key) {
        return this.metricsPredicate.test(key);
    }

    @Override
    public boolean emitMetric(SinglePointMetric metric) {
        Metric builtMetric = metric.metric().build();
        ExportableMetric exportableMetric = new ExportableMetric(builtMetric, metric.key(), this.context::buildMetricsData);
        boolean exported = false;
        for (Exporter e : this.exportersSupplier.get()) {
            exported |= e.emit(exportableMetric);
        }
        if (exported) {
            this.exportedMetricsSensor.record();
        }
        return exported;
    }

    public void reconfigurePredicate(Predicate<? super Keyed> metricsPredicate) {
        Preconditions.checkNotNull(metricsPredicate, "metricsPredicate can't be null");
        this.metricsPredicate = metricsPredicate;
    }
}

