/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.exporter;

import io.confluent.shaded.com.google.common.base.Preconditions;
import io.confluent.telemetry.Context;
import io.confluent.telemetry.emitter.ExportableMetric;
import io.confluent.telemetry.exporter.Exporter;
import io.confluent.telemetry.metrics.Keyed;
import java.util.function.Predicate;

public abstract class AbstractExporter
implements Exporter {
    private volatile Predicate<Keyed> metricsPredicate;
    protected final Context context;

    public AbstractExporter(Context context) {
        this(context, k -> true);
    }

    public AbstractExporter(Context context, Predicate<Keyed> metricsPredicate) {
        this.context = context;
        this.metricsPredicate = metricsPredicate;
    }

    @Override
    public Predicate<Keyed> getPredicate() {
        return this.metricsPredicate;
    }

    @Override
    public void reconfigurePredicate(Predicate<Keyed> metricsPredicate) {
        Preconditions.checkNotNull(metricsPredicate, "metricsPredicate can't be null");
        this.metricsPredicate = metricsPredicate;
    }

    public abstract void doEmit(ExportableMetric var1);

    @Override
    public final boolean emit(ExportableMetric exportableMetric) {
        if (this.shouldEmitMetric(exportableMetric)) {
            this.doEmit(exportableMetric);
            return true;
        }
        return false;
    }

    private boolean shouldEmitMetric(Keyed key) {
        return this.metricsPredicate.test(key);
    }
}

