/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.metrics;

import io.confluent.shaded.io.opentelemetry.proto.common.v1.AnyValue;
import io.confluent.shaded.io.opentelemetry.proto.common.v1.KeyValue;
import io.confluent.shaded.io.opentelemetry.proto.metrics.v1.AggregationTemporality;
import io.confluent.shaded.io.opentelemetry.proto.metrics.v1.Metric;
import io.confluent.shaded.io.opentelemetry.proto.metrics.v1.NumberDataPoint;
import io.confluent.telemetry.MetricKey;
import io.confluent.telemetry.MetricsUtils;
import io.confluent.telemetry.metrics.Keyed;
import java.time.Instant;
import java.util.Map;

public class SinglePointMetric
implements Keyed {
    private final MetricKey key;
    private final Metric.Builder metricBuilder;

    private SinglePointMetric(MetricKey key, Metric.Builder metricBuilder) {
        this.key = key;
        this.metricBuilder = metricBuilder;
    }

    @Override
    public MetricKey key() {
        return this.key;
    }

    public Metric.Builder metric() {
        return this.metricBuilder;
    }

    public static SinglePointMetric create(MetricKey metricKey, Metric.Builder metric) {
        return new SinglePointMetric(metricKey, metric);
    }

    private static NumberDataPoint.Builder point(Instant timestamp, Number value) {
        if (value instanceof Long || value instanceof Integer) {
            return SinglePointMetric.point(timestamp, value.longValue());
        }
        return SinglePointMetric.point(timestamp, value.doubleValue());
    }

    private static NumberDataPoint.Builder point(Instant timestamp, long value) {
        return NumberDataPoint.newBuilder().setTimeUnixNano(MetricsUtils.toTimeUnixNanos(timestamp)).setAsInt(value);
    }

    private static NumberDataPoint.Builder point(Instant timestamp, double value) {
        return NumberDataPoint.newBuilder().setTimeUnixNano(MetricsUtils.toTimeUnixNanos(timestamp)).setAsDouble(value);
    }

    public static Iterable<KeyValue> asAttributes(Map<String, String> labels) {
        return labels.entrySet().stream().map(entry -> KeyValue.newBuilder().setKey((String)entry.getKey()).setValue(AnyValue.newBuilder().setStringValue((String)entry.getValue())).build())::iterator;
    }

    public static SinglePointMetric gauge(MetricKey metricKey, Number value, Instant timestamp) {
        NumberDataPoint.Builder point = SinglePointMetric.point(timestamp, value);
        return SinglePointMetric.gauge(metricKey, point);
    }

    public static SinglePointMetric gauge(MetricKey metricKey, long value, Instant timestamp) {
        NumberDataPoint.Builder point = SinglePointMetric.point(timestamp, value);
        return SinglePointMetric.gauge(metricKey, point);
    }

    public static SinglePointMetric gauge(MetricKey metricKey, double value, Instant timestamp) {
        NumberDataPoint.Builder point = SinglePointMetric.point(timestamp, value);
        return SinglePointMetric.gauge(metricKey, point);
    }

    private static SinglePointMetric gauge(MetricKey metricKey, NumberDataPoint.Builder point) {
        point.addAllAttributes(SinglePointMetric.asAttributes(metricKey.getLabels()));
        Metric.Builder metric = Metric.newBuilder().setName(metricKey.getName());
        metric.getGaugeBuilder().addDataPoints(point);
        return SinglePointMetric.create(metricKey, metric);
    }

    public static SinglePointMetric deltaSum(MetricKey metricKey, long value, boolean monotonic, Instant timestamp, Instant startTimestamp) {
        NumberDataPoint.Builder point = SinglePointMetric.point(timestamp, value).setStartTimeUnixNano(MetricsUtils.toTimeUnixNanos(startTimestamp));
        return SinglePointMetric.sum(metricKey, AggregationTemporality.AGGREGATION_TEMPORALITY_DELTA, monotonic, point);
    }

    public static SinglePointMetric deltaSum(MetricKey metricKey, double value, boolean monotonic, Instant timestamp, Instant startTimestamp) {
        NumberDataPoint.Builder point = SinglePointMetric.point(timestamp, value).setStartTimeUnixNano(MetricsUtils.toTimeUnixNanos(startTimestamp));
        return SinglePointMetric.sum(metricKey, AggregationTemporality.AGGREGATION_TEMPORALITY_DELTA, monotonic, point);
    }

    public static SinglePointMetric sum(MetricKey metricKey, long value, boolean monotonic, Instant timestamp) {
        return SinglePointMetric.sum(metricKey, value, monotonic, timestamp, null);
    }

    public static SinglePointMetric sum(MetricKey metricKey, double value, boolean monotonic, Instant timestamp) {
        return SinglePointMetric.sum(metricKey, value, monotonic, timestamp, null);
    }

    public static SinglePointMetric sum(MetricKey metricKey, long value, boolean monotonic, Instant timestamp, Instant startTimestamp) {
        NumberDataPoint.Builder point = SinglePointMetric.point(timestamp, value);
        if (startTimestamp != null) {
            point.setStartTimeUnixNano(MetricsUtils.toTimeUnixNanos(startTimestamp));
        }
        return SinglePointMetric.sum(metricKey, AggregationTemporality.AGGREGATION_TEMPORALITY_CUMULATIVE, monotonic, point);
    }

    public static SinglePointMetric sum(MetricKey metricKey, double value, boolean monotonic, Instant timestamp, Instant startTimestamp) {
        NumberDataPoint.Builder point = SinglePointMetric.point(timestamp, value);
        if (startTimestamp != null) {
            point.setStartTimeUnixNano(MetricsUtils.toTimeUnixNanos(startTimestamp));
        }
        return SinglePointMetric.sum(metricKey, AggregationTemporality.AGGREGATION_TEMPORALITY_CUMULATIVE, monotonic, point);
    }

    private static SinglePointMetric sum(MetricKey metricKey, AggregationTemporality aggregationTemporality, boolean monotonic, NumberDataPoint.Builder point) {
        point.addAllAttributes(SinglePointMetric.asAttributes(metricKey.getLabels()));
        Metric.Builder metric = Metric.newBuilder().setName(metricKey.getName());
        metric.getSumBuilder().setAggregationTemporality(aggregationTemporality).setIsMonotonic(monotonic).addDataPoints(point);
        return SinglePointMetric.create(metricKey, metric);
    }
}

