/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.provider;

import io.confluent.shaded.com.google.common.collect.ImmutableList;
import io.confluent.shaded.io.opentelemetry.proto.resource.v1.Resource;
import io.confluent.telemetry.ConfluentTelemetryConfig;
import io.confluent.telemetry.Context;
import io.confluent.telemetry.collector.JvmMetricsCollector;
import io.confluent.telemetry.collector.MetricsCollector;
import io.confluent.telemetry.collector.VolumeMetricsCollector;
import io.confluent.telemetry.provider.Provider;
import io.confluent.telemetry.provider.Utils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.metrics.MetricsContext;

public class ControlCenterProvider
implements Provider {
    private static final List<String> DEFAULT_METRICS_INCLUDE_LIST = Collections.unmodifiableList(Arrays.asList("io.confluent.system/.*(process_cpu_load|max_file_descriptor_count|open_file_descriptor_count|system_cpu_load|system_load_average|free_physical_memory_size|total_physical_memory_size|disk_total_bytes|disk_usable_bytes|jvm/mem|jvm/gc)", "io.confluent.controlcenter/.*(metrics_input_topic_progress|monitoring_input_topic_progress|misconfigured_topics|missing_topic_configurations|broker_log_persistent_dir|cluster_offline|streams_status|total_lag|request_latency|response_size|response_rate)"));
    public static final String DOMAIN = "io.confluent.controlcenter";
    public static final String NAMESPACE = "confluent.controlcenter";
    private Resource resource;
    private ConfluentTelemetryConfig config;

    public synchronized void configure(Map<String, ?> configs) {
        this.config = new ConfluentTelemetryConfig(configs);
    }

    @Override
    public boolean validate(MetricsContext metricsContext, Map<String, ?> config) {
        Map metadata = metricsContext.contextLabels();
        return Utils.notEmptyString(metadata, "_namespace") && Utils.notEmptyString(metadata, "resource.type") && Utils.notEmptyString(metadata, "resource.version") && Utils.notEmptyString(metadata, "resource.cluster.id");
    }

    @Override
    public void contextChange(MetricsContext metricsContext) {
        this.resource = Utils.buildResourceFromLabels(metricsContext).build();
    }

    @Override
    public List<String> metricsIncludeRegexDefault() {
        return DEFAULT_METRICS_INCLUDE_LIST;
    }

    @Override
    public Resource resource() {
        return this.resource;
    }

    @Override
    public String domain() {
        return DOMAIN;
    }

    @Override
    public List<MetricsCollector> extraCollectors(Context ctx) {
        return ImmutableList.of(JvmMetricsCollector.newBuilder().setContext(ctx).build(), VolumeMetricsCollector.newBuilder(this.config).setContext(ctx).build());
    }
}

