/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.serde;

import io.confluent.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.shaded.com.fasterxml.jackson.databind.SerializationFeature;
import io.confluent.shaded.com.google.protobuf.Timestamp;
import io.confluent.shaded.io.opencensus.proto.metrics.v1.DistributionValue;
import io.confluent.shaded.io.opencensus.proto.metrics.v1.Metric;
import io.confluent.shaded.io.opencensus.proto.metrics.v1.Point;
import io.confluent.shaded.io.opencensus.proto.metrics.v1.SummaryValue;
import io.confluent.shaded.io.opencensus.proto.metrics.v1.TimeSeries;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;

public class ProtoToFlatJson
implements Deserializer<String> {
    private static final String TIMESTAMP_COLUMN = "timestamp";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private ObjectMapper mapper = new ObjectMapper();

    public static Instant toInstant(Timestamp timestamp) {
        return Instant.ofEpochSecond(timestamp.getSeconds(), timestamp.getNanos());
    }

    public ProtoToFlatJson() {
        this(false);
    }

    public ProtoToFlatJson(boolean orderByKeys) {
        if (orderByKeys) {
            this.mapper.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
        }
    }

    public void configure(Map configs, boolean isKey) {
    }

    public void close() {
    }

    public String deserialize(String topic, byte[] data) {
        if (data == null) {
            return null;
        }
        ArrayList result = new ArrayList();
        try {
            Metric metric = Metric.parseFrom(data);
            for (TimeSeries ts : metric.getTimeseriesList()) {
                HashMap<String, Object> labels = new HashMap<String, Object>();
                labels.putAll(metric.getResource().getLabelsMap());
                labels.put("resource_type", metric.getResource().getType());
                for (int i = 0; i < metric.getMetricDescriptor().getLabelKeysCount(); ++i) {
                    labels.put(metric.getMetricDescriptor().getLabelKeys(i).getKey(), ts.getLabelValues(i).getValue());
                }
                labels.put(TYPE, metric.getMetricDescriptor().getType().toString());
                for (Point point : ts.getPointsList()) {
                    Instant timestamp = Instant.ofEpochSecond(point.getTimestamp().getSeconds(), point.getTimestamp().getNanos());
                    labels.put(TIMESTAMP_COLUMN, ProtoToFlatJson.toInstant(point.getTimestamp()).toEpochMilli());
                    HashMap<String, Object> object = new HashMap<String, Object>();
                    object.putAll(labels);
                    if (ts.hasStartTimestamp() && ts.getStartTimestamp() != null) {
                        object.put("startTimestamp", ProtoToFlatJson.toInstant(ts.getStartTimestamp()).toEpochMilli());
                    }
                    switch (point.getValueCase()) {
                        case DOUBLE_VALUE: {
                            object.put(NAME, metric.getMetricDescriptor().getName());
                            object.put("doubleValue", point.getDoubleValue());
                            result.add(object);
                            break;
                        }
                        case INT64_VALUE: {
                            object.put("int64Value", point.getInt64Value());
                            object.put(NAME, metric.getMetricDescriptor().getName());
                            result.add(object);
                            break;
                        }
                        case SUMMARY_VALUE: {
                            object.put(NAME, metric.getMetricDescriptor().getName());
                            object.put("count", point.getSummaryValue().getCount().getValue());
                            object.put("sum", point.getSummaryValue().getSnapshot().getSum().getValue());
                            for (SummaryValue.Snapshot.ValueAtPercentile p : point.getSummaryValue().getSnapshot().getPercentileValuesList()) {
                                object.put("" + p.getPercentile(), point.getSummaryValue().getSnapshot().getSum().getValue());
                            }
                            result.add(object);
                            break;
                        }
                        case DISTRIBUTION_VALUE: {
                            object.put(NAME, metric.getMetricDescriptor().getName());
                            object.put("count", point.getDistributionValue().getCount());
                            object.put("sum", point.getDistributionValue().getSum());
                            object.put("variance", point.getDistributionValue().getSumOfSquaredDeviation());
                            for (DistributionValue.Bucket bucket : point.getDistributionValue().getBucketsList()) {
                            }
                            result.add(object);
                        }
                    }
                }
            }
            if (result.size() > 0) {
                return this.mapper.writeValueAsString(result.get(0));
            }
            throw new RuntimeException("empty serialized object.");
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (Exception e) {
            String errMsg = "Error deserializing protobuf message";
            throw new SerializationException(errMsg, (Throwable)e);
        }
    }

    public String deserialize(String topic, Headers headers, byte[] data) {
        return this.deserialize(topic, data);
    }
}

