/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.rest.resources;

import com.google.common.annotations.VisibleForTesting;
import io.swagger.v3.oas.annotations.Operation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.ThreadUtils;
import org.apache.kafka.connect.errors.NotFoundException;
import org.apache.kafka.connect.runtime.rest.errors.BadRequestException;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

@Path(value="/admin/loggers")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class LoggingResource {
    private static final String ROOT_LOGGER_NAME = "root";
    private static final String SHUTDOWN_HOOK_LOG_AUTORESET_SERVICE = "shutdownLogAutoResetService";
    private static final String LOG_AUTO_RESET_SERVICE_THREAD_PATTERN = "LogAutoResetService-%d";
    private ScheduledExecutorService logAutoResetService = Executors.newSingleThreadScheduledExecutor(ThreadUtils.createThreadFactory((String)"LogAutoResetService-%d", (boolean)false));
    private static final ConcurrentHashMap<Logger, LogContext> OLD_LOG_LEVELS = new ConcurrentHashMap();

    public LoggingResource() {
        Exit.addShutdownHook((String)SHUTDOWN_HOOK_LOG_AUTORESET_SERVICE, () -> this.logAutoResetService.shutdownNow());
    }

    @GET
    @Operation(summary="List the current loggers that have their levels explicitly set and their log levels")
    public Response listLoggers() {
        TreeMap<String, Map<String, String>> loggers = new TreeMap<String, Map<String, String>>();
        Enumeration<Logger> enumeration = this.currentLoggers();
        Collections.list(enumeration).stream().filter(logger -> logger.getLevel() != null).forEach(logger -> loggers.put(logger.getName(), LoggingResource.levelToMap(logger)));
        Logger root = this.rootLogger();
        if (root.getLevel() != null) {
            loggers.put(ROOT_LOGGER_NAME, LoggingResource.levelToMap(root));
        }
        return Response.ok(loggers).build();
    }

    @GET
    @Path(value="/{logger}")
    @Operation(summary="Get the log level for the specified logger")
    public Response getLogger(@PathParam(value="logger") String namedLogger) {
        Objects.requireNonNull(namedLogger, "require non-null name");
        Logger logger = null;
        if (ROOT_LOGGER_NAME.equalsIgnoreCase(namedLogger)) {
            logger = this.rootLogger();
        } else {
            Enumeration<Logger> en = this.currentLoggers();
            while (en.hasMoreElements()) {
                Logger l = en.nextElement();
                if (!namedLogger.equals(l.getName())) continue;
                logger = l;
                break;
            }
        }
        if (logger == null) {
            throw new NotFoundException("Logger " + namedLogger + " not found.");
        }
        return Response.ok(LoggingResource.effectiveLevelToMap(logger)).build();
    }

    @PUT
    @Path(value="/{logger}")
    @Operation(summary="Set the log level for the specified logger")
    public Response setLevel(@PathParam(value="logger") String namedLogger, Map<String, String> levelMap) {
        ArrayList<Object> childLoggers;
        String desiredLevelStr = levelMap.get("level");
        if (desiredLevelStr == null) {
            throw new BadRequestException("Desired 'level' parameter was not specified in request.");
        }
        Level level = Level.toLevel((String)desiredLevelStr.toUpperCase(Locale.ROOT), null);
        if (level == null) {
            throw new NotFoundException("invalid log level '" + desiredLevelStr + "'.");
        }
        if (ROOT_LOGGER_NAME.equalsIgnoreCase(namedLogger)) {
            childLoggers = Collections.list(this.currentLoggers());
            childLoggers.add(this.rootLogger());
        } else {
            boolean bl;
            childLoggers = new ArrayList();
            Logger ancestorLogger = this.lookupLogger(namedLogger);
            Enumeration<Logger> en = this.currentLoggers();
            boolean bl2 = false;
            while (en.hasMoreElements()) {
                Logger current = en.nextElement();
                if (current.getName().startsWith(namedLogger)) {
                    childLoggers.add(current);
                }
                if (!namedLogger.equals(current.getName())) continue;
                bl = true;
            }
            if (!bl) {
                childLoggers.add(ancestorLogger);
            }
        }
        ArrayList<String> modifiedLoggerNames = new ArrayList<String>();
        for (Logger logger : childLoggers) {
            LogContext logContext;
            if (OLD_LOG_LEVELS.containsKey(logger) && (logContext = OLD_LOG_LEVELS.remove(logger)) != null) {
                logContext.getAutoResetFuture().cancel(false);
            }
            logger.setLevel(level);
            modifiedLoggerNames.add(logger.getName());
        }
        Collections.sort(modifiedLoggerNames);
        return Response.ok(modifiedLoggerNames).build();
    }

    @PUT
    @Path(value="/{logger}/timeout")
    @Operation(summary="Set the level for the specified logger with specified timeout")
    public Response setLevelWithTimeout(@PathParam(value="logger") String namedLogger, Map<String, String> levelTimeoutMap) {
        ArrayList<Object> childLoggers;
        Long delay;
        String desiredLevelStr = levelTimeoutMap.get("level");
        if (desiredLevelStr == null) {
            throw new BadRequestException("Desired 'level' parameter was not specified in request.");
        }
        try {
            delay = Long.parseLong(levelTimeoutMap.get("timeout"));
        }
        catch (NumberFormatException e) {
            throw new BadRequestException(e.getMessage());
        }
        Level level = Level.toLevel((String)desiredLevelStr.toUpperCase(Locale.ROOT), null);
        if (level == null) {
            throw new NotFoundException("invalid log level '" + desiredLevelStr + "'.");
        }
        if (ROOT_LOGGER_NAME.equalsIgnoreCase(namedLogger)) {
            childLoggers = Collections.list(this.currentLoggers());
            childLoggers.add(this.rootLogger());
        } else {
            boolean bl;
            childLoggers = new ArrayList();
            Logger ancestorLogger = this.lookupLogger(namedLogger);
            Enumeration<Logger> en = this.currentLoggers();
            boolean bl2 = false;
            while (en.hasMoreElements()) {
                Logger current = en.nextElement();
                if (current.getName().startsWith(namedLogger)) {
                    childLoggers.add(current);
                }
                if (!namedLogger.equals(current.getName())) continue;
                bl = true;
            }
            if (!bl) {
                childLoggers.add(ancestorLogger);
            }
        }
        TreeMap<String, Long> modifiedLoggerNames = new TreeMap<String, Long>();
        for (Logger logger : childLoggers) {
            Level oldLogLevel = OLD_LOG_LEVELS.containsKey(logger) ? OLD_LOG_LEVELS.get(logger).getLevel() : logger.getLevel();
            modifiedLoggerNames.put(logger.getName(), delay);
            logger.setLevel(level);
            ScheduledFuture<?> autoResetFuture = this.logAutoResetService.schedule(() -> {
                logger.setLevel(oldLogLevel);
                OLD_LOG_LEVELS.remove(logger);
            }, (long)delay, TimeUnit.MILLISECONDS);
            OLD_LOG_LEVELS.put(logger, new LogContext(oldLogLevel, delay, autoResetFuture));
        }
        return Response.ok(modifiedLoggerNames).build();
    }

    @GET
    @Path(value="/timeouts")
    @Operation(summary="List the current loggers that have their levels explicitly set and their log levels, auto-reset timeouts")
    public Response listLoggersWithTimeouts() {
        TreeMap<String, Map<String, String>> loggers = new TreeMap<String, Map<String, String>>();
        Enumeration<Logger> enumeration = this.currentLoggers();
        Collections.list(enumeration).stream().filter(logger -> logger.getLevel() != null).forEach(logger -> loggers.put(logger.getName(), LoggingResource.levelAndTimeoutToMap(logger)));
        Logger root = this.rootLogger();
        if (root.getLevel() != null) {
            loggers.put(ROOT_LOGGER_NAME, LoggingResource.levelToMap(root));
        }
        return Response.ok(loggers).build();
    }

    protected Logger lookupLogger(String namedLogger) {
        return LogManager.getLogger((String)namedLogger);
    }

    protected Enumeration<Logger> currentLoggers() {
        return LogManager.getCurrentLoggers();
    }

    protected Logger rootLogger() {
        return LogManager.getRootLogger();
    }

    private static Map<String, String> effectiveLevelToMap(Logger logger) {
        Level level = logger.getLevel();
        if (level == null) {
            level = logger.getEffectiveLevel();
        }
        return Collections.singletonMap("level", String.valueOf(level));
    }

    private static Map<String, String> levelToMap(Logger logger) {
        return Collections.singletonMap("level", String.valueOf(logger.getLevel()));
    }

    private static Map<String, String> levelAndTimeoutToMap(Logger logger) {
        HashMap<String, String> levelAndTimeoutMap = new HashMap<String, String>();
        levelAndTimeoutMap.put("level", String.valueOf(logger.getLevel()));
        if (OLD_LOG_LEVELS.containsKey(logger)) {
            levelAndTimeoutMap.put("timeout", String.valueOf(OLD_LOG_LEVELS.get(logger).delay));
        }
        return levelAndTimeoutMap;
    }

    @VisibleForTesting
    void setLogAutoResetService(ScheduledExecutorService scheduledExecutorService) {
        this.logAutoResetService = scheduledExecutorService;
    }

    static class LogContext {
        private Level level;
        private Long delay;
        private ScheduledFuture<?> autoResetFuture;

        public LogContext(Level level, Long delay, ScheduledFuture<?> autoResetFuture) {
            this.level = level;
            this.delay = delay;
            this.autoResetFuture = autoResetFuture;
        }

        public ScheduledFuture<?> getAutoResetFuture() {
            return this.autoResetFuture;
        }

        public Level getLevel() {
            return this.level;
        }

        public Long getDelay() {
            return this.delay;
        }
    }
}

