/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.bouncycastle.tls.ServerName;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.io.Streams;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ServerNameList {
    protected Vector serverNameList;

    public ServerNameList(Vector vector) {
        if (null == vector) {
            throw new NullPointerException("'serverNameList' cannot be null");
        }
        this.serverNameList = vector;
    }

    public Vector getServerNameList() {
        return this.serverNameList;
    }

    public void encode(OutputStream outputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        short[] sArray = TlsUtils.EMPTY_SHORTS;
        for (int i = 0; i < this.serverNameList.size(); ++i) {
            ServerName serverName = (ServerName)this.serverNameList.elementAt(i);
            if (null == (sArray = ServerNameList.checkNameType(sArray, serverName.getNameType()))) {
                throw new TlsFatalAlert(80);
            }
            serverName.encode(byteArrayOutputStream);
        }
        TlsUtils.checkUint16(byteArrayOutputStream.size());
        TlsUtils.writeUint16(byteArrayOutputStream.size(), outputStream);
        Streams.writeBufTo((ByteArrayOutputStream)byteArrayOutputStream, (OutputStream)outputStream);
    }

    public static ServerNameList parse(InputStream inputStream) throws IOException {
        byte[] byArray = TlsUtils.readOpaque16(inputStream, 1);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        short[] sArray = TlsUtils.EMPTY_SHORTS;
        Vector<ServerName> vector = new Vector<ServerName>();
        while (byteArrayInputStream.available() > 0) {
            ServerName serverName = ServerName.parse(byteArrayInputStream);
            if (null == (sArray = ServerNameList.checkNameType(sArray, serverName.getNameType()))) {
                throw new TlsFatalAlert(47);
            }
            vector.addElement(serverName);
        }
        return new ServerNameList(vector);
    }

    private static short[] checkNameType(short[] sArray, short s) {
        if (Arrays.contains((short[])sArray, (short)s)) {
            return null;
        }
        return Arrays.append((short[])sArray, (short)s);
    }
}

