/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals;

import com.linkedin.kafka.cruisecontrol.analyzer.ActionAcceptance;
import com.linkedin.kafka.cruisecontrol.analyzer.ActionType;
import com.linkedin.kafka.cruisecontrol.analyzer.AnalyzerUtils;
import com.linkedin.kafka.cruisecontrol.analyzer.BalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.BalancingConstraint;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.ReplicaBalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.AcceptanceResult;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.Goal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.GoalOptimizationResult;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.GoalUtils;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.ProposalStats;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.internals.CandidateBroker;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.internals.DetailedProposal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.internals.ProposalObservabilityTrackingOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.metrics.OptimizationMetrics;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.exception.OptimizationFailureException;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.ClusterModelStats;
import com.linkedin.kafka.cruisecontrol.model.Disk;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import com.linkedin.kafka.cruisecontrol.model.util.ClusterModelStatsComparator;
import io.confluent.cruisecontrol.analyzer.history.TopicPartitionMovement;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGoal
implements Goal {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractGoal.class);
    protected boolean finished = false;
    protected BalancingConstraint balancingConstraint;
    protected int numWindows;
    protected double minMonitoredPartitionPercentage;
    protected GoalOptimizationResult.Builder optimizationResultBuilder = new GoalOptimizationResult.Builder();
    protected ProposalStats.Builder proposalStatsBuilder = new ProposalStats.Builder(this.proposalTrackingOptions());

    @Override
    public void configure(Map<String, ?> configs) {
        KafkaCruiseControlConfig parsedConfig = new KafkaCruiseControlConfig(configs, false);
        this.balancingConstraint = new BalancingConstraint(parsedConfig);
        this.numWindows = parsedConfig.getInt("num.partition.metrics.windows");
        this.minMonitoredPartitionPercentage = parsedConfig.getDouble("min.valid.partition.ratio");
    }

    @Override
    public GoalOptimizationResult optimize(ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions, Optional<OptimizationMetrics> optimizationMetricsOpt) throws OptimizationFailureException {
        ClusterModelStatsComparator comparator;
        this.optimizationResultBuilder = new GoalOptimizationResult.Builder();
        LOG.debug("Starting optimization for {}.", (Object)this.name());
        ClusterModelStats statsBeforeOptimization = clusterModel.getClusterStats(this.balancingConstraint);
        LOG.trace("[PRE - {}] {}", (Object)this.name(), (Object)statsBeforeOptimization);
        this.finished = false;
        long goalStartTime = System.currentTimeMillis();
        this.proposalStatsBuilder = new ProposalStats.Builder(this.proposalTrackingOptions());
        this.initGoalState(clusterModel, optimizationOptions, optimizationMetricsOpt);
        SortedSet<Broker> brokenBrokers = clusterModel.brokenBrokers();
        Set<String> excludedTopics = optimizationOptions.excludedTopics();
        while (!this.finished) {
            for (Broker broker : this.brokersToBalance(clusterModel)) {
                this.rebalanceForBroker(broker, clusterModel, optimizedGoals, optimizationOptions);
            }
            this.updateGoalState(clusterModel, excludedTopics);
        }
        ClusterModelStats statsAfterOptimization = clusterModel.getClusterStats(this.balancingConstraint);
        ProposalStats proposalStats = this.proposalStatsBuilder.seal();
        this.optimizationResultBuilder.proposalStats(proposalStats);
        LOG.trace("[POST - {}] {}", (Object)this.name(), (Object)statsAfterOptimization);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finished optimization for {} in {}ms.", (Object)this.name(), (Object)(System.currentTimeMillis() - goalStartTime));
            LOG.debug("Proposal stats for {}: {}", (Object)this.name(), (Object)proposalStats.generateString(true));
        }
        LOG.trace("Cluster after optimization is {}", (Object)clusterModel);
        if (brokenBrokers.isEmpty() && (comparator = this.clusterModelStatsComparator()).compare(statsAfterOptimization, statsBeforeOptimization) < 0) {
            throw new OptimizationFailureException("Optimization for Goal " + this.name() + " failed because the optimizedresult is worse than before. Detail reason: " + comparator.explainLastComparison());
        }
        GoalOptimizationResult goalOptimizationResult = this.optimizationResultBuilder.build();
        if (LOG.isDebugEnabled()) {
            this.logBrokerResultStates(goalOptimizationResult);
        }
        return goalOptimizationResult;
    }

    private void logBrokerResultStates(GoalOptimizationResult goalOptimizationResult) {
        Map<Integer, GoalOptimizationResult.BrokerResultState> brokerResultStates = goalOptimizationResult.brokerResultStates();
        if (brokerResultStates.isEmpty()) {
            LOG.debug("No balancing statuses were saved as part of executing {}. It's possible that every broker was under the low utilization threshold, or some other check stopped the goal from balancing brokers", (Object)this.getClass().getSimpleName());
        } else {
            LOG.debug("After executing {}, balancing statuses of brokers are {}", (Object)this.getClass().getSimpleName(), brokerResultStates);
        }
    }

    @Override
    public abstract String name();

    protected static boolean shouldExclude(Replica replica, Set<String> excludedTopics) {
        return excludedTopics.contains(replica.topicPartition().topic()) && !replica.isOriginalOffline();
    }

    protected static boolean shouldExclude(BalancingAction balancingAction, List<Broker> sourceBrokers, Set<String> excludedTopics) {
        boolean allBrokersAreAlive = sourceBrokers.stream().allMatch(Broker::isAlive);
        return excludedTopics.contains(balancingAction.topicPartition().topic()) && allBrokersAreAlive;
    }

    protected abstract SortedSet<Broker> brokersToBalance(ClusterModel var1);

    public final boolean selfSatisfied(ClusterModel clusterModel, BalancingAction action) {
        return action.selfSatisfied(clusterModel, this);
    }

    protected abstract void initGoalState(ClusterModel var1, OptimizationOptions var2, Optional<OptimizationMetrics> var3) throws OptimizationFailureException;

    protected abstract void updateGoalState(ClusterModel var1, Set<String> var2) throws OptimizationFailureException;

    protected abstract void rebalanceForBroker(Broker var1, ClusterModel var2, Set<Goal> var3, OptimizationOptions var4) throws OptimizationFailureException;

    protected Broker maybeApplyBalancingAction(ClusterModel clusterModel, Replica replica, Collection<Broker> candidateBrokers, ActionType action, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions, Optional<DetailedProposal.Builder> detailedProposalOptional) {
        return this.maybeApplyBalancingAction(clusterModel, replica, candidateBrokers, action, optimizedGoals, optimizationOptions, d -> String.format("Try moving replica %s from broker %d to one of brokers %s via action %s", replica.toString(), replica.broker().id(), candidateBrokers.toString(), action.toString()), detailedProposalOptional);
    }

    protected Broker maybeApplyBalancingActions(ClusterModel clusterModel, Replica replica, Collection<Broker> candidateBrokers, Collection<ActionType> actions, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions, Optional<DetailedProposal.Builder> detailedProposalOptional) {
        for (ActionType action : actions) {
            Broker newDestination = this.maybeApplyBalancingAction(clusterModel, replica, candidateBrokers, action, optimizedGoals, optimizationOptions, d -> String.format("Try moving replica %s from broker %d to one of brokers %s via action %s", replica.toString(), replica.broker().id(), candidateBrokers.toString(), action.toString()), detailedProposalOptional);
            if (newDestination == null) continue;
            return newDestination;
        }
        return null;
    }

    protected Broker maybeApplyBalancingAction(ClusterModel clusterModel, Replica replica, Collection<Broker> candidateBrokers, ActionType action, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions, DetailedProposal.DetailedReasonBuilder detailedReasonBuilder, Optional<DetailedProposal.Builder> detailedProposalOptional) {
        boolean topicPartitionIsSuspended;
        if (!clusterModel.deadBrokers().isEmpty() && replica.originalBroker().isAlive()) {
            LOG.trace("Applying {} to an online replica because there are dead brokers.", (Object)action);
        }
        boolean bl = topicPartitionIsSuspended = !this.isHardGoal() && !replica.isCurrentOffline() && this.isSuspended(replica.topicPartition(), optimizationOptions);
        if (topicPartitionIsSuspended) {
            LOG.trace("Did not apply actions to Replica {} since it is not an offline replica and its TopicPartition is suspended to prevent excess amount of repeated movements", (Object)replica);
            return null;
        }
        List<Broker> eligibleDestinationBrokers = GoalUtils.eligibleBrokers(clusterModel, replica, candidateBrokers, action, optimizationOptions);
        for (Broker potentialDestinationBroker : eligibleDestinationBrokers) {
            ReplicaBalancingAction proposal = new ReplicaBalancingAction(replica.topicPartition(), replica.broker().id(), potentialDestinationBroker.id(), action);
            if (!GoalUtils.legitMove(replica, potentialDestinationBroker, clusterModel, action)) {
                LOG.trace("Replica move to broker is not legit for {}.", (Object)proposal);
                continue;
            }
            if (!this.selfSatisfied(clusterModel, proposal)) {
                LOG.trace("Unable to self-satisfy proposal {}.", (Object)proposal);
                continue;
            }
            String movementReason = detailedReasonBuilder.build(String.format("broker %d", potentialDestinationBroker.id()));
            ActionAcceptance actionAcceptance = this.tryAcceptProposal(optimizedGoals, proposal, clusterModel, detailedProposalOptional.map(builder -> builder.build(movementReason)));
            LOG.trace("Trying to apply legit and self-satisfied action {}, actionAcceptance = {}", (Object)proposal, (Object)actionAcceptance);
            if (actionAcceptance != ActionAcceptance.ACCEPT) continue;
            TopicPartition tp = replica.topicPartition();
            int sourceBroker = replica.broker().id();
            int destinationBroker = potentialDestinationBroker.id();
            if (action == ActionType.LEADERSHIP_MOVEMENT) {
                this.relocateLeadership(clusterModel, tp, sourceBroker, destinationBroker);
            } else if (action == ActionType.INTER_BROKER_REPLICA_MOVEMENT) {
                this.relocateReplica(clusterModel, tp, sourceBroker, destinationBroker);
            }
            optimizationOptions.goalOptimizationHistoryOptions().ifPresent(goalOptimizationHistoryOptions -> {
                long historyEpoch = goalOptimizationHistoryOptions.historyEpoch();
                long topicPartitionMovementExpirationMs = goalOptimizationHistoryOptions.topicPartitionMovementExpirationMs();
                TopicPartitionMovement topicPartitionMovement = new TopicPartitionMovement(tp, sourceBroker, destinationBroker, this.getClass(), movementReason, topicPartitionMovementExpirationMs, historyEpoch);
                this.optimizationResultBuilder.recordTopicPartitionMovement(topicPartitionMovement);
            });
            return potentialDestinationBroker;
        }
        return null;
    }

    private boolean isSuspended(TopicPartition tp, OptimizationOptions optimizationOptions) {
        return optimizationOptions.goalOptimizationHistoryOptions().map(goalOptimizationHistoryOptions -> goalOptimizationHistoryOptions.suspendedTopicPartitions().contains(tp)).orElse(false);
    }

    protected ActionAcceptance tryAcceptProposal(Set<Goal> optimizedGoals, BalancingAction proposal, ClusterModel clusterModel, Optional<DetailedProposal> detailedProposalOptional) {
        this.proposalStatsBuilder.trackProposalGenerated();
        AcceptanceResult acceptanceResult = AnalyzerUtils.isProposalAcceptableForOptimizedGoals(optimizedGoals, proposal, clusterModel);
        if (acceptanceResult.acceptance() == ActionAcceptance.ACCEPT) {
            this.proposalStatsBuilder.trackProposalAccepted(proposal.balancingAction(), detailedProposalOptional.map(p -> p.result(true)));
        } else {
            if (acceptanceResult.rejectingGoal().isPresent()) {
                LOG.trace("{} proposal {} was rejected by goal {}", new Object[]{this.name(), proposal, acceptanceResult.rejectingGoal().get()});
            } else {
                LOG.trace("{} proposal {} was rejected", (Object)this.name(), (Object)proposal);
            }
            this.proposalStatsBuilder.trackProposalRejected(acceptanceResult.rejectingGoal(), detailedProposalOptional.map(p -> p.result(false)));
        }
        return acceptanceResult.acceptance();
    }

    private void relocateLeadership(ClusterModel model, TopicPartition tp, int sourceBrokerId, int destinationBrokerId) {
        model.relocateLeadership(tp, sourceBrokerId, destinationBrokerId);
        this.optimizationResultBuilder.recordReplicaChange(this.name());
    }

    private void relocateReplica(ClusterModel model, TopicPartition tp, int sourceBrokerId, String destinationLogDir) {
        model.relocateReplica(tp, sourceBrokerId, destinationLogDir);
        this.optimizationResultBuilder.recordReplicaChange(this.name());
    }

    protected void relocateReplica(ClusterModel model, TopicPartition tp, int sourceBrokerId, int destinationBrokerId) {
        model.relocateReplica(tp, sourceBrokerId, destinationBrokerId);
        this.optimizationResultBuilder.recordReplicaChange(this.name());
    }

    protected void changeObservership(ClusterModel clusterModel, TopicPartition tp, int replicaId) {
        clusterModel.changeObservership(tp, replicaId);
        this.optimizationResultBuilder.recordReplicaChange(this.name());
    }

    protected void updateReplicationFactor(ClusterModel clusterModel, Map<Short, Set<String>> topicsByReplicationFactor, Set<Integer> brokersExcludedForReplicaMovement) throws OptimizationFailureException {
        boolean replicasChanged = clusterModel.updateReplicationFactor(topicsByReplicationFactor, brokersExcludedForReplicaMovement);
        if (replicasChanged) {
            this.optimizationResultBuilder.recordReplicaChange(this.name());
        }
    }

    Replica maybeApplySwapAction(ClusterModel clusterModel, Replica sourceReplica, CandidateBroker cb, Set<Goal> optimizedGoals, Optional<DetailedProposal.Builder> detailedProposalOptional) {
        SortedSet<Replica> eligibleReplicas = GoalUtils.eligibleReplicasForSwap(clusterModel, sourceReplica, cb);
        if (eligibleReplicas.isEmpty()) {
            return null;
        }
        Broker destinationBroker = eligibleReplicas.first().broker();
        for (Replica destinationReplica : eligibleReplicas) {
            ReplicaBalancingAction swapProposal = new ReplicaBalancingAction(sourceReplica.topicPartition(), sourceReplica.broker().id(), destinationBroker.id(), ActionType.INTER_BROKER_REPLICA_SWAP, destinationReplica.topicPartition());
            if (!GoalUtils.legitMove(sourceReplica, destinationBroker, clusterModel, ActionType.INTER_BROKER_REPLICA_MOVEMENT)) {
                LOG.trace("Swap from source to destination broker is not legit for {}.", (Object)swapProposal);
                return null;
            }
            if (!GoalUtils.legitMove(destinationReplica, sourceReplica.broker(), clusterModel, ActionType.INTER_BROKER_REPLICA_MOVEMENT)) {
                LOG.trace("Swap from destination to source broker is not legit for {}.", (Object)swapProposal);
                continue;
            }
            if (!this.selfSatisfied(clusterModel, swapProposal)) {
                LOG.trace("Unable to self-satisfy swap proposal {}.", (Object)swapProposal);
                return null;
            }
            ActionAcceptance actionAcceptance = this.tryAcceptProposal(optimizedGoals, swapProposal, clusterModel, detailedProposalOptional.map(p -> p.build("Swap between " + sourceReplica + " and " + destinationReplica)));
            LOG.trace("Trying to apply legit and self-satisfied swap {}, actionAcceptance = {}.", (Object)swapProposal, (Object)actionAcceptance);
            if (actionAcceptance == ActionAcceptance.ACCEPT) {
                Broker sourceBroker = sourceReplica.broker();
                this.relocateReplica(clusterModel, sourceReplica.topicPartition(), sourceBroker.id(), destinationBroker.id());
                this.relocateReplica(clusterModel, destinationReplica.topicPartition(), destinationBroker.id(), sourceBroker.id());
                return destinationReplica;
            }
            if (actionAcceptance != ActionAcceptance.BROKER_REJECT) continue;
            return null;
        }
        return null;
    }

    protected Disk maybeMoveReplicaBetweenDisks(ClusterModel clusterModel, Replica replica, Collection<Disk> candidateDisks, Set<Goal> optimizedGoals) {
        for (Disk disk : candidateDisks) {
            ReplicaBalancingAction proposal = new ReplicaBalancingAction(replica.topicPartition(), replica.disk(), disk, ActionType.INTRA_BROKER_REPLICA_MOVEMENT);
            if (!GoalUtils.legitMoveBetweenDisks(replica, disk, ActionType.INTRA_BROKER_REPLICA_MOVEMENT)) {
                LOG.trace("Replica move to disk is not legit for {}.", (Object)proposal);
                continue;
            }
            if (!this.selfSatisfied(clusterModel, proposal)) {
                LOG.trace("Unable to self-satisfy proposal {}.", (Object)proposal);
                continue;
            }
            ActionAcceptance actionAcceptance = this.tryAcceptProposal(optimizedGoals, proposal, clusterModel, Optional.empty());
            LOG.trace("Trying to apply legit and self-satisfied action {}, actionAcceptance = {}", (Object)proposal, (Object)actionAcceptance);
            if (actionAcceptance != ActionAcceptance.ACCEPT) continue;
            this.relocateReplica(clusterModel, replica.topicPartition(), replica.broker().id(), disk.logDir());
            return disk;
        }
        return null;
    }

    Replica maybeSwapReplicaBetweenDisks(ClusterModel clusterModel, Replica sourceReplica, List<Replica> candidateReplicas, Set<Goal> optimizedGoals, Set<String> excludedTopics) {
        for (Replica destinationReplica : candidateReplicas) {
            if (excludedTopics.contains(destinationReplica.topicPartition().topic())) continue;
            ReplicaBalancingAction swapProposal = new ReplicaBalancingAction(sourceReplica.topicPartition(), sourceReplica.disk(), destinationReplica.disk(), ActionType.INTRA_BROKER_REPLICA_SWAP, destinationReplica.topicPartition());
            if (!GoalUtils.legitMoveBetweenDisks(sourceReplica, destinationReplica.disk(), ActionType.INTRA_BROKER_REPLICA_MOVEMENT)) {
                LOG.trace("Swap from source to destination disk is not legit for {}.", (Object)swapProposal);
                return null;
            }
            if (!GoalUtils.legitMoveBetweenDisks(destinationReplica, sourceReplica.disk(), ActionType.INTRA_BROKER_REPLICA_MOVEMENT)) {
                LOG.trace("Swap from destination to source disk is not legit for {}.", (Object)swapProposal);
                continue;
            }
            if (!this.selfSatisfied(clusterModel, swapProposal)) {
                LOG.trace("Unable to self-satisfy swap proposal {}.", (Object)swapProposal);
                return null;
            }
            ActionAcceptance actionAcceptance = this.tryAcceptProposal(optimizedGoals, swapProposal, clusterModel, Optional.empty());
            LOG.trace("Trying to apply legit and self-satisfied swap {}, actionAcceptance = {}.", (Object)swapProposal, (Object)actionAcceptance);
            if (actionAcceptance != ActionAcceptance.ACCEPT) continue;
            this.relocateReplica(clusterModel, sourceReplica.topicPartition(), sourceReplica.broker().id(), destinationReplica.disk().logDir());
            this.relocateReplica(clusterModel, destinationReplica.topicPartition(), destinationReplica.broker().id(), sourceReplica.disk().logDir());
            return destinationReplica;
        }
        return null;
    }

    protected boolean shouldTryLeadershipMovement(Resource resource) {
        return this.shouldTryLeadershipMovement(Collections.singletonList(resource));
    }

    protected boolean shouldTryLeadershipMovement(List<Resource> resources) {
        return Resource.LEADER_INFLUENCED_RESOURCES.containsAll(resources);
    }

    protected ProposalObservabilityTrackingOptions proposalTrackingOptions() {
        return ProposalObservabilityTrackingOptions.DISABLED;
    }

    public String toString() {
        return this.name();
    }
}

