/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals;

import com.linkedin.kafka.cruisecontrol.analyzer.ActionAcceptance;
import com.linkedin.kafka.cruisecontrol.analyzer.ActionType;
import com.linkedin.kafka.cruisecontrol.analyzer.AnalyzerUtils;
import com.linkedin.kafka.cruisecontrol.analyzer.BalancingConstraint;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.PartitionBalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.ReplicaBalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.AbstractGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.Goal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.GoalUtils;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.ReplicaDistributionAbstractGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.metrics.OptimizationMetrics;
import com.linkedin.kafka.cruisecontrol.common.Statistic;
import com.linkedin.kafka.cruisecontrol.exception.OptimizationFailureException;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.ClusterModelStats;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import com.linkedin.kafka.cruisecontrol.model.util.ClusterModelStatsComparator;
import com.linkedin.kafka.cruisecontrol.monitor.ModelCompletenessRequirements;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicReplicaDistributionGoal
extends AbstractGoal {
    private static final Logger LOG = LoggerFactory.getLogger(TopicReplicaDistributionGoal.class);
    private boolean fixOfflineReplicasOnly = false;
    private Set<String> topicsToRebalance = new HashSet<String>();
    private final Map<String, Integer> leadersPerBrokerForTopicUpperLimit = new HashMap<String, Integer>();
    private final Map<String, Integer> leadersPerBrokerForTopicLowerLimit = new HashMap<String, Integer>();
    private final Map<String, Integer> followersPerBrokerForTopicUpperLimit = new HashMap<String, Integer>();
    private final Map<String, Integer> followersPerBrokerForTopicLowerLimit = new HashMap<String, Integer>();

    public TopicReplicaDistributionGoal() {
    }

    public TopicReplicaDistributionGoal(BalancingConstraint balancingConstraint) {
        this();
        this.balancingConstraint = balancingConstraint;
    }

    double balancePercentage(OptimizationOptions optimizationOptions) {
        return optimizationOptions.isTriggeredByGoalViolation() ? this.balancingConstraint.topicBalancingBalanceThresholdMultiplier() * this.balancingConstraint.topicBalancingTriggeringThresholdMultiplier() : this.balancingConstraint.topicBalancingBalanceThresholdMultiplier();
    }

    int balanceUpperLimit(Double avgReplicaDistribution, OptimizationOptions optimizationOpts) {
        return (int)Math.ceil(avgReplicaDistribution * this.balancePercentage(optimizationOpts));
    }

    int balanceLowerLimit(Double avgReplicaDistribution, OptimizationOptions optimizationOpts) {
        return (int)Math.max(0.0, Math.floor(avgReplicaDistribution - (avgReplicaDistribution * this.balancePercentage(optimizationOpts) - avgReplicaDistribution)));
    }

    @Override
    public ActionAcceptance replicaActionAcceptance(ReplicaBalancingAction action, ClusterModel clusterModel) {
        Broker sourceBroker = clusterModel.broker(action.sourceBrokerId());
        Broker destinationBroker = clusterModel.broker(action.destinationBrokerId());
        String sourceTopic = action.topic();
        Replica sourceReplica = sourceBroker.replicasOfTopicInBroker(sourceTopic).stream().filter(r -> r.topicPartition().equals((Object)action.topicPartition())).findFirst().orElseThrow(() -> new IllegalStateException("Failed to find the replica that's being moved."));
        switch (action.balancingAction()) {
            case INTER_BROKER_REPLICA_MOVEMENT: {
                return this.isReplicaCountUnderBalanceUpperLimitAfterChange(sourceTopic, sourceReplica, destinationBroker, ReplicaDistributionAbstractGoal.ChangeType.ADD) && this.isReplicaCountAboveBalanceLowerLimitAfterChange(sourceTopic, sourceReplica, sourceBroker, ReplicaDistributionAbstractGoal.ChangeType.REMOVE) ? ActionAcceptance.ACCEPT : ActionAcceptance.REPLICA_REJECT;
            }
            case LEADERSHIP_MOVEMENT: {
                return ActionAcceptance.ACCEPT;
            }
            case INTER_BROKER_REPLICA_SWAP: {
                return ActionAcceptance.REPLICA_REJECT;
            }
        }
        throw new IllegalArgumentException("Unsupported balancing action " + (Object)((Object)action.balancingAction()) + " is provided.");
    }

    @Override
    public ActionAcceptance partitionActionAcceptance(PartitionBalancingAction action, ClusterModel clusterModel) {
        return ActionAcceptance.REPLICA_REJECT;
    }

    private boolean isReplicaCountUnderBalanceUpperLimitAfterChange(String topic, Replica replica, Broker broker, ReplicaDistributionAbstractGoal.ChangeType changeType) {
        int brokerFollowerBalanceUpperLimit;
        if (broker.strategy() == Broker.Strategy.IGNORE) {
            throw new IllegalArgumentException("isReplicaCountUnderBalanceUpperLimitAfterChange doesn't accept ignored broker as input.");
        }
        int numTopicLeaders = broker.numLeaderReplicasOfTopicInBroker(topic);
        int numTopicFollowers = broker.numFollowerReplicasOfTopicInBroker(topic);
        int brokerLeaderBalanceUpperLimit = broker.isAlive() ? this.leadersPerBrokerForTopicUpperLimit.get(topic) : 0;
        int n = brokerFollowerBalanceUpperLimit = broker.isAlive() ? this.followersPerBrokerForTopicUpperLimit.get(topic) : 0;
        if (changeType == ReplicaDistributionAbstractGoal.ChangeType.ADD) {
            if (replica.isLeader()) {
                return numTopicLeaders + 1 <= brokerLeaderBalanceUpperLimit;
            }
            return numTopicFollowers + 1 <= brokerFollowerBalanceUpperLimit;
        }
        return true;
    }

    private boolean isReplicaCountAboveBalanceLowerLimitAfterChange(String topic, Replica replica, Broker broker, ReplicaDistributionAbstractGoal.ChangeType changeType) {
        int brokerFollowerBalanceLowerLimit;
        if (broker.strategy() == Broker.Strategy.IGNORE) {
            throw new IllegalArgumentException("isReplicaCountAboveBalanceUpperLimitAfterChange doesn't accept ignored broker as input.");
        }
        int numTopicLeaders = broker.numLeaderReplicasOfTopicInBroker(topic);
        int numTopicFollowers = broker.numFollowerReplicasOfTopicInBroker(topic);
        int brokerLeaderBalanceLowerLimit = broker.isAlive() ? this.leadersPerBrokerForTopicLowerLimit.get(topic) : 0;
        int n = brokerFollowerBalanceLowerLimit = broker.isAlive() ? this.followersPerBrokerForTopicLowerLimit.get(topic) : 0;
        if (changeType == ReplicaDistributionAbstractGoal.ChangeType.REMOVE) {
            if (replica.isLeader()) {
                return numTopicLeaders - 1 >= brokerLeaderBalanceLowerLimit;
            }
            return numTopicFollowers - 1 >= brokerFollowerBalanceLowerLimit;
        }
        return true;
    }

    @Override
    public ClusterModelStatsComparator clusterModelStatsComparator() {
        return new TopicReplicaDistributionGoalStatsComparator();
    }

    @Override
    public ModelCompletenessRequirements clusterModelCompletenessRequirements() {
        return new ModelCompletenessRequirements(1, 0.0, true);
    }

    @Override
    public String name() {
        return TopicReplicaDistributionGoal.class.getSimpleName();
    }

    @Override
    public boolean isHardGoal() {
        return false;
    }

    @Override
    protected SortedSet<Broker> brokersToBalance(ClusterModel clusterModel) {
        return clusterModel.eligibleSourceOrDestinationBrokers();
    }

    private Set<String> topicsToRebalance(ClusterModel clusterModel, Set<String> excludedTopics) {
        HashSet<Object> topicsToRebalance;
        if (!clusterModel.selfHealingEligibleReplicas().isEmpty()) {
            topicsToRebalance = new HashSet();
            for (Replica replica : clusterModel.selfHealingEligibleReplicas()) {
                topicsToRebalance.add(replica.topicPartition().topic());
            }
        } else {
            topicsToRebalance = new HashSet<String>(clusterModel.topics());
            topicsToRebalance.removeAll(excludedTopics);
        }
        if (topicsToRebalance.isEmpty()) {
            LOG.warn("All topics are excluded from {}.", (Object)this.name());
        }
        return topicsToRebalance;
    }

    @Override
    protected void initGoalState(ClusterModel clusterModel, OptimizationOptions optimizationOptions, Optional<OptimizationMetrics> optimizationMetricsOpt) {
        this.fixOfflineReplicasOnly = false;
        this.topicsToRebalance = this.topicsToRebalance(clusterModel, optimizationOptions.excludedTopics());
        int numEligibleDestinationBrokers = clusterModel.eligibleDestinationBrokers().size();
        for (String topic : clusterModel.topics()) {
            int allLeadersForTopic = clusterModel.leaderReplicasForTopic(topic).size();
            int leadersForTopicOnIgnoredBrokers = (int)clusterModel.ignoredBrokers().stream().mapToLong(broker -> broker.leaderReplicasOfTopicInBroker(topic).size()).sum();
            double avgLeaderReplicasPerBrokerForTopic = numEligibleDestinationBrokers > 0 ? (double)(allLeadersForTopic - leadersForTopicOnIgnoredBrokers) / (double)numEligibleDestinationBrokers : 0.0;
            this.leadersPerBrokerForTopicUpperLimit.put(topic, this.balanceUpperLimit(avgLeaderReplicasPerBrokerForTopic, optimizationOptions));
            this.leadersPerBrokerForTopicLowerLimit.put(topic, this.balanceLowerLimit(avgLeaderReplicasPerBrokerForTopic, optimizationOptions));
            int allFollowersForTopic = clusterModel.followerReplicasForTopic(topic).size();
            int followersForTopicOnIgnoredBrokers = (int)clusterModel.ignoredBrokers().stream().mapToLong(broker -> broker.followerReplicasOfTopicInBroker(topic).size()).sum();
            double avgFollowerReplicasPerBrokerForTopic = numEligibleDestinationBrokers > 0 ? (double)(allFollowersForTopic - followersForTopicOnIgnoredBrokers) / (double)numEligibleDestinationBrokers : 0.0;
            this.followersPerBrokerForTopicUpperLimit.put(topic, this.balanceUpperLimit(avgFollowerReplicasPerBrokerForTopic, optimizationOptions));
            this.followersPerBrokerForTopicLowerLimit.put(topic, this.balanceLowerLimit(avgFollowerReplicasPerBrokerForTopic, optimizationOptions));
        }
        LOG.debug("Leader limits for topics: (Upper: {}, Lower: {})", this.leadersPerBrokerForTopicUpperLimit, this.leadersPerBrokerForTopicLowerLimit);
        LOG.debug("Follower limits for topics: (Upper: {}, Lower: {})", this.followersPerBrokerForTopicUpperLimit, this.followersPerBrokerForTopicLowerLimit);
        if (LOG.isDebugEnabled()) {
            this.logTopicDistributions(clusterModel, "PRE-BALANCING");
        }
    }

    @Override
    public boolean replicaActionSelfSatisfied(ClusterModel clusterModel, ReplicaBalancingAction action) {
        return true;
    }

    @Override
    public boolean partitionActionSelfSatisfied(ClusterModel clusterModel, PartitionBalancingAction action) {
        return false;
    }

    @Override
    protected void updateGoalState(ClusterModel clusterModel, Set<String> excludedTopics) throws OptimizationFailureException {
        boolean allBrokersMeetAvgPerTopic;
        if (LOG.isDebugEnabled()) {
            this.logTopicDistributions(clusterModel, "POST-BALANCING");
        }
        if (!(allBrokersMeetAvgPerTopic = this.brokersToBalance(clusterModel).stream().filter(Broker::isAlive).allMatch(broker -> this.topicsToRebalance.stream().allMatch(topic -> this.leadersPerBrokerForTopicLowerLimit.get(topic) <= broker.numLeaderReplicasOfTopicInBroker((String)topic) && broker.numLeaderReplicasOfTopicInBroker((String)topic) <= this.leadersPerBrokerForTopicUpperLimit.get(topic) && this.followersPerBrokerForTopicLowerLimit.get(topic) <= broker.numFollowerReplicasOfTopicInBroker((String)topic) && broker.numFollowerReplicasOfTopicInBroker((String)topic) <= this.followersPerBrokerForTopicUpperLimit.get(topic))))) {
            this.optimizationResultBuilder.markUnsuccessfulOptimization();
        }
        try {
            GoalUtils.ensureNoOfflineReplicas(clusterModel, this.name());
        }
        catch (OptimizationFailureException ofe) {
            if (this.fixOfflineReplicasOnly) {
                throw ofe;
            }
            this.fixOfflineReplicasOnly = true;
            LOG.info("Ignoring replica balance limit to move replicas from dead brokers/disks.");
            return;
        }
        GoalUtils.ensureReplicasMoveOffBrokersWithBadDisks(clusterModel, this.name());
        this.finish();
    }

    private void logTopicDistributions(ClusterModel clusterModel, String logPrefix) {
        this.topicsToRebalance.forEach(topic -> {
            Set brokersToBalanceIds = this.brokersToBalance(clusterModel).stream().map(Broker::id).collect(Collectors.toSet());
            LinkedHashMap leaderReplicas = new LinkedHashMap();
            clusterModel.aliveBrokers().forEach(broker -> leaderReplicas.put(broker.id(), broker.leaderReplicasOfTopicInBroker((String)topic).size()));
            Set validLeadersCount = leaderReplicas.entrySet().stream().filter(leadersEntry -> brokersToBalanceIds.contains(leadersEntry.getKey())).map(Map.Entry::getValue).collect(Collectors.toSet());
            int maxLeaders = (Integer)validLeadersCount.stream().max(Integer::compareTo).get();
            int minLeaders = (Integer)validLeadersCount.stream().min(Integer::compareTo).get();
            LinkedHashMap followerReplicas = new LinkedHashMap();
            clusterModel.aliveBrokers().forEach(broker -> followerReplicas.put(broker.id(), broker.followerReplicasOfTopicInBroker((String)topic).size()));
            Set validFollowersCount = followerReplicas.entrySet().stream().filter(followersEntry -> brokersToBalanceIds.contains(followersEntry.getKey())).map(Map.Entry::getValue).collect(Collectors.toSet());
            int maxFollowers = (Integer)validFollowersCount.stream().max(Integer::compareTo).get();
            int minFollowers = (Integer)validFollowersCount.stream().min(Integer::compareTo).get();
            LOG.debug("{}> Distributions for topic '{}': \nLeader difference: {}; \nFollower difference: {}; \nLeader: \n({}); \nFollower: \n({})", new Object[]{logPrefix, topic, maxLeaders - minLeaders, maxFollowers - minFollowers, leaderReplicas.entrySet().stream().map(e -> String.format("{\"%d\": %d}", e.getKey(), e.getValue())).collect(Collectors.joining(", \n")), followerReplicas.entrySet().stream().map(e -> String.format("{\"%d\": %d}", e.getKey(), e.getValue())).collect(Collectors.joining(", \n"))});
            if (minLeaders < this.leadersPerBrokerForTopicLowerLimit.get(topic) || maxLeaders > this.leadersPerBrokerForTopicUpperLimit.get(topic) || minFollowers < this.followersPerBrokerForTopicLowerLimit.get(topic) || maxFollowers > this.followersPerBrokerForTopicUpperLimit.get(topic)) {
                LOG.debug("Topic {} is imbalanced, it has leaders count [{}, {}] for leader bounds [{}, {}], and followers count [{}, {}] for follower bounds [{}, {}]", new Object[]{topic, minLeaders, maxLeaders, this.leadersPerBrokerForTopicLowerLimit.get(topic), this.leadersPerBrokerForTopicUpperLimit.get(topic), minFollowers, maxFollowers, this.followersPerBrokerForTopicLowerLimit.get(topic), this.followersPerBrokerForTopicUpperLimit.get(topic)});
            }
        });
    }

    @Override
    public void finish() {
        this.finished = true;
    }

    private static boolean skipBrokerRebalance(Broker broker, ClusterModel clusterModel, Collection<Replica> replicas, boolean requireLessReplicas, boolean requireMoreReplicas, boolean hasOfflineTopicReplicas) {
        if (broker.strategy() == Broker.Strategy.IGNORE) {
            throw new IllegalArgumentException("skipBrokerRebalance doesn't accept ignored broker as input.");
        }
        boolean hasImmigrantTopicReplicas = replicas.stream().anyMatch(replica -> broker.immigrantReplicas().contains(replica));
        if (broker.isAlive() && !requireMoreReplicas && !requireLessReplicas) {
            LOG.trace("Skip rebalance: Broker {} is already within the limit for replicas {}.", (Object)broker, replicas);
            return true;
        }
        if (!(clusterModel.newBrokers().isEmpty() || broker.isNew() || requireLessReplicas)) {
            LOG.trace("Skip rebalance: Cluster has new brokers and this broker {} is not new, but does not require less load for replicas {}. Hence, it does not have any offline replicas.", (Object)broker, replicas);
            return true;
        }
        if (!clusterModel.selfHealingEligibleReplicas().isEmpty() && requireLessReplicas && !hasOfflineTopicReplicas && !hasImmigrantTopicReplicas) {
            LOG.trace("Skip rebalance: Cluster is in self-healing mode and the broker {} requires less load, but none of its current offline or immigrant replicas are from the topic being balanced {}.", (Object)broker, replicas);
            return true;
        }
        return false;
    }

    private static Set<Replica> retainCurrentOfflineBrokerReplicas(Broker broker, Collection<Replica> replicas) {
        HashSet<Replica> offlineReplicas = new HashSet<Replica>(replicas);
        offlineReplicas.retainAll(broker.currentOfflineReplicas());
        return offlineReplicas;
    }

    @Override
    protected void rebalanceForBroker(Broker broker, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOpts) {
        LOG.debug("Rebalancing broker {}", (Object)broker.id());
        if (this.fixOfflineReplicasOnly) {
            LOG.debug("Fixing only offline replicas for each topic for broker {}...", (Object)broker.id());
            if (broker.currentOfflineReplicas().isEmpty()) {
                LOG.debug("Skip fixing offline replicas for broker {} since it has none...", (Object)broker.id());
                return;
            }
            this.sanityCheckDeadBroker(broker);
            for (String topic : broker.topics()) {
                this.rebalanceOfflineAndImmigrantReplicas(broker, clusterModel, optimizedGoals, optimizationOpts, topic);
            }
            return;
        }
        boolean clusterHasOfflineReplicas = !clusterModel.selfHealingEligibleReplicas().isEmpty();
        for (String topic : clusterModel.topics()) {
            if (!this.topicsToRebalance.contains(topic)) continue;
            this.rebalanceLeaderReplicaDistribution(broker, clusterModel, optimizedGoals, optimizationOpts, topic, clusterHasOfflineReplicas);
            this.rebalanceFollowerReplicaDistribution(broker, clusterModel, optimizedGoals, optimizationOpts, topic, clusterHasOfflineReplicas);
        }
    }

    private void sanityCheckDeadBroker(Broker broker) {
        if (broker.isAlive()) {
            throw new IllegalStateException(String.format("Broker %s is expected to be dead", broker));
        }
    }

    private void rebalanceOfflineAndImmigrantReplicas(Broker broker, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOpts, String topic) {
        this.rebalanceByOfflineAndImmigrantReplicasOut(broker, clusterModel, optimizedGoals, optimizationOpts, topic);
    }

    private void rebalanceByOfflineAndImmigrantReplicasOut(Broker broker, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOpts, String topic) {
        TreeSet<Broker> destinationBrokersForLeaders = new TreeSet<Broker>(Comparator.comparing(b -> b.numLeaderReplicasOfTopicInBroker(topic)).thenComparingInt(b -> b.numReplicasOfTopicInBroker(topic)).thenComparingInt(Broker::numReplicas).thenComparingInt(Broker::id));
        TreeSet<Broker> destinationBrokersForFollowers = new TreeSet<Broker>(Comparator.comparing(b -> b.numFollowerReplicasOfTopicInBroker(topic)).thenComparingInt(b -> b.numReplicasOfTopicInBroker(topic)).thenComparingInt(Broker::numReplicas).thenComparingInt(Broker::id));
        clusterModel.eligibleDestinationBrokers().forEach(b -> {
            destinationBrokersForLeaders.add((Broker)b);
            destinationBrokersForFollowers.add((Broker)b);
        });
        Collection offlineReplicasToMoveOut = Stream.concat(broker.currentOfflineReplicas().stream(), broker.immigrantReplicas().stream()).collect(Collectors.toSet());
        for (Replica replica : offlineReplicasToMoveOut) {
            TreeSet<Broker> destinationBrokers = replica.isLeader() ? destinationBrokersForLeaders : destinationBrokersForFollowers;
            LOG.debug("Trying to move offline replica {} from broker {} to one of brokers {}", new Object[]{replica, broker, destinationBrokers});
            Broker newHostBroker = this.maybeApplyBalancingAction(clusterModel, replica, destinationBrokers, ActionType.INTER_BROKER_REPLICA_MOVEMENT, optimizedGoals, optimizationOpts, Optional.empty());
            boolean movementSuccessful = newHostBroker != null;
            if (!movementSuccessful) continue;
            LOG.debug("Successfully moved offline replica {} from broker {} to broker {}", new Object[]{replica, broker, newHostBroker});
            destinationBrokers.removeIf(b -> b.equals(newHostBroker));
            destinationBrokers.add(newHostBroker);
        }
    }

    private void rebalanceFollowerReplicaDistribution(Broker broker, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOpts, String topic, boolean clusterHasOfflineReplicas) {
        boolean requireMoreFollowers;
        LOG.debug("Rebalancing follower replica distribution for broker {} for topic '{}'", (Object)broker, (Object)topic);
        Collection<Replica> followerReplicas = broker.followerReplicasOfTopicInBroker(topic);
        int numTopicFollowerReplicas = followerReplicas.size();
        boolean brokerHasOfflineReplicas = !broker.currentOfflineReplicas().isEmpty();
        boolean hasMoreFollowersForTopic = numTopicFollowerReplicas > this.followersPerBrokerForTopicUpperLimit.get(topic);
        boolean hasLessFollowersForTopic = numTopicFollowerReplicas < this.followersPerBrokerForTopicLowerLimit.get(topic);
        boolean requireLessFollowers = broker.isEligibleSource() && (hasMoreFollowersForTopic || brokerHasOfflineReplicas);
        boolean bl = requireMoreFollowers = broker.isEligibleDestination() && hasLessFollowersForTopic && broker.currentOfflineReplicas().isEmpty();
        if (TopicReplicaDistributionGoal.skipBrokerRebalance(broker, clusterModel, followerReplicas, requireLessFollowers, requireMoreFollowers, brokerHasOfflineReplicas)) {
            return;
        }
        if (requireLessFollowers) {
            this.rebalanceByMovingFollowerReplicasOut(broker, topic, clusterModel, optimizedGoals, optimizationOpts, clusterHasOfflineReplicas);
        }
        if (requireMoreFollowers) {
            this.rebalanceByMovingFollowerReplicasIn(broker, topic, clusterModel, optimizedGoals, optimizationOpts);
        }
    }

    void rebalanceByMovingFollowerReplicasOut(Broker broker, String topic, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions, boolean handleOnlyOfflineAndImmigrantReplicas) {
        TreeSet<Broker> destinationBrokers = new TreeSet<Broker>(Comparator.comparingInt(b -> b.numFollowerReplicasOfTopicInBroker(topic)).thenComparingInt(b -> b.numReplicasOfTopicInBroker(topic)).thenComparingInt(Broker::numReplicas).thenComparingInt(Broker::id));
        clusterModel.eligibleDestinationBrokers().stream().filter(b -> b.numFollowerReplicasOfTopicInBroker(topic) < this.followersPerBrokerForTopicUpperLimit.get(topic)).collect(Collectors.toCollection(() -> destinationBrokers));
        Collection followerReplicasOfTopicInBroker = broker.followerReplicasOfTopicInBroker(topic).stream().filter(r -> handleOnlyOfflineAndImmigrantReplicas ? r.isCurrentOffline() || r.isImmigrant() : true).collect(Collectors.toSet());
        int followerReplicasOfTopicInBrokerCount = followerReplicasOfTopicInBroker.size();
        for (Replica replica : followerReplicasOfTopicInBroker) {
            boolean metTopicUpperBound;
            LOG.debug("Trying to move follower replica {} for topic '{}' from broker {} to one of brokers {}", new Object[]{replica, topic, broker, destinationBrokers});
            Broker newHostBroker = this.maybeApplyBalancingAction(clusterModel, replica, destinationBrokers, ActionType.INTER_BROKER_REPLICA_MOVEMENT, optimizedGoals, optimizationOptions, Optional.empty());
            boolean movementSuccessful = newHostBroker != null;
            if (!movementSuccessful) continue;
            LOG.debug("Successfully moved follower replica {} from broker {} to broker {}", new Object[]{replica, broker, newHostBroker});
            boolean bl = metTopicUpperBound = --followerReplicasOfTopicInBrokerCount <= this.followersPerBrokerForTopicUpperLimit.get(topic);
            if (metTopicUpperBound && broker.currentOfflineReplicas().isEmpty()) {
                LOG.debug("Broker {} successfully met the followers upper bound for topic {}", (Object)broker, (Object)topic);
                return;
            }
            destinationBrokers.removeIf(b -> b.equals(newHostBroker));
            boolean candidateCanTakeMoreTopicReplicas = newHostBroker.numFollowerReplicasOfTopicInBroker(topic) < this.followersPerBrokerForTopicUpperLimit.get(topic);
            if (!candidateCanTakeMoreTopicReplicas) continue;
            destinationBrokers.add(newHostBroker);
        }
    }

    void rebalanceByMovingFollowerReplicasIn(Broker broker, String topic, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) {
        PriorityQueue<Broker> sourceBrokers = new PriorityQueue<Broker>(Comparator.comparingInt(b -> b.numFollowerReplicasOfTopicInBroker(topic)).thenComparingInt(b -> b.numReplicasOfTopicInBroker(topic)).thenComparingInt(Broker::numReplicas).thenComparingInt(Broker::id).reversed());
        clusterModel.eligibleSourceBrokers().stream().filter(b -> b.numFollowerReplicasOfTopicInBroker(topic) > this.followersPerBrokerForTopicLowerLimit.get(topic)).collect(Collectors.toCollection(() -> sourceBrokers));
        Collection<Replica> followerReplicasOfTopicInBroker = broker.followerReplicasOfTopicInBroker(topic);
        int numFollowerReplicasOfTopicInBroker = followerReplicasOfTopicInBroker.size();
        Set<Broker> candidateBrokers = Collections.singleton(broker);
        block0: while (!sourceBrokers.isEmpty()) {
            Broker sourceBroker = sourceBrokers.poll();
            Collection<Replica> sourceBrokerReplicasForTopic = sourceBroker.followerReplicasOfTopicInBroker(topic);
            for (Replica replica : sourceBrokerReplicasForTopic) {
                boolean metTopicLowerBound;
                LOG.debug("Trying to move follower replica {} for topic '{}' from broker {} to one of brokers {}", new Object[]{replica, topic, sourceBroker, candidateBrokers});
                Broker newHostBroker = this.maybeApplyBalancingAction(clusterModel, replica, candidateBrokers, ActionType.INTER_BROKER_REPLICA_MOVEMENT, optimizedGoals, optimizationOptions, Optional.empty());
                boolean movementSuccessful = newHostBroker != null;
                if (!movementSuccessful) continue;
                LOG.debug("Successfully moved follower replica {} from broker {} to broker {}", new Object[]{replica, sourceBroker, newHostBroker});
                boolean bl = metTopicLowerBound = ++numFollowerReplicasOfTopicInBroker >= this.followersPerBrokerForTopicLowerLimit.get(topic);
                if (metTopicLowerBound) {
                    LOG.debug("Broker {} successfully met the followers lower bound for topic {}", (Object)broker, (Object)topic);
                    return;
                }
                if (sourceBroker.numFollowerReplicasOfTopicInBroker(topic) <= this.followersPerBrokerForTopicLowerLimit.get(topic)) continue block0;
                boolean sourceShouldBeReplaced = !sourceBrokers.isEmpty() && sourceBroker.numFollowerReplicasOfTopicInBroker(topic) < sourceBrokers.peek().numFollowerReplicasOfTopicInBroker(topic);
                if (!sourceShouldBeReplaced) continue;
                sourceBrokers.add(sourceBroker);
                continue block0;
            }
        }
    }

    private void rebalanceLeaderReplicaDistribution(Broker broker, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOpts, String topic, boolean clusterHasOfflineReplicas) {
        boolean requireMoreLeaders;
        LOG.debug("Rebalancing leader replica distribution for broker {} for topic '{}'", (Object)broker, (Object)topic);
        Collection<Replica> topicLeaderReplicas = broker.leaderReplicasOfTopicInBroker(topic);
        boolean brokerHasOfflineReplicas = !broker.currentOfflineReplicas().isEmpty();
        boolean hasMoreLeadersForTopic = topicLeaderReplicas.size() > this.leadersPerBrokerForTopicUpperLimit.get(topic);
        boolean hasLessLeadersForTopic = topicLeaderReplicas.size() < this.leadersPerBrokerForTopicLowerLimit.get(topic);
        boolean requireLessLeaders = broker.isEligibleSource() && (hasMoreLeadersForTopic || brokerHasOfflineReplicas);
        boolean bl = requireMoreLeaders = broker.isEligibleDestination() && hasLessLeadersForTopic && broker.currentOfflineReplicas().isEmpty();
        if (TopicReplicaDistributionGoal.skipBrokerRebalance(broker, clusterModel, topicLeaderReplicas, requireLessLeaders, requireMoreLeaders, brokerHasOfflineReplicas)) {
            return;
        }
        if (requireLessLeaders) {
            this.rebalanceByMovingLeaderReplicasOut(broker, topic, clusterModel, optimizedGoals, optimizationOpts, clusterHasOfflineReplicas);
        }
        if (requireMoreLeaders) {
            this.rebalanceByMovingLeaderReplicasIn(broker, topic, clusterModel, optimizedGoals, optimizationOpts);
        }
    }

    void rebalanceByMovingLeaderReplicasOut(Broker broker, String topic, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions, boolean handleOnlyOfflineAndImmigrantReplicas) {
        TreeSet<Broker> destinationBrokers = new TreeSet<Broker>(Comparator.comparingInt(b -> b.numLeaderReplicasOfTopicInBroker(topic)).thenComparingInt(b -> b.numReplicasOfTopicInBroker(topic)).thenComparingInt(Broker::numLeaderReplicas).thenComparingInt(Broker::numReplicas).thenComparingInt(Broker::id));
        clusterModel.eligibleDestinationBrokers().stream().filter(b -> b.numLeaderReplicasOfTopicInBroker(topic) < this.leadersPerBrokerForTopicUpperLimit.get(topic)).collect(Collectors.toCollection(() -> destinationBrokers));
        Collection replicasToMove = broker.leaderReplicasOfTopicInBroker(topic).stream().filter(r -> handleOnlyOfflineAndImmigrantReplicas ? r.isCurrentOffline() || r.isImmigrant() : true).collect(Collectors.toList());
        int numLeaderReplicasInBroker = replicasToMove.size();
        for (Replica replica : replicasToMove) {
            boolean metTopicLeadersUpperBound;
            boolean movementSuccessful;
            LOG.debug("Trying to move leader replica {} for topic '{}' from broker {} to one of brokers {}", new Object[]{replica, topic, broker, destinationBrokers});
            Broker newHostBroker = this.maybeApplyBalancingActions(clusterModel, replica, destinationBrokers, Arrays.asList(ActionType.INTER_BROKER_REPLICA_MOVEMENT, ActionType.LEADERSHIP_MOVEMENT), optimizedGoals, optimizationOptions, Optional.empty());
            boolean bl = movementSuccessful = newHostBroker != null;
            if (!movementSuccessful) continue;
            LOG.debug("Successfully moved leader replica {} for topic {} from broker {} to broker {}", new Object[]{replica, topic, broker, newHostBroker});
            boolean bl2 = metTopicLeadersUpperBound = --numLeaderReplicasInBroker <= this.leadersPerBrokerForTopicUpperLimit.get(topic);
            if (metTopicLeadersUpperBound && broker.currentOfflineReplicas().isEmpty()) {
                LOG.debug("Broker {} successfully met the leaders upper bound for topic {}", (Object)broker, (Object)topic);
                return;
            }
            destinationBrokers.removeIf(b -> b.equals(newHostBroker));
            boolean candidateCanTakeMoreTopicLeaderReplicas = newHostBroker.numLeaderReplicasOfTopicInBroker(topic) < this.leadersPerBrokerForTopicUpperLimit.get(topic);
            if (!candidateCanTakeMoreTopicLeaderReplicas) continue;
            destinationBrokers.add(newHostBroker);
        }
    }

    void rebalanceByMovingLeaderReplicasIn(Broker broker, String topic, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) {
        PriorityQueue<Broker> sourceBrokers = new PriorityQueue<Broker>(Comparator.comparingInt(b -> b.numLeaderReplicasOfTopicInBroker(topic)).thenComparingInt(b -> b.numReplicasOfTopicInBroker(topic)).thenComparingInt(Broker::numLeaderReplicas).thenComparingInt(Broker::numReplicas).thenComparingInt(Broker::id).reversed());
        clusterModel.eligibleSourceBrokers().stream().filter(b -> b.numLeaderReplicasOfTopicInBroker(topic) > this.leadersPerBrokerForTopicLowerLimit.get(topic)).collect(Collectors.toCollection(() -> sourceBrokers));
        int numLeaderReplicasOfTopicInBroker = broker.numLeaderReplicasOfTopicInBroker(topic);
        Set<Broker> candidateBrokers = Collections.singleton(broker);
        block0: while (!sourceBrokers.isEmpty()) {
            Broker sourceBroker = sourceBrokers.poll();
            Collection replicasToMove = sourceBroker.leaderReplicasOfTopicInBroker(topic).stream().filter(replica -> !replica.isCurrentOffline()).collect(Collectors.toList());
            for (Replica replica2 : replicasToMove) {
                boolean metTopicLeaderLowerBound;
                boolean movementSuccessful;
                LOG.debug("Trying to move leader replica {} for topic '{}' from broker {} to one of brokers {}", new Object[]{replica2, topic, sourceBroker, candidateBrokers});
                Broker newHostBroker = this.maybeApplyBalancingActions(clusterModel, replica2, candidateBrokers, Arrays.asList(ActionType.INTER_BROKER_REPLICA_MOVEMENT, ActionType.LEADERSHIP_MOVEMENT), optimizedGoals, optimizationOptions, Optional.empty());
                boolean bl = movementSuccessful = newHostBroker != null;
                if (!movementSuccessful) continue;
                LOG.debug("Successfully moved leader replica {} from broker {} to broker {}", new Object[]{replica2, sourceBroker, newHostBroker});
                boolean bl2 = metTopicLeaderLowerBound = ++numLeaderReplicasOfTopicInBroker >= this.leadersPerBrokerForTopicLowerLimit.get(topic);
                if (metTopicLeaderLowerBound) {
                    LOG.debug("Broker {} successfully met the leaders lower bound for topic {}", (Object)broker, (Object)topic);
                    return;
                }
                if (sourceBroker.numLeaderReplicasOfTopicInBroker(topic) <= this.leadersPerBrokerForTopicLowerLimit.get(topic)) continue block0;
                boolean requeueSourceBroker = !sourceBrokers.isEmpty() && sourceBroker.numLeaderReplicasOfTopicInBroker(topic) < sourceBrokers.peek().numLeaderReplicasOfTopicInBroker(topic);
                if (!requeueSourceBroker) continue;
                sourceBrokers.add(sourceBroker);
                continue block0;
            }
        }
    }

    private class TopicReplicaDistributionGoalStatsComparator
    implements ClusterModelStatsComparator {
        private String reasonForLastNegativeResult;

        private TopicReplicaDistributionGoalStatsComparator() {
        }

        @Override
        public int compare(ClusterModelStats stats1, ClusterModelStats stats2) {
            double stdDev1 = stats1.topicReplicaStats().get((Object)Statistic.ST_DEV).doubleValue();
            double stdDev2 = stats2.topicReplicaStats().get((Object)Statistic.ST_DEV).doubleValue();
            int result = AnalyzerUtils.compare(stdDev2, stdDev1, 1.0E-5);
            if (result < 0) {
                this.reasonForLastNegativeResult = String.format("Violated %s. [Std Deviation of Topic Replica Distribution] post-optimization:%.3f pre-optimization:%.3f", TopicReplicaDistributionGoal.this.name(), stdDev1, stdDev2);
            }
            return result;
        }

        @Override
        public String explainLastComparison() {
            return this.reasonForLastNegativeResult;
        }
    }
}

