/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.config;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.config.BrokerCapacityConfigResolver;
import com.linkedin.kafka.cruisecontrol.config.BrokerCapacityInfo;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BrokerCapacityConfigFileResolver
implements BrokerCapacityConfigResolver {
    public static final String CAPACITY_CONFIG_FILE = "capacity.config.file";
    public static final int DEFAULT_CAPACITY_BROKER_ID = -1;
    private static final String NUM_CORES_CONFIG = "num.cores";
    public static final double DEFAULT_CPU_CAPACITY_WITH_CORES = 100.0;
    private static Map<Integer, BrokerCapacityInfo> capacitiesForBrokers;

    @Override
    public void configure(Map<String, ?> configs) {
        String configFile = KafkaCruiseControlUtils.getRequiredConfig(configs, CAPACITY_CONFIG_FILE);
        try {
            this.loadCapacities(configFile);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public BrokerCapacityInfo capacityForBroker(String rack, String host, int brokerId) {
        if (brokerId >= 0) {
            BrokerCapacityInfo capacity = capacitiesForBrokers.get(brokerId);
            if (capacity != null) {
                return capacity;
            }
            String info = String.format("Missing broker id(%d) in capacity config file.", brokerId);
            return BrokerCapacityInfo.builder().capacity(capacitiesForBrokers.get(-1).capacity()).estimationInfo(info).diskCapacityByLogDir(capacitiesForBrokers.get(-1).diskCapacityByLogDir()).numCpuCores(capacitiesForBrokers.get(-1).numCpuCores()).build();
        }
        throw new IllegalArgumentException("The broker id(" + brokerId + ") should be non-negative.");
    }

    private static boolean isJBOD(Map<Resource, Object> brokerCapacity) {
        return brokerCapacity.get((Object)Resource.DISK) instanceof Map;
    }

    private static Short getUserSpecifiedNumCores(Map<Resource, Object> brokerCapacity) {
        if (brokerCapacity.get((Object)Resource.CPU) instanceof Map) {
            String stringNumCores = (String)((Map)brokerCapacity.get((Object)Resource.CPU)).get(NUM_CORES_CONFIG);
            if (stringNumCores == null) {
                throw new IllegalArgumentException("Missing num.cores config for brokers in capacity config file.");
            }
            return Short.parseShort(stringNumCores);
        }
        return null;
    }

    private static Map<Resource, Double> getTotalCapacity(Map<Resource, Object> brokerCapacity, boolean hasNumCores) {
        HashMap<Resource, Double> totalCapacity = new HashMap<Resource, Double>(brokerCapacity.size());
        if (BrokerCapacityConfigFileResolver.isJBOD(brokerCapacity)) {
            for (Map.Entry<Resource, Object> entry : brokerCapacity.entrySet()) {
                Resource resource = entry.getKey();
                if (resource == Resource.DISK) {
                    double totalDiskCapacity = 0.0;
                    for (Map.Entry diskEntry : ((Map)brokerCapacity.get((Object)resource)).entrySet()) {
                        if (!Paths.get((String)diskEntry.getKey(), new String[0]).isAbsolute()) {
                            throw new IllegalArgumentException("The logDir " + (String)diskEntry.getKey() + " must be an absolute path.");
                        }
                        totalDiskCapacity += Double.parseDouble((String)diskEntry.getValue());
                    }
                    totalCapacity.put(resource, totalDiskCapacity);
                    continue;
                }
                if (hasNumCores && resource == Resource.CPU) {
                    totalCapacity.put(resource, 100.0);
                    continue;
                }
                totalCapacity.put(resource, Double.parseDouble((String)entry.getValue()));
            }
        } else {
            brokerCapacity.forEach((key, value) -> totalCapacity.put((Resource)((Object)key), hasNumCores && key == Resource.CPU ? 100.0 : Double.parseDouble((String)value)));
        }
        return totalCapacity;
    }

    private static Map<String, Double> getDiskCapacityByLogDir(Map<Resource, Object> brokerCapacity) {
        if (!BrokerCapacityConfigFileResolver.isJBOD(brokerCapacity)) {
            return BrokerCapacityInfo.EMPTY_DISK_CAPACITY_BY_LOG_DIR;
        }
        Map stringDiskCapacityByLogDir = (Map)brokerCapacity.get((Object)Resource.DISK);
        HashMap<String, Double> diskCapacityByLogDir = new HashMap<String, Double>(stringDiskCapacityByLogDir.size());
        stringDiskCapacityByLogDir.forEach((key, value) -> diskCapacityByLogDir.put((String)key, Double.parseDouble(value)));
        return diskCapacityByLogDir;
    }

    private static void numCoresConfigConsistencyChecker(Set<Boolean> numCoresConfigConsistency) {
        if (numCoresConfigConsistency.size() > 1) {
            throw new IllegalArgumentException("Inconsistent num.cores config for brokers in capacity config file. This config must be provided by either all or non of the brokers.");
        }
    }

    private BrokerCapacityInfo getBrokerCapacityInfo(BrokerCapacity bc, Set<Boolean> numCoresConfigConsistency) {
        Short userSpecifiedNumCores = BrokerCapacityConfigFileResolver.getUserSpecifiedNumCores(bc.capacity);
        boolean hasNumCores = userSpecifiedNumCores != null;
        numCoresConfigConsistency.add(hasNumCores);
        BrokerCapacityConfigFileResolver.numCoresConfigConsistencyChecker(numCoresConfigConsistency);
        boolean isDefault = bc.brokerId == -1;
        Map<Resource, Double> totalCapacity = BrokerCapacityConfigFileResolver.getTotalCapacity(bc.capacity, hasNumCores);
        Map<String, Double> diskCapacityByLogDir = BrokerCapacityConfigFileResolver.getDiskCapacityByLogDir(bc.capacity);
        BrokerCapacityInfo.BrokerCapacityInfoBuilder brokerCapacityInfoBuilder = BrokerCapacityInfo.builder().capacity(totalCapacity).diskCapacityByLogDir(diskCapacityByLogDir);
        if (isDefault) {
            brokerCapacityInfoBuilder = brokerCapacityInfoBuilder.estimationInfo("The default broker capacity.");
        }
        if (hasNumCores) {
            brokerCapacityInfoBuilder = brokerCapacityInfoBuilder.numCpuCores(userSpecifiedNumCores);
        }
        return brokerCapacityInfoBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadCapacities(String configFile) throws FileNotFoundException {
        FileInputStream fileInputStream = new FileInputStream(configFile);
        InputStreamReader streamReader = new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8);
        JsonReader reader = new JsonReader((Reader)streamReader);
        try {
            this.loadCapacities(reader);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected void loadCapacities(JsonReader reader) {
        Gson gson = new Gson();
        Set brokerCapacities = ((BrokerCapacities)gson.fromJson(reader, BrokerCapacities.class)).brokerCapacities;
        capacitiesForBrokers = new HashMap<Integer, BrokerCapacityInfo>(brokerCapacities.size());
        HashSet<Boolean> numCoresConfigConsistency = new HashSet<Boolean>(1);
        for (BrokerCapacity bc : brokerCapacities) {
            capacitiesForBrokers.put(bc.brokerId, this.getBrokerCapacityInfo(bc, numCoresConfigConsistency));
        }
    }

    private static class BrokerCapacity {
        private final int brokerId;
        private final Map<Resource, Object> capacity;

        BrokerCapacity(int brokerId, Map<Resource, Object> capacity) {
            this.brokerId = brokerId;
            this.capacity = capacity;
        }
    }

    private static class BrokerCapacities {
        private Set<BrokerCapacity> brokerCapacities;

        private BrokerCapacities() {
        }
    }
}

