/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.config;

import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.concurrent.Immutable;
import org.apache.kafka.common.errors.BalancerMisconfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class SbcGoalsConfigDelta {
    private static final Logger LOG = LoggerFactory.getLogger(SbcGoalsConfigDelta.class);
    private final List<String> newRebalancingGoals;
    private final List<String> newTriggeringGoals;
    private final Boolean newIncrementalBalancingEnabled;
    private final List<String> newIncrementalBalancingGoals;
    private final Boolean hasUpdate;

    private SbcGoalsConfigDelta(Builder builder) {
        this.newRebalancingGoals = builder.newRebalancingGoals;
        this.newTriggeringGoals = builder.newTriggeringGoals;
        this.newIncrementalBalancingEnabled = builder.newIncrementalBalancingEnabled;
        this.newIncrementalBalancingGoals = builder.newIncrementalBalancingGoals;
        this.hasUpdate = builder.hasUpdate;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> boolean satisfy(T config, Predicate<T> predicate) {
        return config != null && predicate.test(config);
    }

    public boolean hasUpdate() {
        return this.hasUpdate;
    }

    public String toString() {
        ArrayList<String> representation = new ArrayList<String>();
        if (this.newRebalancingGoals != null) {
            representation.add("newRebalancingGoals=" + this.newRebalancingGoals);
        }
        if (this.newTriggeringGoals != null) {
            representation.add("newTriggeringGoals=" + this.newTriggeringGoals);
        }
        if (this.newIncrementalBalancingEnabled != null) {
            representation.add("newIncrementalBalancingEnabled=" + this.newIncrementalBalancingEnabled);
        }
        if (this.newIncrementalBalancingGoals != null) {
            representation.add("newIncrementalBalancingGoals=" + this.newIncrementalBalancingGoals);
        }
        return "{" + String.join((CharSequence)", ", representation) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SbcGoalsConfigDelta that = (SbcGoalsConfigDelta)o;
        return Objects.equals(this.newRebalancingGoals, that.newRebalancingGoals) && Objects.equals(this.newTriggeringGoals, that.newTriggeringGoals) && Objects.equals(this.newIncrementalBalancingEnabled, that.newIncrementalBalancingEnabled) && Objects.equals(this.newIncrementalBalancingGoals, that.newIncrementalBalancingGoals) && Objects.equals(this.hasUpdate, that.hasUpdate);
    }

    public int hashCode() {
        return Objects.hash(this.newRebalancingGoals, this.newTriggeringGoals, this.newIncrementalBalancingEnabled, this.newIncrementalBalancingGoals, this.hasUpdate);
    }

    public KafkaCruiseControlConfig apply(KafkaCruiseControlConfig oldConfig) {
        HashMap<String, Object> newConfigs = new HashMap<String, Object>();
        if (SbcGoalsConfigDelta.satisfy(this.newRebalancingGoals, l -> !l.isEmpty()) && SbcGoalsConfigDelta.satisfy(this.newTriggeringGoals, l -> !l.isEmpty())) {
            newConfigs.put("goals", this.newRebalancingGoals);
            newConfigs.put("anomaly.detection.goals", this.newTriggeringGoals);
        } else {
            LOG.warn("Changes to rebalancing and triggering goals are not applied since new rebalancing goals ({}) or new triggering goals ({}) are not defined.", this.newRebalancingGoals, this.newTriggeringGoals);
        }
        if (this.newIncrementalBalancingEnabled != null) {
            newConfigs.put("incremental.balancing.enabled", this.newIncrementalBalancingEnabled);
        }
        if (SbcGoalsConfigDelta.satisfy(this.newIncrementalBalancingGoals, l -> !l.isEmpty())) {
            newConfigs.put("incremental.balancing.goals", this.newIncrementalBalancingGoals);
        }
        HashMap<String, Object> updatedConfig = new HashMap<String, Object>(oldConfig.clone(newConfigs).mergedConfigValues());
        if (SbcGoalsConfigDelta.satisfy(this.newRebalancingGoals, List::isEmpty)) {
            updatedConfig.remove("goals");
        }
        if (SbcGoalsConfigDelta.satisfy(this.newTriggeringGoals, List::isEmpty)) {
            updatedConfig.remove("anomaly.detection.goals");
        }
        if (SbcGoalsConfigDelta.satisfy(this.newIncrementalBalancingGoals, List::isEmpty)) {
            updatedConfig.remove("incremental.balancing.goals");
        }
        return new KafkaCruiseControlConfig(updatedConfig);
    }

    public static class Builder {
        private List<String> newRebalancingGoals = null;
        private List<String> newTriggeringGoals = null;
        private Boolean newIncrementalBalancingEnabled = null;
        private List<String> newIncrementalBalancingGoals = null;
        private boolean hasUpdate = false;

        public Builder newRebalancingGoals(List<String> newRebalancingGoals) {
            Objects.requireNonNull(newRebalancingGoals, "New rebalancing goals cannot be null.");
            this.newRebalancingGoals = newRebalancingGoals;
            this.hasUpdate = true;
            return this;
        }

        public Builder newTriggeringGoals(List<String> newTriggeringGoals) {
            Objects.requireNonNull(newTriggeringGoals, "New triggering goals cannot be null.");
            this.newTriggeringGoals = newTriggeringGoals;
            this.hasUpdate = true;
            return this;
        }

        public Builder newIncrementalBalancingEnabled(Boolean newIncrementalBalancingEnabled) {
            Objects.requireNonNull(newIncrementalBalancingEnabled, "New incremental balancing enabled config cannot be null.");
            this.newIncrementalBalancingEnabled = newIncrementalBalancingEnabled;
            this.hasUpdate = true;
            return this;
        }

        public Builder newIncrementalBalancingGoals(List<String> newIncrementalBalancingGoals) {
            Objects.requireNonNull(newIncrementalBalancingGoals, "New incremental balancing goals cannot be null.");
            this.newIncrementalBalancingGoals = newIncrementalBalancingGoals;
            this.hasUpdate = true;
            return this;
        }

        public SbcGoalsConfigDelta build() {
            if (this.newTriggeringGoals == null ^ this.newRebalancingGoals == null) {
                String errorMessage = String.format("Non-incremental rebalancing goals and triggering goals must be modified together (both non-null) or not modified at all (both null).%nNew rebalancing goals: %s%nNew triggering goals: %s%n", this.newRebalancingGoals, this.newTriggeringGoals);
                throw new BalancerMisconfigurationException(errorMessage);
            }
            if (SbcGoalsConfigDelta.satisfy(this.newTriggeringGoals, List::isEmpty) ^ SbcGoalsConfigDelta.satisfy(this.newRebalancingGoals, List::isEmpty)) {
                String errorMessage = String.format("Non-incremental rebalancing goals and triggering goals must be modified together (both non-empty) or both reverted together (both empty).%nNew rebalancing goals: %s%nNew triggering goals: %s%n", this.newRebalancingGoals, this.newTriggeringGoals);
                throw new BalancerMisconfigurationException(errorMessage);
            }
            return new SbcGoalsConfigDelta(this);
        }
    }
}

