/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector;

import com.linkedin.cruisecontrol.detector.AnomalyFixStatus;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControl;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.PlanComputationOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationResult;
import com.linkedin.kafka.cruisecontrol.config.GoalsConfig;
import com.linkedin.kafka.cruisecontrol.detector.KafkaAnomaly;
import com.linkedin.kafka.cruisecontrol.detector.notifier.AnomalyNotificationResult;
import com.linkedin.kafka.cruisecontrol.detector.notifier.AnomalyNotifier;
import com.linkedin.kafka.cruisecontrol.detector.notifier.AnomalyType;
import java.util.Map;
import java.util.UUID;

public class BrokerFailures
extends KafkaAnomaly {
    private static final String ID_PREFIX = AnomalyType.BROKER_FAILURE.toString();
    private final KafkaCruiseControl kafkaCruiseControl;
    private final Map<Integer, Long> failedBrokers;
    private final GoalsConfig goalConfig;
    private final PlanComputationOptions opts;
    private final String anomalyId;

    public BrokerFailures(KafkaCruiseControl kafkaCruiseControl, Map<Integer, Long> failedBrokers, boolean allowCapacityEstimation, boolean excludeRecentlyRemovedBrokers, GoalsConfig goalConfig) {
        this.kafkaCruiseControl = kafkaCruiseControl;
        this.failedBrokers = failedBrokers;
        this.goalConfig = goalConfig;
        if (this.failedBrokers != null && this.failedBrokers.isEmpty()) {
            throw new IllegalArgumentException("Missing broker ids for failed brokers.");
        }
        this.opts = new PlanComputationOptions(allowCapacityEstimation, excludeRecentlyRemovedBrokers);
        this.anomalyId = String.format("%s-%s", ID_PREFIX, UUID.randomUUID().toString().substring(ID_PREFIX.length() + 1));
        this.optimizationResult = null;
    }

    @Override
    public GoalsConfig goalsConfig() {
        return this.goalConfig;
    }

    public Map<Integer, Long> failedBrokers() {
        return this.failedBrokers;
    }

    @Override
    public String anomalyId() {
        return this.anomalyId;
    }

    @Override
    public AnomalyNotificationResult notifyAnomalyInProgress(AnomalyNotifier anomalyNotifier) {
        return anomalyNotifier.onBrokerFailure(this);
    }

    @Override
    public AnomalyFixStatus fix() throws Exception {
        if (this.failedBrokers != null && !this.failedBrokers.isEmpty()) {
            this.optimizationResult = new OptimizationResult(this.kafkaCruiseControl.fixBrokerFailures(this.failedBrokers.keySet(), this.goalConfig, this.anomalyId, this.opts));
            this.optimizationResult.discardIrrelevantAndCacheText();
            return AnomalyFixStatus.START_SUCCESSFULLY;
        }
        return AnomalyFixStatus.START_FAILED;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder().append("{\n");
        this.failedBrokers.forEach((key, value) -> sb.append("\tBroker ").append(key).append(" failed at ").append(KafkaCruiseControlUtils.toDateString(value)).append("\n"));
        sb.append("}");
        return sb.toString();
    }
}

