/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector.notifier;

import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.detector.BrokerFailures;
import com.linkedin.kafka.cruisecontrol.detector.GoalViolations;
import com.linkedin.kafka.cruisecontrol.detector.notifier.AnomalyNotificationResult;
import com.linkedin.kafka.cruisecontrol.detector.notifier.AnomalyNotifier;
import com.linkedin.kafka.cruisecontrol.detector.notifier.AnomalyType;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelfHealingNotifier
implements AnomalyNotifier {
    private static final Logger LOG = LoggerFactory.getLogger(SelfHealingNotifier.class);
    protected final Time time;
    protected final long notifierStartTimeMs;
    protected final Map<AnomalyType, Boolean> selfHealingEnabled;
    protected final Map<Boolean, Map<AnomalyType, Long>> selfHealingStateChangeTimeMs;
    protected final Map<AnomalyType, Long> selfHealingEnabledHistoricalDurationMs;
    protected long brokerFailureAlertThresholdMs;
    protected long selfHealingThresholdMs;

    public SelfHealingNotifier() {
        this((Time)new SystemTime());
    }

    SelfHealingNotifier(Time time) {
        this.time = time;
        this.notifierStartTimeMs = this.time.milliseconds();
        int numAnomalyTypes = AnomalyType.cachedValues().size();
        this.selfHealingEnabled = new ConcurrentHashMap<AnomalyType, Boolean>(numAnomalyTypes);
        this.selfHealingStateChangeTimeMs = new HashMap<Boolean, Map<AnomalyType, Long>>(2);
        this.selfHealingStateChangeTimeMs.put(true, new HashMap(numAnomalyTypes));
        this.selfHealingStateChangeTimeMs.put(false, new HashMap(numAnomalyTypes));
        this.selfHealingEnabledHistoricalDurationMs = new HashMap<AnomalyType, Long>(numAnomalyTypes);
        AnomalyType.cachedValues().forEach(anomalyType -> this.selfHealingEnabledHistoricalDurationMs.put((AnomalyType)((Object)anomalyType), 0L));
    }

    @Override
    public AnomalyNotificationResult onGoalViolation(GoalViolations goalViolations) {
        boolean autoFixTriggered = this.selfHealingEnabled.get((Object)AnomalyType.GOAL_VIOLATION);
        boolean selfHealingTriggered = autoFixTriggered && !goalViolations.hasUnfixableGoals();
        this.alert(goalViolations, selfHealingTriggered, System.currentTimeMillis(), AnomalyType.GOAL_VIOLATION);
        if (autoFixTriggered) {
            if (selfHealingTriggered) {
                return AnomalyNotificationResult.fix();
            }
            LOG.warn("Skip self healing for anomaly {} due to unfixable goals: {}", (Object)AnomalyType.GOAL_VIOLATION, goalViolations.violatedGoalsByFixability().get(false));
        }
        return AnomalyNotificationResult.ignore();
    }

    @Override
    public Map<AnomalyType, Boolean> selfHealingEnabled() {
        return this.selfHealingEnabled;
    }

    @Override
    public synchronized boolean setSelfHealingFor(AnomalyType anomalyType, boolean isSelfHealingEnabled) {
        Boolean oldValue = this.selfHealingEnabled.put(anomalyType, isSelfHealingEnabled);
        this.updateSelfHealingStateChange(anomalyType, oldValue, isSelfHealingEnabled);
        return oldValue;
    }

    private void updateSelfHealingStateChange(AnomalyType anomalyType, Boolean oldValue, boolean isSelfHealingEnabled) {
        if (oldValue == null) {
            throw new IllegalStateException(String.format("No previous value is associated with %s.", new Object[]{anomalyType}));
        }
        if (oldValue != isSelfHealingEnabled) {
            long oldStateChangeMs = this.selfHealingStateChangeTimeMs.get(oldValue).get((Object)anomalyType);
            long newStateChangeMs = this.time.milliseconds();
            if (!isSelfHealingEnabled) {
                this.selfHealingEnabledHistoricalDurationMs.merge(anomalyType, newStateChangeMs - oldStateChangeMs, Long::sum);
            }
            this.selfHealingStateChangeTimeMs.get(isSelfHealingEnabled).put(anomalyType, newStateChangeMs);
        }
    }

    private synchronized long enabledTimeMs(AnomalyType anomalyType, long nowMs) {
        long enabledTimeMs = this.selfHealingEnabledHistoricalDurationMs.get((Object)anomalyType);
        if (this.selfHealingEnabled.get((Object)anomalyType).booleanValue()) {
            Long currentEnabledSelfHealingStartTime = this.selfHealingStateChangeTimeMs.get(true).get((Object)anomalyType);
            enabledTimeMs += nowMs - (currentEnabledSelfHealingStartTime == null ? this.notifierStartTimeMs : currentEnabledSelfHealingStartTime);
        }
        return enabledTimeMs;
    }

    @Override
    public synchronized Map<AnomalyType, Float> selfHealingEnabledRatio() {
        HashMap<AnomalyType, Float> selfHealingEnabledRatio = new HashMap<AnomalyType, Float>(this.selfHealingEnabled.size());
        long nowMs = this.time.milliseconds();
        long uptimeMs = this.uptimeMs(nowMs);
        for (AnomalyType anomalyType : AnomalyType.cachedValues()) {
            long enabledTimeMs = this.enabledTimeMs(anomalyType, nowMs);
            selfHealingEnabledRatio.put(anomalyType, Float.valueOf((float)enabledTimeMs / (float)uptimeMs));
        }
        return selfHealingEnabledRatio;
    }

    @Override
    public AnomalyNotificationResult onBrokerFailure(BrokerFailures brokerFailures) {
        long earliestFailureTimeMs = Long.MAX_VALUE;
        for (long t : brokerFailures.failedBrokers().values()) {
            earliestFailureTimeMs = Math.min(earliestFailureTimeMs, t);
        }
        long nowMs = this.time.milliseconds();
        long alertTimeMs = earliestFailureTimeMs + this.brokerFailureAlertThresholdMs;
        long selfHealingTimeMs = earliestFailureTimeMs + this.selfHealingThresholdMs;
        AnomalyNotificationResult result = null;
        if (nowMs < alertTimeMs) {
            long delayMs = alertTimeMs - nowMs;
            result = AnomalyNotificationResult.check(delayMs);
        } else if (nowMs < selfHealingTimeMs) {
            this.alert(brokerFailures, false, selfHealingTimeMs, AnomalyType.BROKER_FAILURE);
            long delay = selfHealingTimeMs - nowMs;
            result = AnomalyNotificationResult.check(delay);
        } else {
            boolean autoFixTriggered = this.selfHealingEnabled.get((Object)AnomalyType.BROKER_FAILURE);
            this.alert(brokerFailures, autoFixTriggered, selfHealingTimeMs, AnomalyType.BROKER_FAILURE);
            result = autoFixTriggered ? AnomalyNotificationResult.fix() : AnomalyNotificationResult.ignore();
        }
        return result;
    }

    public void alert(Object anomaly, boolean autoFixTriggered, long selfHealingStartTime, AnomalyType anomalyType) {
        LOG.debug("{} detected {}. Self healing {}.", new Object[]{anomalyType, anomaly, this.selfHealingEnabled.get((Object)anomalyType) != false ? String.format("start time %s", KafkaCruiseControlUtils.toDateString(selfHealingStartTime)) : "is disabled"});
        if (autoFixTriggered) {
            LOG.info("Self-healing for anomaly {} has been triggered.", (Object)anomalyType);
        }
    }

    @Override
    public void configure(Map<String, ?> config) {
        this.brokerFailureAlertThresholdMs = (Long)config.get("broker.failure.alert.threshold.ms");
        this.selfHealingThresholdMs = (Long)config.get("broker.failure.self.healing.threshold.ms");
        if (this.brokerFailureAlertThresholdMs > this.selfHealingThresholdMs) {
            throw new IllegalArgumentException(String.format("The failure detection threshold %d cannot be larger than the auto fix threshold. %d", this.brokerFailureAlertThresholdMs, this.selfHealingThresholdMs));
        }
        this.selfHealingEnabled.put(AnomalyType.BROKER_FAILURE, (Boolean)config.get("self.healing.broker.failure.enabled"));
        this.selfHealingEnabled.put(AnomalyType.GOAL_VIOLATION, (Boolean)config.get("self.healing.goal.violation.enabled"));
        this.selfHealingEnabled.forEach((key, value) -> this.selfHealingStateChangeTimeMs.get(value).put((AnomalyType)((Object)key), this.notifierStartTimeMs));
    }

    @Override
    public long uptimeMs(long nowMs) {
        return nowMs - this.notifierStartTimeMs;
    }
}

