/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model;

import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import java.util.Objects;
import org.apache.kafka.common.PartitionPlacementStrategy;
import org.apache.kafka.common.message.DescribeTenantsResponseData;

public class Tenant {
    private final String tenantId;
    private Integer cellId;
    private final PartitionPlacementStrategy placementPolicy;

    public Tenant(String tenantId, Integer cellId, PartitionPlacementStrategy placementPolicy) {
        Objects.requireNonNull(KafkaCruiseControlUtils.convertEmptyToNull(tenantId));
        this.tenantId = tenantId;
        this.cellId = cellId;
        this.placementPolicy = placementPolicy;
    }

    public Tenant(DescribeTenantsResponseData.TenantDescription tenant) {
        Objects.requireNonNull(KafkaCruiseControlUtils.convertEmptyToNull(tenant.tenantId()));
        this.tenantId = tenant.tenantId();
        this.cellId = tenant.cellId();
        this.placementPolicy = PartitionPlacementStrategy.toEnum((Integer)tenant.partitionPlacementStrategy());
    }

    public String tenantId() {
        return this.tenantId;
    }

    public Integer cellId() {
        return this.cellId;
    }

    public PartitionPlacementStrategy placementPolicy() {
        return this.placementPolicy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tenant tenant = (Tenant)o;
        return this.tenantId.equals(tenant.tenantId);
    }

    public int hashCode() {
        return this.tenantId.hashCode();
    }

    public String toString() {
        return "Tenant {tenantId=" + this.tenantId + ", cellId=" + this.cellId + ", placementPolicy=" + this.placementPolicy + "}";
    }
}

