/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor;

import com.linkedin.kafka.cruisecontrol.monitor.sampling.aggregator.SampleExtrapolation;
import com.linkedin.kafka.cruisecontrol.monitor.task.LoadMonitorTaskRunner;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;

public class LoadMonitorState {
    private static final String STATE = "state";
    private static final String REASON_OF_LATEST_PAUSE_OR_RESUME = "reasonOfLatestPauseOrResume";
    private static final String NUM_MONITORED_WINDOWS = "numMonitoredWindows";
    private static final String MONITORED_WINDOWS = "monitoredWindows";
    private static final String NUM_VALID_PARTITIONS = "numValidPartitions";
    private static final String NUM_TOTAL_PARTITIONS = "numTotalPartitions";
    private static final String MONITORING_COVERAGE_PCT = "monitoringCoveragePct";
    private static final String NUM_FLAWED_PARTITIONS = "numFlawedPartitions";
    private static final String ERROR = "error";
    private final LoadMonitorTaskRunner.LoadMonitorTaskRunnerState loadMonitorTaskRunnerState;
    private final int numValidWindows;
    private final Map<Long, Float> monitoredWindows;
    private final int numValidMonitoredPartitions;
    private final Map<TopicPartition, List<SampleExtrapolation>> sampleExtrapolations;
    private final int totalNumPartitions;
    private final String reasonOfLatestPauseOrResume;

    private LoadMonitorState(LoadMonitorTaskRunner.LoadMonitorTaskRunnerState state, int numValidWindows, Map<Long, Float> monitoredWindows, int numValidMonitoredPartitions, int totalNumPartitions, Map<TopicPartition, List<SampleExtrapolation>> sampleExtrapolations, String reasonOfLatestPauseOrResume) {
        this.loadMonitorTaskRunnerState = state;
        this.numValidWindows = numValidWindows;
        this.monitoredWindows = monitoredWindows;
        this.numValidMonitoredPartitions = numValidMonitoredPartitions;
        this.sampleExtrapolations = sampleExtrapolations;
        this.totalNumPartitions = totalNumPartitions;
        this.reasonOfLatestPauseOrResume = reasonOfLatestPauseOrResume;
    }

    private LoadMonitorState(LoadMonitorTaskRunner.LoadMonitorTaskRunnerState state, int numValidWindows, Map<Long, Float> monitoredWindows, int numValidMonitoredPartitions, int totalNumPartitions, Map<TopicPartition, List<SampleExtrapolation>> sampleExtrapolations) {
        this(state, numValidWindows, monitoredWindows, numValidMonitoredPartitions, totalNumPartitions, sampleExtrapolations, null);
    }

    public static LoadMonitorState notStarted() {
        return new LoadMonitorState(LoadMonitorTaskRunner.LoadMonitorTaskRunnerState.NOT_STARTED, 0, null, 0, -1, null);
    }

    public static LoadMonitorState running(int numValidSnapshotWindows, Map<Long, Float> partitionCoverageByWindows, int numValidMonitoredTopics, int totalNumPartitions, Map<TopicPartition, List<SampleExtrapolation>> sampleExtrapolations, String reasonOfLatestPauseOrResume) {
        return new LoadMonitorState(LoadMonitorTaskRunner.LoadMonitorTaskRunnerState.RUNNING, numValidSnapshotWindows, partitionCoverageByWindows, numValidMonitoredTopics, totalNumPartitions, sampleExtrapolations, reasonOfLatestPauseOrResume);
    }

    public static LoadMonitorState paused(int numValidSnapshotWindows, Map<Long, Float> monitoredSnapshotWindows, int numValidMonitoredTopics, int totalNumPartitions, Map<TopicPartition, List<SampleExtrapolation>> sampleExtrapolations, String reasonOfLatestPauseOrResume) {
        return new LoadMonitorState(LoadMonitorTaskRunner.LoadMonitorTaskRunnerState.PAUSED, numValidSnapshotWindows, monitoredSnapshotWindows, numValidMonitoredTopics, totalNumPartitions, sampleExtrapolations, reasonOfLatestPauseOrResume);
    }

    public static LoadMonitorState sampling(int numValidSnapshotWindows, Map<Long, Float> monitoredSnapshotWindows, int numValidMonitoredTopics, int totalNumPartitions, Map<TopicPartition, List<SampleExtrapolation>> sampleExtrapolations) {
        return new LoadMonitorState(LoadMonitorTaskRunner.LoadMonitorTaskRunnerState.SAMPLING, numValidSnapshotWindows, monitoredSnapshotWindows, numValidMonitoredTopics, totalNumPartitions, sampleExtrapolations);
    }

    private void setCommonJsonGenericAttributeCollection(boolean verbose, Map<String, Object> loadMonitorState) {
        loadMonitorState.put(STATE, (Object)this.loadMonitorTaskRunnerState);
        loadMonitorState.put(NUM_MONITORED_WINDOWS, this.monitoredWindows.size());
        if (verbose) {
            loadMonitorState.put(MONITORED_WINDOWS, this.monitoredWindows);
        }
        loadMonitorState.put(NUM_VALID_PARTITIONS, this.numValidMonitoredPartitions);
        loadMonitorState.put(NUM_TOTAL_PARTITIONS, this.totalNumPartitions);
        loadMonitorState.put(MONITORING_COVERAGE_PCT, LoadMonitorState.nanToZero(this.validPartitionsRatio() * 100.0));
        loadMonitorState.put(NUM_FLAWED_PARTITIONS, this.sampleExtrapolations.size());
    }

    public Map<String, Object> getJsonStructure(boolean verbose) {
        HashMap<String, Object> loadMonitorState = new HashMap<String, Object>();
        switch (this.loadMonitorTaskRunnerState) {
            case RUNNING: 
            case SAMPLING: 
            case PAUSED: {
                this.setCommonJsonGenericAttributeCollection(verbose, loadMonitorState);
                break;
            }
        }
        switch (this.loadMonitorTaskRunnerState) {
            case RUNNING: 
            case PAUSED: {
                loadMonitorState.put(REASON_OF_LATEST_PAUSE_OR_RESUME, this.reasonOfLatestPauseOrResume == null ? "N/A" : this.reasonOfLatestPauseOrResume);
                break;
            }
            case SAMPLING: {
                break;
            }
            default: {
                loadMonitorState.put(STATE, (Object)this.loadMonitorTaskRunnerState);
                loadMonitorState.put(ERROR, "ILLEGAL_STATE_EXCEPTION");
            }
        }
        return loadMonitorState;
    }

    public static double nanToZero(double v) {
        return Double.isNaN(v) ? 0.0 : v;
    }

    public String toString() {
        float validPartitionPercent = (float)this.numValidMonitoredPartitions / (float)this.totalNumPartitions;
        float validWindowPercent = (float)this.numValidWindows / (float)this.monitoredWindows.size();
        switch (this.loadMonitorTaskRunnerState) {
            case NOT_STARTED: {
                return String.format("{state: %s}", new Object[]{this.loadMonitorTaskRunnerState});
            }
            case RUNNING: 
            case PAUSED: {
                return String.format("{state: %s, NumValidWindows: (%d/%d) (%.3f%%), NumValidPartitions: %d/%d (%.3f%%), flawedPartitions: %d%s}", new Object[]{this.loadMonitorTaskRunnerState, this.numValidWindows, this.monitoredWindows.size(), Float.valueOf(validWindowPercent * 100.0f), this.numValidMonitoredPartitions, this.totalNumPartitions, Float.valueOf(validPartitionPercent * 100.0f), this.sampleExtrapolations.size(), this.reasonOfLatestPauseOrResume == null ? "" : String.format(", reasonOfPauseOrResume: %s", this.reasonOfLatestPauseOrResume)});
            }
            case SAMPLING: {
                return String.format("{state: %s, NumValidWindows: (%d/%d) (%.3f%%), NumValidPartitions: %d/%d (%.3f%%), flawedPartitions: %d}", new Object[]{this.loadMonitorTaskRunnerState, this.numValidWindows, this.monitoredWindows.size(), Float.valueOf(validWindowPercent * 100.0f), this.numValidMonitoredPartitions, this.totalNumPartitions, Float.valueOf(validPartitionPercent * 100.0f), this.sampleExtrapolations.size()});
            }
        }
        throw new IllegalStateException("Should never be here");
    }

    public LoadMonitorTaskRunner.LoadMonitorTaskRunnerState state() {
        return this.loadMonitorTaskRunnerState;
    }

    public int numValidWindows() {
        return this.numValidWindows;
    }

    public Map<Long, Float> monitoredWindows() {
        return this.monitoredWindows;
    }

    public int numValidPartitions() {
        return this.numValidMonitoredPartitions;
    }

    public double validPartitionsRatio() {
        return (double)this.numValidMonitoredPartitions / (double)this.totalNumPartitions;
    }
}

