/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor.sampling.holder;

import com.linkedin.kafka.cruisecontrol.metricsreporter.metric.CruiseControlMetric;
import com.linkedin.kafka.cruisecontrol.metricsreporter.metric.RawMetricType;
import com.linkedin.kafka.cruisecontrol.monitor.metricdefinition.KafkaMetricDef;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.ValueAndCount;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.ValueAndTime;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.ValueHolder;
import java.util.HashMap;
import java.util.Map;

class RawMetricsHolder {
    private final Map<RawMetricType, ValueHolder> rawMetricsByType = new HashMap<RawMetricType, ValueHolder>();

    RawMetricsHolder() {
    }

    void recordCruiseControlMetric(CruiseControlMetric ccm) {
        RawMetricType rawMetricType = ccm.rawMetricType();
        ValueHolder valueHolder = this.rawMetricsByType.computeIfAbsent(rawMetricType, mt -> RawMetricsHolder.getValueHolderFor(rawMetricType));
        valueHolder.recordValue(ccm.value(), ccm.time());
    }

    void setRawMetricValue(RawMetricType rawMetricType, double value, long time) {
        this.rawMetricsByType.compute(rawMetricType, (type, vh) -> {
            ValueHolder valueHolder = vh == null ? RawMetricsHolder.getValueHolderFor(rawMetricType) : vh;
            valueHolder.reset();
            valueHolder.recordValue(value, time);
            return valueHolder;
        });
    }

    ValueHolder metricValue(RawMetricType rawMetricType) {
        return this.rawMetricsByType.get((Object)rawMetricType);
    }

    private static ValueHolder getValueHolderFor(RawMetricType rawMetricType) {
        switch (KafkaMetricDef.valueComputingStrategyForRawMetricType(rawMetricType)) {
            case AVG: {
                return new ValueAndCount();
            }
            case LATEST: {
                return new ValueAndTime();
            }
        }
        throw new IllegalStateException("Should never be here");
    }
}

