/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor.task;

import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.common.KafkaCruiseControlThreadFactory;
import com.linkedin.kafka.cruisecontrol.common.MetadataClient;
import com.linkedin.kafka.cruisecontrol.config.BrokerCapacityConfigResolver;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.MetricFetcherManager;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.SamplingOptions;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.SamplingUtils;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.aggregator.KafkaPartitionMetricSampleAggregator;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.aggregator.KafkaReplicaMetricSampleAggregator;
import com.yammer.metrics.core.Meter;
import io.confluent.databalancer.metrics.DataBalancerMetricsRegistry;
import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.Immutable;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadMonitorTaskRunner {
    private static final Logger LOG = LoggerFactory.getLogger(LoadMonitorTaskRunner.class);
    public static final String SAMPLING_LOOP_FAILURE_RATE_METRIC_NAME = "metric-sampling-loop-failure-rate";
    public static final String SAMPLING_LOOP_SUCCESS_RATE_METRIC_NAME = "metric-sampling-loop-success-rate";
    public static final String SAMPLING_LOOP_SKIPPED_RATE_METRIC_NAME = "metric-sampling-loop-skipped-rate";
    private final DataBalancerMetricsRegistry metricRegistry;
    private final Time time;
    private final CountDownLatch samplingLatch = new CountDownLatch(1);
    private final MetricFetcherManager metricFetcherManager;
    private final MetadataClient metadataClient;
    private ScheduledExecutorService samplingScheduler;
    private long samplingIntervalMs;
    private final KafkaCruiseControlConfig config;
    private static final int NUM_THREADS = 1;
    private AtomicReference<LoadMonitorTaskRunnerState> state;
    private volatile boolean awaitingPauseSampling;
    private volatile String reasonOfLatestPauseOrResume;
    private volatile SamplingUtils.MetricsWindow windowAtLastResumeTime;
    public static final Duration SAMPLING_ERROR_BACKOFF_DURATION = Duration.ofMinutes(1L);
    private Meter samplingFetcherFailureRate;
    private Meter samplingFetcherSkippedRate;
    private Meter samplingFetcherSuccessRate;

    public LoadMonitorTaskRunner(KafkaCruiseControlConfig config, KafkaReplicaMetricSampleAggregator replicaMetricSampleAggregator, KafkaPartitionMetricSampleAggregator partitionMetricSampleAggregator, MetadataClient metadataClient, Time time, DataBalancerMetricsRegistry metricRegistry, BrokerCapacityConfigResolver brokerCapacityConfigResolver) {
        this(config, metricRegistry, new MetricFetcherManager(config, replicaMetricSampleAggregator, partitionMetricSampleAggregator, time, metricRegistry, brokerCapacityConfigResolver, null), metadataClient, time, Executors.newScheduledThreadPool(1, new KafkaCruiseControlThreadFactory("SamplingScheduler", true, LOG)));
    }

    LoadMonitorTaskRunner(KafkaCruiseControlConfig config, DataBalancerMetricsRegistry metricRegistry, MetricFetcherManager metricFetcherManager, MetadataClient metadataClient, Time time, ScheduledExecutorService samplingScheduler) {
        this.config = config;
        this.metricRegistry = metricRegistry;
        this.time = time;
        this.metricFetcherManager = metricFetcherManager;
        this.metadataClient = metadataClient;
        this.awaitingPauseSampling = false;
        this.reasonOfLatestPauseOrResume = null;
        this.samplingScheduler = samplingScheduler;
        this.state = new AtomicReference<LoadMonitorTaskRunnerState>(LoadMonitorTaskRunnerState.NOT_STARTED);
    }

    public LoadMonitorTaskRunnerState state() {
        return this.state.get();
    }

    public void start() {
        this.metricFetcherManager.start();
        this.samplingIntervalMs = this.config.samplingIntervalWindowMs();
        this.windowAtLastResumeTime = SamplingUtils.MetricsWindow.empty(this.samplingIntervalMs);
        this.samplingFetcherFailureRate = this.metricRegistry.newMeter(MetricFetcherManager.class, SAMPLING_LOOP_FAILURE_RATE_METRIC_NAME, "metric-sampling-errors", TimeUnit.SECONDS);
        this.samplingFetcherSuccessRate = this.metricRegistry.newMeter(MetricFetcherManager.class, SAMPLING_LOOP_SUCCESS_RATE_METRIC_NAME, "metric-sampling-runs", TimeUnit.SECONDS);
        this.samplingFetcherSkippedRate = this.metricRegistry.newMeter(MetricFetcherManager.class, SAMPLING_LOOP_SKIPPED_RATE_METRIC_NAME, "metric-sampling-skips", TimeUnit.SECONDS);
        if (!this.compareAndSetState(LoadMonitorTaskRunnerState.NOT_STARTED, LoadMonitorTaskRunnerState.RUNNING)) {
            throw new IllegalStateException("Cannot start the task runner because the load monitor is in " + (Object)((Object)this.state.get()) + " state.");
        }
        this.samplingScheduler.schedule(new LongRunningSamplingTask(this.metadataClient, this.metricFetcherManager, this.time, this.samplingLatch), 0L, TimeUnit.MILLISECONDS);
    }

    public void shutdown() {
        LOG.info("Shutting down load monitor task runner.");
        this.samplingLatch.countDown();
        KafkaCruiseControlUtils.executeSilently(this.samplingScheduler, KafkaCruiseControlUtils.getExecutorShutdownNowConsumerWithTimeout(1000L));
        KafkaCruiseControlUtils.executeSilently(this.metricFetcherManager, MetricFetcherManager::shutdown);
        LOG.info("Load monitor task runner shutdown completed.");
    }

    public synchronized void pauseSampling(String reason) {
        boolean wasPausedAlready = this.state.get() == LoadMonitorTaskRunnerState.PAUSED;
        boolean pausedSuccessfully = this.compareAndSetState(LoadMonitorTaskRunnerState.RUNNING, LoadMonitorTaskRunnerState.PAUSED);
        if (!wasPausedAlready && !pausedSuccessfully) {
            this.awaitingPauseSampling = true;
            throw new IllegalStateException("Cannot pause the load monitor because it is in " + (Object)((Object)this.state.get()) + " state.");
        }
        if (wasPausedAlready) {
            LOG.info("Pausing the load monitor a second time, the last reason was {} and the latest now is {}.", (Object)this.reasonOfLatestPauseOrResume, (Object)reason);
        } else {
            LOG.info("Pausing metrics sampling due to reason {}", (Object)reason);
        }
        this.awaitingPauseSampling = false;
        this.reasonOfLatestPauseOrResume = reason;
    }

    public synchronized void resumeSampling(String reason) {
        if (this.state.get() != LoadMonitorTaskRunnerState.RUNNING && !this.compareAndSetState(LoadMonitorTaskRunnerState.PAUSED, LoadMonitorTaskRunnerState.RUNNING)) {
            throw new IllegalStateException("Cannot resume the load monitor because it is in " + (Object)((Object)this.state.get()) + " state");
        }
        this.reasonOfLatestPauseOrResume = reason;
        long nowMs = this.time.milliseconds();
        this.windowAtLastResumeTime = SamplingUtils.currentWindow(nowMs, this.samplingIntervalMs);
        LOG.info("Resumed sampling at time {} with reason {}. The current window boundary is {}", new Object[]{nowMs, reason, this.windowAtLastResumeTime});
    }

    public String reasonOfLatestPauseOrResume() {
        return this.reasonOfLatestPauseOrResume;
    }

    public boolean awaitingPauseSampling() {
        return this.awaitingPauseSampling;
    }

    synchronized boolean compareAndSetState(LoadMonitorTaskRunnerState expectedState, LoadMonitorTaskRunnerState newState) {
        return this.state.compareAndSet(expectedState, newState);
    }

    @Immutable
    public static class WindowSamplingInstruction {
        public final NextWindowStep samplingInstruction;
        public final SamplingUtils.MetricsWindow targetWindow;
        public final long timeMs;
        public final String reason;

        public WindowSamplingInstruction(NextWindowStep samplingInstruction, SamplingUtils.MetricsWindow targetWindow, long timeMs, String reason) {
            this.samplingInstruction = samplingInstruction;
            this.timeMs = timeMs;
            this.targetWindow = targetWindow;
            this.reason = reason;
        }
    }

    public class SamplingStep {
        public final Duration sleepDuration;
        public final NextSamplingStep nextSamplingStep;
        public final SamplingUtils.MetricsWindow targetWindow;

        public SamplingStep(NextSamplingStep nextSamplingStep, WindowSamplingInstruction wis, Duration sleepDuration) {
            this.targetWindow = wis.targetWindow;
            this.nextSamplingStep = nextSamplingStep;
            this.sleepDuration = sleepDuration;
        }

        public String toString() {
            return "SamplingStep{sleepDuration=" + this.sleepDuration + ", nextSamplingStep=" + (Object)((Object)this.nextSamplingStep) + ", targetWindow=" + this.targetWindow + "}";
        }
    }

    public static enum NextSamplingStep {
        SAMPLE_AFTER,
        SKIP_SAMPLING,
        SAMPLE_NOW;

    }

    public static enum NextWindowStep {
        SLEEP_UNTIL,
        RUN_NOW;

    }

    class LongRunningSamplingTask
    implements Runnable {
        private final Time time;
        private final MetadataClient metadataClient;
        private final MetricFetcherManager metricFetcherManager;
        private final InterruptedCheck interruptedCheck;
        private final CountDownLatch countDownLatch;
        private SamplingUtils.MetricsWindow lastSampledWindow;

        LongRunningSamplingTask(MetadataClient metadataClient, MetricFetcherManager metricFetcherManager, Time time, CountDownLatch samplingLatch) {
            this(metadataClient, metricFetcherManager, time, samplingLatch, () -> samplingLatch.getCount() == 0L);
        }

        LongRunningSamplingTask(MetadataClient metadataClient, MetricFetcherManager metricFetcherManager, Time time, CountDownLatch countDownLatch, InterruptedCheck interruptedCheck) {
            this.time = time;
            this.metadataClient = metadataClient;
            this.metricFetcherManager = metricFetcherManager;
            this.interruptedCheck = interruptedCheck;
            this.countDownLatch = countDownLatch;
            this.lastSampledWindow = SamplingUtils.MetricsWindow.empty(LoadMonitorTaskRunner.this.samplingIntervalMs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.interruptedCheck.isInterrupted()) {
                try {
                    long nowMs = this.time.milliseconds();
                    long deadlineMs = nowMs + LoadMonitorTaskRunner.this.samplingIntervalMs;
                    SamplingStep currentStep = this.takeNextStep(nowMs, this.computeTargetWindow(nowMs, LoadMonitorTaskRunner.this.samplingIntervalMs, this.lastSampledWindow, LoadMonitorTaskRunner.this.windowAtLastResumeTime));
                    if (currentStep.nextSamplingStep == NextSamplingStep.SKIP_SAMPLING) {
                        if (this.sleepOrInterrupt(currentStep.sleepDuration.toMillis())) {
                            return;
                        }
                        LoadMonitorTaskRunner.this.samplingFetcherSkippedRate.mark();
                        continue;
                    }
                    if (currentStep.nextSamplingStep == NextSamplingStep.SAMPLE_AFTER) {
                        if (this.sleepOrInterrupt(currentStep.sleepDuration.toMillis())) {
                            return;
                        }
                    } else if (currentStep.nextSamplingStep != NextSamplingStep.SAMPLE_NOW) {
                        LOG.error("Unknown next sampling step {}. Skipping the current sampling interval.", (Object)currentStep.nextSamplingStep);
                        if (!this.sleepOrInterrupt(SAMPLING_ERROR_BACKOFF_DURATION.toMillis())) continue;
                        return;
                    }
                    LOG.info("Beginning to sample {}", (Object)currentStep.targetWindow);
                    boolean successfullySampled = this.sample(currentStep.targetWindow, nowMs, deadlineMs);
                    LOG.debug("Finished sampling {}", (Object)currentStep.targetWindow);
                    if (!successfullySampled) continue;
                    this.lastSampledWindow = currentStep.targetWindow;
                    LoadMonitorTaskRunner.this.samplingFetcherSuccessRate.mark();
                }
                catch (Throwable e) {
                    LOG.error("Unexpected exception caught during metric sampling sampling", e);
                    LoadMonitorTaskRunner.this.samplingFetcherFailureRate.mark();
                    this.sleepOrInterrupt(SAMPLING_ERROR_BACKOFF_DURATION.toMillis());
                }
                finally {
                    LoadMonitorTaskRunner.this.compareAndSetState(LoadMonitorTaskRunnerState.SAMPLING, LoadMonitorTaskRunnerState.RUNNING);
                }
            }
        }

        private boolean sleepOrInterrupt(long milliseconds) {
            try {
                return this.countDownLatch.await(milliseconds, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        boolean sample(SamplingUtils.MetricsWindow targetWindow, long nowMs, long deadlineMs) {
            long now = nowMs;
            long deadlineIntervalMs = Math.max(0L, deadlineMs - nowMs);
            long startMs = targetWindow.startMs();
            long endMs = targetWindow.endMsInclusive();
            while (true) {
                Cluster latestCluster = this.metadataClient.maybeRefreshMetadata().cluster();
                SamplingOptions samplingOptions = new SamplingOptions(startMs, endMs, latestCluster);
                boolean hasSamplingError = this.metricFetcherManager.fetchSamples(samplingOptions, deadlineMs - now);
                now = this.time.milliseconds();
                if (!hasSamplingError) {
                    LOG.info("Successfully finished metric sampling for time period {} to {} ({} to {}).", new Object[]{KafkaCruiseControlUtils.toTimeString(startMs), KafkaCruiseControlUtils.toTimeString(endMs), startMs, endMs});
                    return true;
                }
                if (now > deadlineMs) {
                    LOG.warn("Sampling did not finish in {} ms, skipping this sampling interval of window {}.", (Object)deadlineIntervalMs, (Object)targetWindow);
                    return false;
                }
                LOG.info("Retrying sampling interval of window {}", (Object)targetWindow);
            }
        }

        SamplingStep takeNextStep(long nowMs, WindowSamplingInstruction windowInstruction) {
            if (LoadMonitorTaskRunner.this.awaitingPauseSampling()) {
                String reason = LoadMonitorTaskRunner.this.reasonOfLatestPauseOrResume() == null ? "<unknown reason>" : LoadMonitorTaskRunner.this.reasonOfLatestPauseOrResume();
                LOG.info("The metrics sampler is awaiting pausation (reason given: {}). Sleeping for {}...", (Object)reason, (Object)SAMPLING_ERROR_BACKOFF_DURATION);
                return new SamplingStep(NextSamplingStep.SKIP_SAMPLING, windowInstruction, SAMPLING_ERROR_BACKOFF_DURATION);
            }
            if (windowInstruction.samplingInstruction == NextWindowStep.SLEEP_UNTIL) {
                long sleepIntervalMs = Math.max(windowInstruction.timeMs - nowMs, 0L);
                LOG.info("Sleeping the metrics sampler until {} (for {}ms) as instructed due to reason {}", new Object[]{KafkaCruiseControlUtils.toTimeString(windowInstruction.timeMs), sleepIntervalMs, windowInstruction.reason});
                return new SamplingStep(NextSamplingStep.SAMPLE_AFTER, windowInstruction, Duration.ofMillis(sleepIntervalMs));
            }
            if (windowInstruction.samplingInstruction != NextWindowStep.RUN_NOW) {
                LOG.warn("Computed an unknown next step {} in the sampling task. Skipping it and sleeping for the backoff duration {}.", (Object)windowInstruction.samplingInstruction, (Object)SAMPLING_ERROR_BACKOFF_DURATION);
                return new SamplingStep(NextSamplingStep.SKIP_SAMPLING, windowInstruction, SAMPLING_ERROR_BACKOFF_DURATION);
            }
            boolean transitionedToSampling = LoadMonitorTaskRunner.this.compareAndSetState(LoadMonitorTaskRunnerState.RUNNING, LoadMonitorTaskRunnerState.SAMPLING);
            if (!transitionedToSampling) {
                long resumeTimeMs = windowInstruction.targetWindow.nextWindow().endMsInclusive();
                long sleepIntervalMs = Math.max(resumeTimeMs - nowMs, 0L);
                LOG.info("Could not transition the metrics sampler to state {}. Current state is {}. Sleeping until we'd be ready for the next sampling interval {} (for {}ms)...", new Object[]{LoadMonitorTaskRunnerState.SAMPLING, LoadMonitorTaskRunner.this.state(), KafkaCruiseControlUtils.toTimeString(windowInstruction.timeMs), sleepIntervalMs});
                return new SamplingStep(NextSamplingStep.SKIP_SAMPLING, windowInstruction, Duration.ofMillis(sleepIntervalMs));
            }
            return new SamplingStep(NextSamplingStep.SAMPLE_NOW, windowInstruction, Duration.ZERO);
        }

        WindowSamplingInstruction computeTargetWindow(long nowMs, long windowMs, SamplingUtils.MetricsWindow lastSampledWindow, SamplingUtils.MetricsWindow windowAtResumeTime) {
            if (windowMs != lastSampledWindow.sizeMs() || windowMs != windowAtResumeTime.sizeMs()) {
                throw new IllegalArgumentException(String.format("Inconsistent window sizes - lastSampledWindow: %s, windowAtResumeTime: %s, windowMs: %d", lastSampledWindow, windowAtResumeTime, windowMs));
            }
            SamplingUtils.MetricsWindow currentWindow = SamplingUtils.currentWindow(nowMs, windowMs);
            if (currentWindow.index() <= windowAtResumeTime.index()) {
                SamplingUtils.MetricsWindow nextTargetWindow = windowAtResumeTime.nextWindow();
                long sleepResumeTime = nextTargetWindow.endMsInclusive();
                return new WindowSamplingInstruction(NextWindowStep.SLEEP_UNTIL, nextTargetWindow, sleepResumeTime, String.format("We have not passed the window that we last resumed at - we are currently at window %s. The sampler should sleep until the window after the resumed-window passes (%s), as the current resumed-window (%s) most likely had reassignments within it.", currentWindow.toConciseString(), nextTargetWindow.toConciseString(), windowAtResumeTime.toConciseString()));
            }
            if (currentWindow.index() <= lastSampledWindow.index()) {
                SamplingUtils.MetricsWindow nextTargetWindow = lastSampledWindow.nextWindow();
                long sleepResumeTime = nextTargetWindow.endMsInclusive();
                LOG.warn("Tried to sample a window that we've already sampled. This is unexpected - did the clock skew backwards in time? Sleeping until the end of the next window we haven't sampled... (nowMs: {}, currentWindow: {}, lastSampledWindow: {})", new Object[]{nowMs, currentWindow, lastSampledWindow});
                return new WindowSamplingInstruction(NextWindowStep.SLEEP_UNTIL, nextTargetWindow, sleepResumeTime, String.format("The sampler's current window is either behind or exactly at what it has already sampled. The sampler should sleep until the window after the last sampled window passes. (currentWindow: %s, last sampled window: %s, target window after that: %s)", currentWindow.toConciseString(), lastSampledWindow.toConciseString(), nextTargetWindow.toConciseString()));
            }
            SamplingUtils.MetricsWindow lastWindow = currentWindow.previousWindow();
            SamplingUtils.MetricsWindow nextTargetWindow = currentWindow;
            long sampleResumeMs = nextTargetWindow.endMsInclusive();
            if (lastWindow.index() == windowAtResumeTime.index()) {
                return new WindowSamplingInstruction(NextWindowStep.SLEEP_UNTIL, nextTargetWindow, sampleResumeMs, String.format("The previous window was the one we resumed at. Therefore, the current window is the first one that will be eligible for sampling. Sleeping until it passes... (lastWindow: %s, windowAtResumeTime: %s, currentWindow: %s)", lastWindow.toConciseString(), windowAtResumeTime.toConciseString(), currentWindow.toConciseString()));
            }
            if (lastWindow.index() < windowAtResumeTime.index()) {
                String msg = "The previous window is behind the window we resumed at. This code path should be impossible to enter and therefore indicates a bug, since we already checked the current window against the resumed-at window. Sleeping until the end of the current window..." + String.format(" (currentWindow: %s, previousWindow: %s, windowAtResumeTime: %s)", currentWindow, lastWindow, windowAtResumeTime);
                LOG.warn(msg);
                return new WindowSamplingInstruction(NextWindowStep.SLEEP_UNTIL, nextTargetWindow, sampleResumeMs, msg);
            }
            if (lastWindow.index() == lastSampledWindow.index()) {
                return new WindowSamplingInstruction(NextWindowStep.SLEEP_UNTIL, nextTargetWindow, sampleResumeMs, String.format("The last eligible window for sampling was already sampled. Sleeping until the end of the current window... (lastSampledWindow: %s, currentWindow: %s)", lastSampledWindow.toConciseString(), currentWindow.toConciseString()));
            }
            if (lastWindow.index() < lastSampledWindow.index()) {
                String msg = String.format("The previous window is older than the last sampled window. This code path should be impossible to enter and therefore indicates a bug, since we already checked the current window against the last sampled-at window. Sleeping until the end of the current window... (lastWindow: %s, lastSampledWindow: %s, currentWindow: %s)", lastWindow.toConciseString(), lastSampledWindow.toConciseString(), currentWindow.toConciseString());
                LOG.warn(msg);
                return new WindowSamplingInstruction(NextWindowStep.SLEEP_UNTIL, nextTargetWindow, sampleResumeMs, msg);
            }
            return new WindowSamplingInstruction(NextWindowStep.RUN_NOW, lastWindow, sampleResumeMs, String.format("The last window is eligible for sampling. Sampling now and resuming at the end of the current window... (lastWindow: %s, currentWindow: %s, nowMs: %d)", lastWindow, currentWindow, nowMs));
        }
    }

    static interface InterruptedCheck {
        public boolean isInterrupted();
    }

    public static enum LoadMonitorTaskRunnerState {
        NOT_STARTED,
        RUNNING,
        SAMPLING,
        PAUSED;

    }
}

