/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.cruisecontrol.metricsreporter;

import com.google.protobuf.InvalidProtocolBufferException;
import io.confluent.cruisecontrol.metricsreporter.TelemetryConverter;
import io.opencensus.proto.metrics.v1.Metric;
import io.opencensus.proto.metrics.v1.Point;
import io.opencensus.proto.metrics.v1.SummaryValue;
import io.opencensus.proto.metrics.v1.TimeSeries;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenCensusConverter
implements TelemetryConverter {
    public static final String BROKER_KEY = "kafka.broker.id";
    private static final Logger LOG = LoggerFactory.getLogger(OpenCensusConverter.class);

    @Override
    public <T> void convert(byte[] bytes, TelemetryConverter.MetricConsumer<T> consumer) {
        Metric metric;
        try {
            metric = Metric.parseFrom((byte[])bytes);
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error("Received exception when parsing metric data", (Throwable)e);
            return;
        }
        Optional<T> resource = consumer.brokerId(metric.getResource().getLabelsMap().getOrDefault(BROKER_KEY, ""));
        if (!resource.isPresent()) {
            return;
        }
        for (TimeSeries ts : metric.getTimeseriesList()) {
            final HashMap<String, String> labels = new HashMap<String, String>(metric.getMetricDescriptor().getLabelKeysCount());
            for (int i = 0; i < metric.getMetricDescriptor().getLabelKeysCount(); ++i) {
                labels.put(metric.getMetricDescriptor().getLabelKeys(i).getKey(), ts.getLabelValues(i).getValue());
            }
            for (final Point point : ts.getPointsList()) {
                final long timestamp = Instant.ofEpochSecond(point.getTimestamp().getSeconds(), point.getTimestamp().getNanos()).toEpochMilli();
                switch (point.getValueCase()) {
                    case INT64_VALUE: 
                    case DOUBLE_VALUE: {
                        TelemetryConverter.DataPoint dataPoint = new TelemetryConverter.DataPoint(){

                            @Override
                            public Map<String, String> labels() {
                                return labels;
                            }

                            @Override
                            public long timestamp() {
                                return timestamp;
                            }

                            @Override
                            public long asInt() {
                                return point.getInt64Value();
                            }

                            @Override
                            public double asDouble() {
                                return point.getDoubleValue();
                            }
                        };
                        consumer.consume(metric.getMetricDescriptor().getName(), resource.get(), dataPoint);
                        break;
                    }
                    case SUMMARY_VALUE: {
                        final SummaryValue.Snapshot snapshot = point.getSummaryValue().getSnapshot();
                        TelemetryConverter.Summary summary = new TelemetryConverter.Summary(){

                            @Override
                            public Map<String, String> labels() {
                                return labels;
                            }

                            @Override
                            public long timestamp() {
                                return timestamp;
                            }

                            @Override
                            public Stream<TelemetryConverter.QuantileValue> quantiles() {
                                return snapshot.getPercentileValuesList().stream().map(pv -> new TelemetryConverter.QuantileValue((SummaryValue.Snapshot.ValueAtPercentile)pv){
                                    final /* synthetic */ SummaryValue.Snapshot.ValueAtPercentile val$pv;
                                    {
                                        this.val$pv = valueAtPercentile;
                                    }

                                    @Override
                                    public double quantile() {
                                        return this.val$pv.getPercentile() / 100.0;
                                    }

                                    @Override
                                    public double value() {
                                        return this.val$pv.getValue();
                                    }
                                });
                            }

                            @Override
                            public double sum() {
                                return snapshot.getSum().getValue();
                            }

                            @Override
                            public long count() {
                                return snapshot.getCount().getValue();
                            }
                        };
                        consumer.consume(metric.getMetricDescriptor().getName(), resource.get(), summary);
                        break;
                    }
                }
            }
        }
    }
}

